/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.tpch;

import com.google.common.base.Preconditions;
import io.airlift.tpch.GenerateUtils;
import io.airlift.tpch.TpchEntity;
import java.util.Locale;

public class LineItem
implements TpchEntity {
    private final long orderKey;
    private final long partKey;
    private final long supplierKey;
    private final long lineNumber;
    private final long quantity;
    private final long extendedPrice;
    private final long discount;
    private final long tax;
    private final String returnFlag;
    private final String status;
    private final String shipDate;
    private final String commitDate;
    private final String receiptDate;
    private final String shipInstructions;
    private final String shipMode;
    private final String comment;

    public LineItem(long orderKey, long partKey, long supplierKey, long lineNumber, long quantity, long extendedPrice, long discount, long tax, String returnFlag, String status, String shipDate, String commitDate, String receiptDate, String shipInstructions, String shipMode, String comment) {
        this.orderKey = orderKey;
        this.partKey = partKey;
        this.supplierKey = supplierKey;
        this.lineNumber = lineNumber;
        this.quantity = quantity;
        this.extendedPrice = extendedPrice;
        this.discount = discount;
        this.tax = tax;
        this.returnFlag = (String)Preconditions.checkNotNull((Object)returnFlag, (Object)"returnFlag is null");
        this.status = (String)Preconditions.checkNotNull((Object)status, (Object)"status is null");
        this.shipDate = (String)Preconditions.checkNotNull((Object)shipDate, (Object)"shipDate is null");
        this.commitDate = (String)Preconditions.checkNotNull((Object)commitDate, (Object)"commitDate is null");
        this.receiptDate = (String)Preconditions.checkNotNull((Object)receiptDate, (Object)"receiptDate is null");
        this.shipInstructions = (String)Preconditions.checkNotNull((Object)shipInstructions, (Object)"shipInstructions is null");
        this.shipMode = (String)Preconditions.checkNotNull((Object)shipMode, (Object)"shipMode is null");
        this.comment = (String)Preconditions.checkNotNull((Object)comment, (Object)"comment is null");
    }

    public long getOrderKey() {
        return this.orderKey;
    }

    public long getPartKey() {
        return this.partKey;
    }

    public long getSupplierKey() {
        return this.supplierKey;
    }

    public long getLineNumber() {
        return this.lineNumber;
    }

    public long getQuantity() {
        return this.quantity;
    }

    public double getExtendedPrice() {
        return (double)this.extendedPrice / 100.0;
    }

    public double getDiscount() {
        return (double)this.discount / 100.0;
    }

    public double getTax() {
        return (double)this.tax / 100.0;
    }

    public String getReturnFlag() {
        return this.returnFlag;
    }

    public String getStatus() {
        return this.status;
    }

    public String getShipDate() {
        return this.shipDate;
    }

    public String getCommitDate() {
        return this.commitDate;
    }

    public String getReceiptDate() {
        return this.receiptDate;
    }

    public String getShipInstructions() {
        return this.shipInstructions;
    }

    public String getShipMode() {
        return this.shipMode;
    }

    public String getComment() {
        return this.comment;
    }

    @Override
    public String toLine() {
        return String.format(Locale.ENGLISH, "%d|%d|%d|%d|%d|%s|%s|%s|%s|%s|%s|%s|%s|%s|%s|%s|", this.orderKey, this.partKey, this.supplierKey, this.lineNumber, this.quantity, GenerateUtils.formatMoney(this.extendedPrice), GenerateUtils.formatMoney(this.discount), GenerateUtils.formatMoney(this.tax), this.returnFlag, this.status, this.shipDate, this.commitDate, this.receiptDate, this.shipInstructions, this.shipMode, this.comment);
    }
}

