/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.tpch;

import com.google.common.base.Preconditions;
import io.airlift.tpch.TpchEntity;
import java.util.Locale;

public class Nation
implements TpchEntity {
    private final long nationKey;
    private final String name;
    private final long regionKey;
    private final String comment;

    public Nation(long nationKey, String name, long regionKey, String comment) {
        this.nationKey = nationKey;
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name is null");
        this.regionKey = regionKey;
        this.comment = (String)Preconditions.checkNotNull((Object)comment, (Object)"comment is null");
    }

    public long getNationKey() {
        return this.nationKey;
    }

    public String getName() {
        return this.name;
    }

    public long getRegionKey() {
        return this.regionKey;
    }

    public String getComment() {
        return this.comment;
    }

    @Override
    public String toLine() {
        return String.format(Locale.ENGLISH, "%d|%s|%d|%s|", this.nationKey, this.name, this.regionKey, this.comment);
    }
}

