/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.tpch;

import com.google.common.base.Preconditions;
import io.airlift.tpch.GenerateUtils;
import io.airlift.tpch.TpchEntity;
import java.util.Locale;

public class Order
implements TpchEntity {
    private final long orderKey;
    private final long customerKey;
    private final char orderStatus;
    private final long totalPrice;
    private final String orderDate;
    private final String orderPriority;
    private final String clerk;
    private final long shipPriority;
    private final String comment;

    public Order(long orderKey, long customerKey, char orderStatus, long totalPrice, String orderDate, String orderPriority, String clerk, long shipPriority, String comment) {
        this.orderKey = orderKey;
        this.customerKey = customerKey;
        this.orderStatus = orderStatus;
        this.totalPrice = totalPrice;
        this.orderDate = (String)Preconditions.checkNotNull((Object)orderDate, (Object)"orderDate is null");
        this.orderPriority = (String)Preconditions.checkNotNull((Object)orderPriority, (Object)"orderPriority is null");
        this.clerk = (String)Preconditions.checkNotNull((Object)clerk, (Object)"clerk is null");
        this.shipPriority = shipPriority;
        this.comment = (String)Preconditions.checkNotNull((Object)comment, (Object)"comment is null");
    }

    public long getOrderKey() {
        return this.orderKey;
    }

    public long getCustomerKey() {
        return this.customerKey;
    }

    public char getOrderStatus() {
        return this.orderStatus;
    }

    public double getTotalPrice() {
        return (double)this.totalPrice / 100.0;
    }

    public String getOrderDate() {
        return this.orderDate;
    }

    public String getOrderPriority() {
        return this.orderPriority;
    }

    public String getClerk() {
        return this.clerk;
    }

    public long getShipPriority() {
        return this.shipPriority;
    }

    public String getComment() {
        return this.comment;
    }

    @Override
    public String toLine() {
        return String.format(Locale.ENGLISH, "%d|%d|%s|%s|%s|%s|%s|%d|%s|", this.orderKey, this.customerKey, Character.valueOf(this.orderStatus), GenerateUtils.formatMoney(this.totalPrice), this.orderDate, this.orderPriority, this.clerk, this.shipPriority, this.comment);
    }
}

