/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.tpch;

import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractIterator;
import io.airlift.tpch.Distributions;
import io.airlift.tpch.GenerateUtils;
import io.airlift.tpch.LineItemGenerator;
import io.airlift.tpch.Order;
import io.airlift.tpch.PartGenerator;
import io.airlift.tpch.RandomBoundedInt;
import io.airlift.tpch.RandomBoundedLong;
import io.airlift.tpch.RandomString;
import io.airlift.tpch.RandomText;
import io.airlift.tpch.TextPool;
import java.util.Iterator;
import java.util.Locale;

public class OrderGenerator
implements Iterable<Order> {
    public static final int SCALE_BASE = 1500000;
    public static final int CUSTOMER_MORTALITY = 3;
    private static final int ORDER_DATE_MIN = 92001;
    private static final int ORDER_DATE_MAX = 94406;
    private static final int CLERK_SCALE_BASE = 1000;
    private static final int LINE_COUNT_MIN = 1;
    static final int LINE_COUNT_MAX = 7;
    private static final int COMMENT_AVERAGE_LENGTH = 49;
    private static final int ORDER_KEY_SPARSE_BITS = 2;
    private static final int ORDER_KEY_SPARSE_KEEP = 3;
    private final double scaleFactor;
    private final int part;
    private final int partCount;
    private final Distributions distributions;
    private final TextPool textPool;

    public OrderGenerator(double scaleFactor, int part, int partCount) {
        this(scaleFactor, part, partCount, Distributions.getDefaultDistributions(), TextPool.getDefaultTestPool());
    }

    public OrderGenerator(double scaleFactor, int part, int partCount, Distributions distributions, TextPool textPool) {
        Preconditions.checkArgument((scaleFactor > 0.0 ? 1 : 0) != 0, (Object)"scaleFactor must be greater than 0");
        Preconditions.checkArgument((part >= 1 ? 1 : 0) != 0, (Object)"part must be at least 1");
        Preconditions.checkArgument((part <= partCount ? 1 : 0) != 0, (Object)"part must be less than or equal to part count");
        this.scaleFactor = scaleFactor;
        this.part = part;
        this.partCount = partCount;
        this.distributions = (Distributions)Preconditions.checkNotNull((Object)distributions, (Object)"distributions is null");
        this.textPool = (TextPool)Preconditions.checkNotNull((Object)textPool, (Object)"textPool is null");
    }

    @Override
    public Iterator<Order> iterator() {
        return new OrderGeneratorIterator(this.distributions, this.textPool, this.scaleFactor, GenerateUtils.calculateStartIndex(1500000, this.scaleFactor, this.part, this.partCount), GenerateUtils.calculateRowCount(1500000, this.scaleFactor, this.part, this.partCount));
    }

    static RandomBoundedInt createLineCountRandom() {
        return new RandomBoundedInt(1434868289L, 1, 7);
    }

    static RandomBoundedInt createOrderDateRandom() {
        return new RandomBoundedInt(1066728069L, 92001, 94406);
    }

    static long makeOrderKey(long orderIndex) {
        long low_bits = orderIndex & 7L;
        long ok = orderIndex;
        ok >>= 3;
        ok <<= 2;
        ok <<= 3;
        return ok += low_bits;
    }

    private static class OrderGeneratorIterator
    extends AbstractIterator<Order> {
        private final RandomBoundedInt orderDateRandom = OrderGenerator.createOrderDateRandom();
        private final RandomBoundedInt lineCountRandom = OrderGenerator.createLineCountRandom();
        private final RandomBoundedLong customerKeyRandom;
        private final RandomString orderPriorityRandom;
        private final RandomBoundedInt clerkRandom;
        private final RandomText commentRandom;
        private final RandomBoundedInt lineQuantityRandom = LineItemGenerator.createQuantityRandom();
        private final RandomBoundedInt lineDiscountRandom = LineItemGenerator.createDiscountRandom();
        private final RandomBoundedInt lineTaxRandom = LineItemGenerator.createTaxRandom();
        private final RandomBoundedLong linePartKeyRandom;
        private final RandomBoundedInt lineShipDateRandom = LineItemGenerator.createShipDateRandom();
        private final long startIndex;
        private final long rowCount;
        private final long maxCustomerKey;
        private long index;

        private OrderGeneratorIterator(Distributions distributions, TextPool textPool, double scaleFactor, long startIndex, long rowCount) {
            this.startIndex = startIndex;
            this.rowCount = rowCount;
            this.clerkRandom = new RandomBoundedInt(1171034773L, 1, Math.max((int)(scaleFactor * 1000.0), 1000));
            this.maxCustomerKey = (long)(150000.0 * scaleFactor);
            this.customerKeyRandom = new RandomBoundedLong(851767375L, scaleFactor >= 30000.0, 1L, this.maxCustomerKey);
            this.orderPriorityRandom = new RandomString(591449447L, distributions.getOrderPriorities());
            this.commentRandom = new RandomText(276090261L, textPool, 49.0);
            this.linePartKeyRandom = LineItemGenerator.createPartKeyRandom(scaleFactor);
            this.orderDateRandom.advanceRows(startIndex);
            this.lineCountRandom.advanceRows(startIndex);
            this.customerKeyRandom.advanceRows(startIndex);
            this.orderPriorityRandom.advanceRows(startIndex);
            this.clerkRandom.advanceRows(startIndex);
            this.commentRandom.advanceRows(startIndex);
            this.lineQuantityRandom.advanceRows(startIndex);
            this.lineDiscountRandom.advanceRows(startIndex);
            this.lineShipDateRandom.advanceRows(startIndex);
            this.lineTaxRandom.advanceRows(startIndex);
            this.linePartKeyRandom.advanceRows(startIndex);
        }

        protected Order computeNext() {
            if (this.index >= this.rowCount) {
                return (Order)this.endOfData();
            }
            Order order = this.makeOrder(this.startIndex + this.index + 1L);
            this.orderDateRandom.rowFinished();
            this.lineCountRandom.rowFinished();
            this.customerKeyRandom.rowFinished();
            this.orderPriorityRandom.rowFinished();
            this.clerkRandom.rowFinished();
            this.commentRandom.rowFinished();
            this.lineQuantityRandom.rowFinished();
            this.lineDiscountRandom.rowFinished();
            this.lineShipDateRandom.rowFinished();
            this.lineTaxRandom.rowFinished();
            this.linePartKeyRandom.rowFinished();
            ++this.index;
            return order;
        }

        private Order makeOrder(long index) {
            long orderKey = OrderGenerator.makeOrderKey(index);
            int orderDate = this.orderDateRandom.nextValue();
            long customerKey = this.customerKeyRandom.nextValue();
            int delta = 1;
            while (customerKey % 3L == 0L) {
                customerKey += (long)delta;
                customerKey = Math.min(customerKey, this.maxCustomerKey);
                delta *= -1;
            }
            long totalPrice = 0L;
            int shippedCount = 0;
            int lineCount = this.lineCountRandom.nextValue();
            for (long lineNumber = 0L; lineNumber < (long)lineCount; ++lineNumber) {
                int quantity = this.lineQuantityRandom.nextValue();
                int discount = this.lineDiscountRandom.nextValue();
                int tax = this.lineTaxRandom.nextValue();
                long partKey = this.linePartKeyRandom.nextValue();
                long partPrice = PartGenerator.calculatePartPrice(partKey);
                long extendedPrice = partPrice * (long)quantity;
                long discountedPrice = extendedPrice * (long)(100 - discount);
                totalPrice += discountedPrice / 100L * (long)(100 + tax) / 100L;
                int shipDate = this.lineShipDateRandom.nextValue();
                if (!GenerateUtils.isInPast(shipDate += orderDate)) continue;
                ++shippedCount;
            }
            char orderStatus = shippedCount == lineCount ? (char)'F' : (shippedCount > 0 ? (char)'P' : 'O');
            return new Order(orderKey, customerKey, orderStatus, totalPrice, GenerateUtils.toDateString(orderDate), this.orderPriorityRandom.nextValue(), String.format(Locale.ENGLISH, "Clerk#%09d", this.clerkRandom.nextValue()), 0L, this.commentRandom.nextValue());
        }
    }
}

