/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.tpch;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import io.airlift.tpch.AbstractRandomInt;
import io.airlift.tpch.Distribution;
import java.util.ArrayList;
import java.util.Collections;

public class RandomStringSequence
extends AbstractRandomInt {
    private final int count;
    private final Distribution distribution;

    public RandomStringSequence(long seed, int count, Distribution distribution) {
        this(seed, count, distribution, 1);
    }

    public RandomStringSequence(long seed, int count, Distribution distribution, int expectedRowCount) {
        super(seed, distribution.size() * expectedRowCount);
        this.count = count;
        this.distribution = distribution;
    }

    public String nextValue() {
        ArrayList<String> values = new ArrayList<String>(this.distribution.getValues());
        Preconditions.checkArgument((this.count < values.size() ? 1 : 0) != 0, (Object)"Count must be less tess than distribution size");
        for (int currentPosition = 0; currentPosition < this.count; ++currentPosition) {
            int swapPosition = this.nextInt(currentPosition, values.size() - 1);
            Collections.swap(values, currentPosition, swapPosition);
        }
        String result = Joiner.on((char)' ').join(values.subList(0, this.count));
        return result;
    }
}

