/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.tpch;

import com.google.common.base.Preconditions;
import io.airlift.tpch.TpchEntity;
import java.util.Locale;

public class Region
implements TpchEntity {
    private final long regionKey;
    private final String name;
    private final String comment;

    public Region(long regionKey, String name, String comment) {
        this.regionKey = regionKey;
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name is null");
        this.comment = (String)Preconditions.checkNotNull((Object)comment, (Object)"comment is null");
    }

    public long getRegionKey() {
        return this.regionKey;
    }

    public String getName() {
        return this.name;
    }

    public String getComment() {
        return this.comment;
    }

    @Override
    public String toLine() {
        return String.format(Locale.ENGLISH, "%d|%s|%s|", this.regionKey, this.name, this.comment);
    }
}

