/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.tpch;

import com.google.common.base.Preconditions;
import io.airlift.tpch.GenerateUtils;
import io.airlift.tpch.TpchEntity;
import java.util.Locale;

public class Supplier
implements TpchEntity {
    public long supplierKey;
    public String name;
    public String address;
    public long nationKey;
    public String phone;
    public long accountBalance;
    public String comment;

    public Supplier(long supplierKey, String name, String address, long nationKey, String phone, long accountBalance, String comment) {
        this.supplierKey = supplierKey;
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name is null");
        this.address = (String)Preconditions.checkNotNull((Object)address, (Object)"address is null");
        this.nationKey = nationKey;
        this.phone = (String)Preconditions.checkNotNull((Object)phone, (Object)"phone is null");
        this.accountBalance = accountBalance;
        this.comment = (String)Preconditions.checkNotNull((Object)comment, (Object)"comment is null");
    }

    public long getSupplierKey() {
        return this.supplierKey;
    }

    public String getName() {
        return this.name;
    }

    public String getAddress() {
        return this.address;
    }

    public long getNationKey() {
        return this.nationKey;
    }

    public String getPhone() {
        return this.phone;
    }

    public double getAccountBalance() {
        return (double)this.accountBalance / 100.0;
    }

    public String getComment() {
        return this.comment;
    }

    @Override
    public String toLine() {
        return String.format(Locale.ENGLISH, "%d|%s|%s|%d|%s|%s|%s|", this.supplierKey, this.name, this.address, this.nationKey, this.phone, GenerateUtils.formatMoney(this.accountBalance), this.comment);
    }
}

