/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.tpch;

import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import io.airlift.tpch.Distribution;
import io.airlift.tpch.Distributions;
import io.airlift.tpch.RandomInt;
import java.util.Iterator;

public class TextPool {
    private static final int DEFAULT_TEXT_POOL_SIZE = 314572800;
    private static final int MAX_SENTENCE_LENGTH = 256;
    private static TextPool DEFAULT_TEXT_POOL;
    private final String textPool;

    public static synchronized TextPool getDefaultTestPool() {
        if (DEFAULT_TEXT_POOL == null) {
            DEFAULT_TEXT_POOL = new TextPool(314572800, Distributions.getDefaultDistributions());
        }
        return DEFAULT_TEXT_POOL;
    }

    public TextPool(int size, Distributions distributions) {
        this(size, distributions, new TextGenerationProgressMonitor(){

            @Override
            public void updateProgress(double progress) {
            }
        });
    }

    public TextPool(int size, Distributions distributions, TextGenerationProgressMonitor monitor) {
        Preconditions.checkNotNull((Object)distributions, (Object)"distributions is null");
        Preconditions.checkNotNull((Object)monitor, (Object)"monitor is null");
        StringBuilder output = new StringBuilder(size + 256);
        RandomInt randomInt = new RandomInt(933588178L, Integer.MAX_VALUE);
        while (output.length() < size) {
            TextPool.generateSentence(distributions, output, randomInt);
            monitor.updateProgress(Math.min(1.0 * (double)output.length() / (double)size, 1.0));
        }
        output.setLength(size);
        this.textPool = output.toString();
    }

    public int size() {
        return this.textPool.length();
    }

    public String getText(int offset, int length) {
        return this.textPool.substring(offset, length);
    }

    private static void generateSentence(Distributions distributions, StringBuilder builder, RandomInt random) {
        String syntax = distributions.getGrammars().randomValue(random);
        Iterator i$ = Splitter.on((CharMatcher)CharMatcher.WHITESPACE).split((CharSequence)syntax).iterator();
        while (i$.hasNext()) {
            String token;
            switch (token = (String)i$.next()) {
                case "V": {
                    TextPool.generateVerbPhrase(distributions, builder, random);
                    break;
                }
                case "N": {
                    TextPool.generateNounPhrase(distributions, builder, random);
                    break;
                }
                case "P": {
                    String preposition = distributions.getPrepositions().randomValue(random);
                    builder.append(preposition);
                    builder.append(" the ");
                    TextPool.generateNounPhrase(distributions, builder, random);
                    break;
                }
                case "T": {
                    builder.setLength(builder.length() - 1);
                    String terminator = distributions.getTerminators().randomValue(random);
                    builder.append(terminator);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown token '" + token + "'");
                }
            }
            if (builder.charAt(builder.length() - 1) == ' ') continue;
            builder.append(' ');
        }
    }

    private static void generateVerbPhrase(Distributions distributions, StringBuilder builder, RandomInt random) {
        String syntax = distributions.getVerbPhrase().randomValue(random);
        Iterator i$ = Splitter.on((char)' ').split((CharSequence)syntax).iterator();
        while (i$.hasNext()) {
            Distribution source;
            String token;
            switch (token = (String)i$.next()) {
                case "D": {
                    source = distributions.getAdverbs();
                    break;
                }
                case "V": {
                    source = distributions.getVerbs();
                    break;
                }
                case "X": {
                    source = distributions.getAuxiliaries();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown token '" + token + "'");
                }
            }
            String word = source.randomValue(random);
            builder.append(word);
            builder.append(token.substring(1));
            builder.append(" ");
        }
    }

    private static void generateNounPhrase(Distributions distributions, StringBuilder builder, RandomInt random) {
        String syntax = distributions.getNounPhrase().randomValue(random);
        for (String token : Splitter.on((char)' ').split((CharSequence)syntax)) {
            Distribution source;
            switch (token.charAt(0)) {
                case 'A': {
                    source = distributions.getArticles();
                    break;
                }
                case 'J': {
                    source = distributions.getAdjectives();
                    break;
                }
                case 'D': {
                    source = distributions.getAdverbs();
                    break;
                }
                case 'N': {
                    source = distributions.getNouns();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown token '" + token + "'");
                }
            }
            String word = source.randomValue(random);
            builder.append(word);
            builder.append(token.substring(1));
            builder.append(" ");
        }
    }

    public static interface TextGenerationProgressMonitor {
        public void updateProgress(double var1);
    }
}

