/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hive.HdfsConfiguration;
import com.google.common.base.Preconditions;
import javax.inject.Inject;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;

public class HdfsEnvironment {
    private final HdfsConfiguration hdfsConfiguration;

    @Inject
    public HdfsEnvironment(HdfsConfiguration hdfsConfiguration) {
        this.hdfsConfiguration = (HdfsConfiguration)Preconditions.checkNotNull((Object)hdfsConfiguration, (Object)"hdfsConfiguration is null");
    }

    public Configuration getConfiguration(Path path) {
        String host = path.toUri().getHost();
        Preconditions.checkArgument((host != null ? 1 : 0) != 0, (String)"path host is null: %s", (Object[])new Object[]{path});
        return this.hdfsConfiguration.getConfiguration(host);
    }

    public Path wrapInputPath(Path path) {
        return path;
    }
}

