/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.google.common.base.Splitter;
import com.google.common.base.StandardSystemProperty;
import com.google.common.collect.ImmutableList;
import com.google.common.net.HostAndPort;
import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.airlift.units.MinDuration;
import java.io.File;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

public class HiveClientConfig {
    private static final Splitter SPLITTER = Splitter.on((char)',').trimResults().omitEmptyStrings();
    private DataSize maxSplitSize = new DataSize(64.0, DataSize.Unit.MEGABYTE);
    private int maxOutstandingSplits = 1000;
    private int maxGlobalSplitIteratorThreads = 1000;
    private int maxSplitIteratorThreads = 50;
    private int minPartitionBatchSize = 10;
    private int maxPartitionBatchSize = 100;
    private Duration metastoreCacheTtl = new Duration(1.0, TimeUnit.HOURS);
    private Duration metastoreRefreshInterval = new Duration(2.0, TimeUnit.MINUTES);
    private int maxMetastoreRefreshThreads = 100;
    private HostAndPort metastoreSocksProxy;
    private Duration metastoreTimeout = new Duration(10.0, TimeUnit.SECONDS);
    private Duration fileSystemCacheTtl = new Duration(1.0, TimeUnit.DAYS);
    private Duration dfsTimeout = new Duration(10.0, TimeUnit.SECONDS);
    private Duration dfsConnectTimeout = new Duration(500.0, TimeUnit.MILLISECONDS);
    private int dfsConnectMaxRetries = 5;
    private String domainSocketPath;
    private String s3AwsAccessKey;
    private String s3AwsSecretKey;
    private boolean s3SslEnabled = true;
    private int s3MaxClientRetries = 3;
    private int s3MaxErrorRetries = 10;
    private Duration s3ConnectTimeout = new Duration(5.0, TimeUnit.SECONDS);
    private File s3StagingDirectory = new File(StandardSystemProperty.JAVA_IO_TMPDIR.value());
    private List<String> resourceConfigFiles;

    @NotNull
    public DataSize getMaxSplitSize() {
        return this.maxSplitSize;
    }

    @Config(value="hive.max-split-size")
    public HiveClientConfig setMaxSplitSize(DataSize maxSplitSize) {
        this.maxSplitSize = maxSplitSize;
        return this;
    }

    @Min(value=1L)
    public int getMaxOutstandingSplits() {
        return this.maxOutstandingSplits;
    }

    @Config(value="hive.max-outstanding-splits")
    public HiveClientConfig setMaxOutstandingSplits(int maxOutstandingSplits) {
        this.maxOutstandingSplits = maxOutstandingSplits;
        return this;
    }

    @Min(value=1L)
    public int getMaxSplitIteratorThreads() {
        return this.maxSplitIteratorThreads;
    }

    @Config(value="hive.max-split-iterator-threads")
    public HiveClientConfig setMaxSplitIteratorThreads(int maxSplitIteratorThreads) {
        this.maxSplitIteratorThreads = maxSplitIteratorThreads;
        return this;
    }

    @Min(value=1L)
    public int getMaxGlobalSplitIteratorThreads() {
        return this.maxGlobalSplitIteratorThreads;
    }

    @Config(value="hive.max-global-split-iterator-threads")
    public HiveClientConfig setMaxGlobalSplitIteratorThreads(int maxGlobalSplitIteratorThreads) {
        this.maxGlobalSplitIteratorThreads = maxGlobalSplitIteratorThreads;
        return this;
    }

    @NotNull
    public Duration getMetastoreCacheTtl() {
        return this.metastoreCacheTtl;
    }

    @Config(value="hive.metastore-cache-ttl")
    public HiveClientConfig setMetastoreCacheTtl(Duration metastoreCacheTtl) {
        this.metastoreCacheTtl = metastoreCacheTtl;
        return this;
    }

    @NotNull
    public Duration getMetastoreRefreshInterval() {
        return this.metastoreRefreshInterval;
    }

    @Config(value="hive.metastore-refresh-interval")
    public HiveClientConfig setMetastoreRefreshInterval(Duration metastoreRefreshInterval) {
        this.metastoreRefreshInterval = metastoreRefreshInterval;
        return this;
    }

    @Min(value=1L)
    public int getMaxMetastoreRefreshThreads() {
        return this.maxMetastoreRefreshThreads;
    }

    @Config(value="hive.metastore-refresh-max-threads")
    public HiveClientConfig setMaxMetastoreRefreshThreads(int maxMetastoreRefreshThreads) {
        this.maxMetastoreRefreshThreads = maxMetastoreRefreshThreads;
        return this;
    }

    public HostAndPort getMetastoreSocksProxy() {
        return this.metastoreSocksProxy;
    }

    @Config(value="hive.metastore.thrift.client.socks-proxy")
    public HiveClientConfig setMetastoreSocksProxy(HostAndPort metastoreSocksProxy) {
        this.metastoreSocksProxy = metastoreSocksProxy;
        return this;
    }

    @NotNull
    public Duration getMetastoreTimeout() {
        return this.metastoreTimeout;
    }

    @Config(value="hive.metastore-timeout")
    public HiveClientConfig setMetastoreTimeout(Duration metastoreTimeout) {
        this.metastoreTimeout = metastoreTimeout;
        return this;
    }

    @Min(value=1L)
    public int getMinPartitionBatchSize() {
        return this.minPartitionBatchSize;
    }

    @Config(value="hive.metastore.partition-batch-size.min")
    public HiveClientConfig setMinPartitionBatchSize(int minPartitionBatchSize) {
        this.minPartitionBatchSize = minPartitionBatchSize;
        return this;
    }

    @Min(value=1L)
    public int getMaxPartitionBatchSize() {
        return this.maxPartitionBatchSize;
    }

    @Config(value="hive.metastore.partition-batch-size.max")
    public HiveClientConfig setMaxPartitionBatchSize(int maxPartitionBatchSize) {
        this.maxPartitionBatchSize = maxPartitionBatchSize;
        return this;
    }

    public List<String> getResourceConfigFiles() {
        return this.resourceConfigFiles;
    }

    @Config(value="hive.config.resources")
    public HiveClientConfig setResourceConfigFiles(String files) {
        this.resourceConfigFiles = files == null ? null : SPLITTER.splitToList((CharSequence)files);
        return this;
    }

    public HiveClientConfig setResourceConfigFiles(List<String> files) {
        this.resourceConfigFiles = files == null ? null : ImmutableList.copyOf(files);
        return this;
    }

    @NotNull
    public Duration getFileSystemCacheTtl() {
        return this.fileSystemCacheTtl;
    }

    @Config(value="hive.file-system-cache-ttl")
    public HiveClientConfig setFileSystemCacheTtl(Duration fileSystemCacheTtl) {
        this.fileSystemCacheTtl = fileSystemCacheTtl;
        return this;
    }

    @NotNull
    @MinDuration(value="1ms")
    public Duration getDfsTimeout() {
        return this.dfsTimeout;
    }

    @Config(value="hive.dfs-timeout")
    public HiveClientConfig setDfsTimeout(Duration dfsTimeout) {
        this.dfsTimeout = dfsTimeout;
        return this;
    }

    @MinDuration(value="1ms")
    @NotNull
    public Duration getDfsConnectTimeout() {
        return this.dfsConnectTimeout;
    }

    @Config(value="hive.dfs.connect.timeout")
    public HiveClientConfig setDfsConnectTimeout(Duration dfsConnectTimeout) {
        this.dfsConnectTimeout = dfsConnectTimeout;
        return this;
    }

    @Min(value=0L)
    public int getDfsConnectMaxRetries() {
        return this.dfsConnectMaxRetries;
    }

    @Config(value="hive.dfs.connect.max-retries")
    public HiveClientConfig setDfsConnectMaxRetries(int dfsConnectMaxRetries) {
        this.dfsConnectMaxRetries = dfsConnectMaxRetries;
        return this;
    }

    public String getDomainSocketPath() {
        return this.domainSocketPath;
    }

    @Config(value="dfs.domain-socket-path")
    public HiveClientConfig setDomainSocketPath(String domainSocketPath) {
        this.domainSocketPath = domainSocketPath;
        return this;
    }

    public String getS3AwsAccessKey() {
        return this.s3AwsAccessKey;
    }

    @Config(value="hive.s3.aws-access-key")
    public HiveClientConfig setS3AwsAccessKey(String s3AwsAccessKey) {
        this.s3AwsAccessKey = s3AwsAccessKey;
        return this;
    }

    public String getS3AwsSecretKey() {
        return this.s3AwsSecretKey;
    }

    @Config(value="hive.s3.aws-secret-key")
    public HiveClientConfig setS3AwsSecretKey(String s3AwsSecretKey) {
        this.s3AwsSecretKey = s3AwsSecretKey;
        return this;
    }

    public boolean isS3SslEnabled() {
        return this.s3SslEnabled;
    }

    @Config(value="hive.s3.ssl.enabled")
    public HiveClientConfig setS3SslEnabled(boolean s3SslEnabled) {
        this.s3SslEnabled = s3SslEnabled;
        return this;
    }

    @Min(value=0L)
    public int getS3MaxClientRetries() {
        return this.s3MaxClientRetries;
    }

    @Config(value="hive.s3.max-client-retries")
    public HiveClientConfig setS3MaxClientRetries(int s3MaxClientRetries) {
        this.s3MaxClientRetries = s3MaxClientRetries;
        return this;
    }

    @Min(value=0L)
    public int getS3MaxErrorRetries() {
        return this.s3MaxErrorRetries;
    }

    @Config(value="hive.s3.max-error-retries")
    public HiveClientConfig setS3MaxErrorRetries(int s3MaxErrorRetries) {
        this.s3MaxErrorRetries = s3MaxErrorRetries;
        return this;
    }

    @MinDuration(value="1ms")
    @NotNull
    public Duration getS3ConnectTimeout() {
        return this.s3ConnectTimeout;
    }

    @Config(value="hive.s3.connect-timeout")
    public HiveClientConfig setS3ConnectTimeout(Duration s3ConnectTimeout) {
        this.s3ConnectTimeout = s3ConnectTimeout;
        return this;
    }

    @NotNull
    public File getS3StagingDirectory() {
        return this.s3StagingDirectory;
    }

    @Config(value="hive.s3.staging-directory")
    @ConfigDescription(value="Temporary directory for staging files before uploading to S3")
    public HiveClientConfig setS3StagingDirectory(File s3StagingDirectory) {
        this.s3StagingDirectory = s3StagingDirectory;
        return this;
    }
}

