/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hive.HiveType;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ColumnType;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;

public class HiveColumnHandle
implements ColumnHandle {
    public static final String SAMPLE_WEIGHT_COLUMN_NAME = "__presto__sample_weight__";
    private final String clientId;
    private final String name;
    private final int ordinalPosition;
    private final HiveType hiveType;
    private final int hiveColumnIndex;
    private final boolean partitionKey;

    @JsonCreator
    public HiveColumnHandle(@JsonProperty(value="clientId") String clientId, @JsonProperty(value="name") String name, @JsonProperty(value="ordinalPosition") int ordinalPosition, @JsonProperty(value="hiveType") HiveType hiveType, @JsonProperty(value="hiveColumnIndex") int hiveColumnIndex, @JsonProperty(value="partitionKey") boolean partitionKey) {
        this.clientId = (String)Preconditions.checkNotNull((Object)clientId, (Object)"clientId is null");
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name is null");
        Preconditions.checkArgument((ordinalPosition >= 0 ? 1 : 0) != 0, (Object)"ordinalPosition is negative");
        this.ordinalPosition = ordinalPosition;
        Preconditions.checkArgument((hiveColumnIndex >= 0 || partitionKey ? 1 : 0) != 0, (Object)"hiveColumnIndex is negative");
        this.hiveColumnIndex = hiveColumnIndex;
        this.hiveType = (HiveType)((Object)Preconditions.checkNotNull((Object)((Object)hiveType), (Object)"hiveType is null"));
        this.partitionKey = partitionKey;
    }

    @JsonProperty
    public String getClientId() {
        return this.clientId;
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty
    public int getOrdinalPosition() {
        return this.ordinalPosition;
    }

    @JsonProperty
    public HiveType getHiveType() {
        return this.hiveType;
    }

    @JsonProperty
    public int getHiveColumnIndex() {
        return this.hiveColumnIndex;
    }

    @JsonProperty
    public boolean isPartitionKey() {
        return this.partitionKey;
    }

    public ColumnMetadata getColumnMetadata() {
        return new ColumnMetadata(this.name, this.hiveType.getNativeType(), this.ordinalPosition, this.partitionKey);
    }

    public ColumnType getType() {
        return this.hiveType.getNativeType();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.clientId, this.name, this.hiveColumnIndex, this.hiveType, this.partitionKey});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        HiveColumnHandle other = (HiveColumnHandle)obj;
        return Objects.equal((Object)this.clientId, (Object)other.clientId) && Objects.equal((Object)this.name, (Object)other.name) && Objects.equal((Object)this.hiveColumnIndex, (Object)other.hiveColumnIndex) && Objects.equal((Object)((Object)this.hiveType), (Object)((Object)other.hiveType)) && Objects.equal((Object)this.partitionKey, (Object)other.partitionKey);
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("clientId", (Object)this.clientId).add("name", (Object)this.name).add("ordinalPosition", this.ordinalPosition).add("hiveType", (Object)this.hiveType).add("hiveColumnIndex", this.hiveColumnIndex).add("partitionKey", this.partitionKey).toString();
    }

    public static Function<ColumnHandle, HiveColumnHandle> hiveColumnHandle() {
        return new Function<ColumnHandle, HiveColumnHandle>(){

            public HiveColumnHandle apply(ColumnHandle columnHandle) {
                Preconditions.checkNotNull((Object)columnHandle, (Object)"columnHandle is null");
                Preconditions.checkArgument((boolean)(columnHandle instanceof HiveColumnHandle), (Object)"columnHandle is not an instance of HiveColumnHandle");
                return (HiveColumnHandle)columnHandle;
            }
        };
    }

    public static Function<HiveColumnHandle, Integer> hiveColumnIndexGetter() {
        return new Function<HiveColumnHandle, Integer>(){

            public Integer apply(HiveColumnHandle input) {
                return input.getHiveColumnIndex();
            }
        };
    }

    public static Function<HiveColumnHandle, ColumnMetadata> columnMetadataGetter() {
        return new Function<HiveColumnHandle, ColumnMetadata>(){

            public ColumnMetadata apply(HiveColumnHandle input) {
                return input.getColumnMetadata();
            }
        };
    }

    public static Function<HiveColumnHandle, ColumnType> nativeTypeGetter() {
        return new Function<HiveColumnHandle, ColumnType>(){

            public ColumnType apply(HiveColumnHandle input) {
                return input.getType();
            }
        };
    }

    public static Predicate<HiveColumnHandle> isPartitionKeyPredicate() {
        return new Predicate<HiveColumnHandle>(){

            public boolean apply(HiveColumnHandle input) {
                return input.isPartitionKey();
            }
        };
    }
}

