/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hadoop.HadoopFileSystemCache;
import com.facebook.presto.hadoop.HadoopNative;
import com.facebook.presto.hive.HdfsEnvironment;
import com.facebook.presto.hive.HiveColumnHandle;
import com.facebook.presto.hive.HiveRecordCursorProvider;
import com.facebook.presto.hive.HiveSplit;
import com.facebook.presto.hive.HiveType;
import com.facebook.presto.hive.HiveUtil;
import com.facebook.presto.hive.RetryDriver;
import com.facebook.presto.spi.ColumnType;
import com.facebook.presto.spi.RecordCursor;
import com.facebook.presto.spi.RecordSet;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.Callable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.serde2.ColumnProjectionUtils;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;

public class HiveRecordSet
implements RecordSet {
    private final HiveSplit split;
    private final List<HiveColumnHandle> columns;
    private final List<ColumnType> columnTypes;
    private final List<Integer> readHiveColumnIndexes;
    private final Configuration configuration;
    private final Path wrappedPath;
    private final List<HiveRecordCursorProvider> cursorProviders;

    public HiveRecordSet(HdfsEnvironment hdfsEnvironment, HiveSplit split, List<HiveColumnHandle> columns, List<HiveRecordCursorProvider> cursorProviders) {
        this.split = (HiveSplit)Preconditions.checkNotNull((Object)split, (Object)"split is null");
        this.columns = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(columns, (Object)"columns is null")));
        this.columnTypes = ImmutableList.copyOf((Iterable)Iterables.transform(columns, HiveColumnHandle.nativeTypeGetter()));
        this.cursorProviders = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(cursorProviders, (Object)"cursor providers is null")));
        ImmutableList readColumns = ImmutableList.copyOf((Iterable)Iterables.filter(columns, (Predicate)Predicates.not(HiveColumnHandle.isPartitionKeyPredicate())));
        if (readColumns.isEmpty()) {
            HiveColumnHandle primitiveColumn = HiveRecordSet.getFirstPrimitiveColumn(split.getClientId(), split.getSchema());
            readColumns = ImmutableList.of((Object)primitiveColumn);
        }
        this.readHiveColumnIndexes = new ArrayList<Integer>(Lists.transform((List)readColumns, HiveColumnHandle.hiveColumnIndexGetter()));
        Path path = new Path(split.getPath());
        this.configuration = hdfsEnvironment.getConfiguration(path);
        this.wrappedPath = hdfsEnvironment.wrapInputPath(path);
        String nullSequence = split.getSchema().getProperty("serialization.null.format");
        Preconditions.checkState((nullSequence == null || nullSequence.equals("\\N") ? 1 : 0) != 0, (String)"Only '\\N' supported as null specifier, was '%s'", (Object[])new Object[]{nullSequence});
    }

    public List<ColumnType> getColumnTypes() {
        return this.columnTypes;
    }

    public RecordCursor cursor() {
        ColumnProjectionUtils.setReadColumnIDs((Configuration)this.configuration, this.readHiveColumnIndexes);
        RecordReader<?, ?> recordReader = HiveRecordSet.createRecordReader(this.split, this.configuration, this.wrappedPath);
        for (HiveRecordCursorProvider provider : this.cursorProviders) {
            Optional<RecordCursor> cursor = provider.createHiveRecordCursor(this.split, recordReader, this.columns);
            if (!cursor.isPresent()) continue;
            return (RecordCursor)cursor.get();
        }
        throw new RuntimeException("Configured cursor providers did not provide a cursor");
    }

    private static HiveColumnHandle getFirstPrimitiveColumn(String clientId, Properties schema) {
        try {
            int index = 0;
            for (StructField field : HiveUtil.getTableObjectInspector(schema).getAllStructFieldRefs()) {
                if (field.getFieldObjectInspector().getCategory() == ObjectInspector.Category.PRIMITIVE) {
                    PrimitiveObjectInspector inspector = (PrimitiveObjectInspector)field.getFieldObjectInspector();
                    HiveType hiveType = HiveType.getSupportedHiveType(inspector.getPrimitiveCategory());
                    return new HiveColumnHandle(clientId, field.getFieldName(), index, hiveType, index, false);
                }
                ++index;
            }
        }
        catch (RuntimeException | MetaException | SerDeException e) {
            throw Throwables.propagate((Throwable)e);
        }
        throw new IllegalStateException("Table doesn't have any PRIMITIVE columns");
    }

    private static RecordReader<?, ?> createRecordReader(HiveSplit split, Configuration configuration, Path wrappedPath) {
        final InputFormat<?, ?> inputFormat = HiveUtil.getInputFormat(configuration, split.getSchema(), true);
        final JobConf jobConf = new JobConf(configuration);
        final FileSplit fileSplit = HiveRecordSet.createFileSplit(wrappedPath, split.getStart(), split.getLength());
        for (String name : split.getSchema().stringPropertyNames()) {
            if (!name.startsWith("serialization.")) continue;
            jobConf.set(name, split.getSchema().getProperty(name));
        }
        try {
            return (RecordReader)RetryDriver.retry().stopOnIllegalExceptions().run("createRecordReader", new Callable<RecordReader<?, ?>>(){

                @Override
                public RecordReader<?, ?> call() throws IOException {
                    return inputFormat.getRecordReader((InputSplit)fileSplit, jobConf, Reporter.NULL);
                }
            });
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Error opening Hive split %s (offset=%s, length=%s) using %s: %s", split.getPath(), split.getStart(), split.getLength(), HiveUtil.getInputFormatName(split.getSchema()), e.getMessage()), e);
        }
    }

    private static FileSplit createFileSplit(final Path path, long start, long length) {
        return new FileSplit(path, start, length, null){

            public Path getPath() {
                return path;
            }
        };
    }

    static {
        HadoopNative.requireHadoopNative();
        HadoopFileSystemCache.initialize();
    }
}

