/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hive.HivePartitionKey;
import com.facebook.presto.spi.HostAddress;
import com.facebook.presto.spi.Split;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Properties;

public class HiveSplit
implements Split {
    private final String clientId;
    private final String path;
    private final long start;
    private final long length;
    private final Properties schema;
    private final List<HivePartitionKey> partitionKeys;
    private final List<HostAddress> addresses;
    private final String database;
    private final String table;
    private final String partitionName;

    @JsonCreator
    public HiveSplit(@JsonProperty(value="clientId") String clientId, @JsonProperty(value="database") String database, @JsonProperty(value="table") String table, @JsonProperty(value="partitionName") String partitionName, @JsonProperty(value="path") String path, @JsonProperty(value="start") long start, @JsonProperty(value="length") long length, @JsonProperty(value="schema") Properties schema, @JsonProperty(value="partitionKeys") List<HivePartitionKey> partitionKeys, @JsonProperty(value="addresses") List<HostAddress> addresses) {
        Preconditions.checkNotNull((Object)clientId, (Object)"clientId is null");
        Preconditions.checkArgument((start >= 0L ? 1 : 0) != 0, (Object)"start must be positive");
        Preconditions.checkArgument((length >= 0L ? 1 : 0) != 0, (Object)"length must be positive");
        Preconditions.checkNotNull((Object)database, (Object)"database is null");
        Preconditions.checkNotNull((Object)table, (Object)"table is null");
        Preconditions.checkNotNull((Object)partitionName, (Object)"partitionName is null");
        Preconditions.checkNotNull((Object)path, (Object)"path is null");
        Preconditions.checkNotNull((Object)schema, (Object)"schema is null");
        Preconditions.checkNotNull(partitionKeys, (Object)"partitionKeys is null");
        Preconditions.checkNotNull(addresses, (Object)"addresses is null");
        this.clientId = clientId;
        this.database = database;
        this.table = table;
        this.partitionName = partitionName;
        this.path = path;
        this.start = start;
        this.length = length;
        this.schema = schema;
        this.partitionKeys = ImmutableList.copyOf(partitionKeys);
        this.addresses = ImmutableList.copyOf(addresses);
    }

    @JsonProperty
    public String getClientId() {
        return this.clientId;
    }

    @JsonProperty
    public String getDatabase() {
        return this.database;
    }

    @JsonProperty
    public String getTable() {
        return this.table;
    }

    @JsonProperty
    public String getPartitionName() {
        return this.partitionName;
    }

    @JsonProperty
    public String getPath() {
        return this.path;
    }

    @JsonProperty
    public long getStart() {
        return this.start;
    }

    @JsonProperty
    public long getLength() {
        return this.length;
    }

    @JsonProperty
    public Properties getSchema() {
        return this.schema;
    }

    @JsonProperty
    public List<HivePartitionKey> getPartitionKeys() {
        return this.partitionKeys;
    }

    @JsonProperty
    public List<HostAddress> getAddresses() {
        return this.addresses;
    }

    public boolean isRemotelyAccessible() {
        return true;
    }

    public Object getInfo() {
        return ImmutableMap.builder().put((Object)"path", (Object)this.path).put((Object)"start", (Object)this.start).put((Object)"length", (Object)this.length).put((Object)"hosts", this.addresses).put((Object)"database", (Object)this.database).put((Object)"table", (Object)this.table).put((Object)"partitionName", (Object)this.partitionName).build();
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).addValue((Object)this.path).addValue(this.start).addValue(this.length).toString();
    }
}

