/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core.querybuilder;

import com.datastax.driver.core.querybuilder.Utils;
import java.nio.ByteBuffer;
import java.util.List;

public abstract class Assignment
extends Utils.Appendeable {
    final String name;

    private Assignment(String name) {
        this.name = name;
    }

    static class MapPutAssignment
    extends Assignment {
        private final Object key;
        private final Object value;

        MapPutAssignment(String name, Object key, Object value) {
            super(name);
            this.key = key;
            this.value = value;
        }

        @Override
        void appendTo(StringBuilder sb, List<ByteBuffer> variables) {
            Utils.appendName(this.name, sb).append("[");
            Utils.appendValue(this.key, sb, variables);
            sb.append("]=");
            Utils.appendValue(this.value, sb, variables);
        }

        @Override
        boolean containsBindMarker() {
            return Utils.containsBindMarker(this.key) || Utils.containsBindMarker(this.value);
        }
    }

    static class CollectionAssignment
    extends Assignment {
        private final Object collection;
        private final boolean isAdd;

        CollectionAssignment(String name, Object collection, boolean isAdd) {
            super(name);
            this.collection = collection;
            this.isAdd = isAdd;
        }

        @Override
        void appendTo(StringBuilder sb, List<ByteBuffer> variables) {
            Utils.appendName(this.name, sb).append("=");
            Utils.appendName(this.name, sb).append(this.isAdd ? "+" : "-");
            Utils.appendValue(this.collection, sb, variables);
        }

        @Override
        boolean containsBindMarker() {
            return Utils.containsBindMarker(this.collection);
        }
    }

    static class ListSetIdxAssignment
    extends Assignment {
        private final int idx;
        private final Object value;

        ListSetIdxAssignment(String name, int idx, Object value) {
            super(name);
            this.idx = idx;
            this.value = value;
        }

        @Override
        void appendTo(StringBuilder sb, List<ByteBuffer> variables) {
            Utils.appendName(this.name, sb).append("[").append(this.idx).append("]=");
            Utils.appendValue(this.value, sb, variables);
        }

        @Override
        boolean containsBindMarker() {
            return Utils.containsBindMarker(this.value);
        }
    }

    static class ListPrependAssignment
    extends Assignment {
        private final Object value;

        ListPrependAssignment(String name, Object value) {
            super(name);
            this.value = value;
        }

        @Override
        void appendTo(StringBuilder sb, List<ByteBuffer> variables) {
            Utils.appendName(this.name, sb).append("=");
            Utils.appendValue(this.value, sb, variables);
            sb.append("+");
            Utils.appendName(this.name, sb);
        }

        @Override
        boolean containsBindMarker() {
            return Utils.containsBindMarker(this.value);
        }
    }

    static class CounterAssignment
    extends Assignment {
        private final Object value;
        private final boolean isIncr;

        CounterAssignment(String name, Object value, boolean isIncr) {
            super(name);
            if (!isIncr && value instanceof Long && (Long)value < 0L) {
                this.value = -((Long)value).longValue();
                this.isIncr = true;
            } else {
                this.value = value;
                this.isIncr = isIncr;
            }
        }

        @Override
        void appendTo(StringBuilder sb, List<ByteBuffer> variables) {
            Utils.appendName(this.name, sb).append("=");
            Utils.appendName(this.name, sb).append(this.isIncr ? "+" : "-");
            Utils.appendValue(this.value, sb, variables);
        }

        @Override
        boolean containsBindMarker() {
            return Utils.containsBindMarker(this.value);
        }
    }

    static class SetAssignment
    extends Assignment {
        private final Object value;

        SetAssignment(String name, Object value) {
            super(name);
            this.value = value;
        }

        @Override
        void appendTo(StringBuilder sb, List<ByteBuffer> variables) {
            Utils.appendName(this.name, sb);
            sb.append("=");
            Utils.appendValue(this.value, sb, variables);
        }

        @Override
        boolean containsBindMarker() {
            return Utils.containsBindMarker(this.value);
        }
    }
}

