/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core.querybuilder;

import com.datastax.driver.core.querybuilder.BindMarker;
import com.datastax.driver.core.querybuilder.Utils;
import java.nio.ByteBuffer;
import java.util.List;

public abstract class Clause
extends Utils.Appendeable {
    final String name;

    private Clause(String name) {
        this.name = name;
    }

    String name() {
        return this.name;
    }

    abstract Object firstValue();

    static class InClause
    extends Clause {
        private final List<Object> values;

        InClause(String name, List<Object> values) {
            super(name);
            this.values = values;
            if (values == null) {
                throw new IllegalArgumentException("Missing values for IN clause");
            }
        }

        @Override
        void appendTo(StringBuilder sb, List<ByteBuffer> variables) {
            if (this.values.size() == 1 && this.values.get(0) instanceof BindMarker) {
                Utils.appendName(this.name, sb).append(" IN ").append(this.values.get(0));
                return;
            }
            Utils.appendName(this.name, sb).append(" IN (");
            Utils.joinAndAppendValues(sb, ",", this.values, variables).append(")");
        }

        @Override
        Object firstValue() {
            return this.values.isEmpty() ? null : this.values.get(0);
        }

        @Override
        boolean containsBindMarker() {
            for (Object value : this.values) {
                if (!Utils.containsBindMarker(value)) continue;
                return true;
            }
            return false;
        }
    }

    static class SimpleClause
    extends Clause {
        private final String op;
        private final Object value;

        SimpleClause(String name, String op, Object value) {
            super(name);
            this.op = op;
            this.value = value;
        }

        @Override
        void appendTo(StringBuilder sb, List<ByteBuffer> variables) {
            Utils.appendName(this.name, sb).append(this.op);
            Utils.appendValue(this.value, sb, variables);
        }

        @Override
        Object firstValue() {
            return this.value;
        }

        @Override
        boolean containsBindMarker() {
            return Utils.containsBindMarker(this.value);
        }
    }
}

