/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import com.facebook.presto.hadoop.shaded.org.apache.commons.collections.map.CaseInsensitiveMap;
import com.facebook.presto.hadoop.shaded.org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import com.facebook.presto.hadoop.shaded.org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import com.facebook.presto.hadoop.shaded.org.apache.commons.io.FileUtils;
import com.facebook.presto.hadoop.shaded.org.apache.commons.logging.Log;
import com.facebook.presto.hadoop.shaded.org.apache.commons.logging.LogFactory;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.nativeio.NativeIO;
import org.apache.hadoop.util.Shell;
import org.apache.hadoop.util.StringUtils;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class FileUtil {
    private static final Log LOG = LogFactory.getLog(FileUtil.class);
    public static final int SYMLINK_NO_PRIVILEGE = 2;

    public static Path[] stat2Paths(FileStatus[] stats) {
        if (stats == null) {
            return null;
        }
        Path[] ret = new Path[stats.length];
        for (int i = 0; i < stats.length; ++i) {
            ret[i] = stats[i].getPath();
        }
        return ret;
    }

    public static Path[] stat2Paths(FileStatus[] stats, Path path) {
        if (stats == null) {
            return new Path[]{path};
        }
        return FileUtil.stat2Paths(stats);
    }

    public static boolean fullyDelete(File dir) {
        return FileUtil.fullyDelete(dir, false);
    }

    public static boolean fullyDelete(File dir, boolean tryGrantPermissions) {
        if (tryGrantPermissions) {
            File parent = dir.getParentFile();
            FileUtil.grantPermissions(parent);
        }
        if (FileUtil.deleteImpl(dir, false)) {
            return true;
        }
        if (!FileUtil.fullyDeleteContents(dir, tryGrantPermissions)) {
            return false;
        }
        return FileUtil.deleteImpl(dir, true);
    }

    public static String readLink(File f) {
        try {
            return Shell.execCommand(Shell.getReadlinkCommand(f.toString())).trim();
        }
        catch (IOException x) {
            return "";
        }
    }

    private static void grantPermissions(File f) {
        FileUtil.setExecutable(f, true);
        FileUtil.setReadable(f, true);
        FileUtil.setWritable(f, true);
    }

    private static boolean deleteImpl(File f, boolean doLog) {
        if (f == null) {
            LOG.warn("null file argument.");
            return false;
        }
        boolean wasDeleted = f.delete();
        if (wasDeleted) {
            return true;
        }
        boolean ex = f.exists();
        if (doLog && ex) {
            LOG.warn("Failed to delete file or dir [" + f.getAbsolutePath() + "]: it still exists.");
        }
        return !ex;
    }

    public static boolean fullyDeleteContents(File dir) {
        return FileUtil.fullyDeleteContents(dir, false);
    }

    public static boolean fullyDeleteContents(File dir, boolean tryGrantPermissions) {
        if (tryGrantPermissions) {
            FileUtil.grantPermissions(dir);
        }
        boolean deletionSucceeded = true;
        File[] contents = dir.listFiles();
        if (contents != null) {
            for (int i = 0; i < contents.length; ++i) {
                if (contents[i].isFile()) {
                    if (FileUtil.deleteImpl(contents[i], true)) continue;
                    deletionSucceeded = false;
                    continue;
                }
                boolean b = false;
                b = FileUtil.deleteImpl(contents[i], false);
                if (b || FileUtil.fullyDelete(contents[i], tryGrantPermissions)) continue;
                deletionSucceeded = false;
            }
        }
        return deletionSucceeded;
    }

    @Deprecated
    public static void fullyDelete(FileSystem fs, Path dir) throws IOException {
        fs.delete(dir, true);
    }

    private static void checkDependencies(FileSystem srcFS, Path src, FileSystem dstFS, Path dst) throws IOException {
        if (srcFS == dstFS) {
            String srcq = src.makeQualified(srcFS).toString() + "/";
            String dstq = dst.makeQualified(dstFS).toString() + "/";
            if (dstq.startsWith(srcq)) {
                if (srcq.length() == dstq.length()) {
                    throw new IOException("Cannot copy " + src + " to itself.");
                }
                throw new IOException("Cannot copy " + src + " to its subdirectory " + dst);
            }
        }
    }

    public static boolean copy(FileSystem srcFS, Path src, FileSystem dstFS, Path dst, boolean deleteSource, Configuration conf) throws IOException {
        return FileUtil.copy(srcFS, src, dstFS, dst, deleteSource, true, conf);
    }

    public static boolean copy(FileSystem srcFS, Path[] srcs, FileSystem dstFS, Path dst, boolean deleteSource, boolean overwrite, Configuration conf) throws IOException {
        boolean gotException = false;
        boolean returnVal = true;
        StringBuilder exceptions = new StringBuilder();
        if (srcs.length == 1) {
            return FileUtil.copy(srcFS, srcs[0], dstFS, dst, deleteSource, overwrite, conf);
        }
        if (!dstFS.exists(dst)) {
            throw new IOException("`" + dst + "': specified destination directory " + "does not exist");
        }
        FileStatus sdst = dstFS.getFileStatus(dst);
        if (!sdst.isDirectory()) {
            throw new IOException("copying multiple files, but last argument `" + dst + "' is not a directory");
        }
        for (Path src : srcs) {
            try {
                if (FileUtil.copy(srcFS, src, dstFS, dst, deleteSource, overwrite, conf)) continue;
                returnVal = false;
            }
            catch (IOException e) {
                gotException = true;
                exceptions.append(e.getMessage());
                exceptions.append("\n");
            }
        }
        if (gotException) {
            throw new IOException(exceptions.toString());
        }
        return returnVal;
    }

    public static boolean copy(FileSystem srcFS, Path src, FileSystem dstFS, Path dst, boolean deleteSource, boolean overwrite, Configuration conf) throws IOException {
        FileStatus fileStatus = srcFS.getFileStatus(src);
        return FileUtil.copy(srcFS, fileStatus, dstFS, dst, deleteSource, overwrite, conf);
    }

    private static boolean copy(FileSystem srcFS, FileStatus srcStatus, FileSystem dstFS, Path dst, boolean deleteSource, boolean overwrite, Configuration conf) throws IOException {
        Path src = srcStatus.getPath();
        dst = FileUtil.checkDest(src.getName(), dstFS, dst, overwrite);
        if (srcStatus.isDirectory()) {
            FileUtil.checkDependencies(srcFS, src, dstFS, dst);
            if (!dstFS.mkdirs(dst)) {
                return false;
            }
            FileStatus[] contents = srcFS.listStatus(src);
            for (int i = 0; i < contents.length; ++i) {
                FileUtil.copy(srcFS, contents[i], dstFS, new Path(dst, contents[i].getPath().getName()), deleteSource, overwrite, conf);
            }
        } else {
            FSDataInputStream in = null;
            FSDataOutputStream out = null;
            try {
                in = srcFS.open(src);
                out = dstFS.create(dst, overwrite);
                IOUtils.copyBytes((InputStream)in, (OutputStream)out, conf, true);
            }
            catch (IOException e) {
                IOUtils.closeStream(out);
                IOUtils.closeStream(in);
                throw e;
            }
        }
        if (deleteSource) {
            return srcFS.delete(src, true);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copyMerge(FileSystem srcFS, Path srcDir, FileSystem dstFS, Path dstFile, boolean deleteSource, Configuration conf, String addString) throws IOException {
        dstFile = FileUtil.checkDest(srcDir.getName(), dstFS, dstFile, false);
        if (!srcFS.getFileStatus(srcDir).isDirectory()) {
            return false;
        }
        FSDataOutputStream out = dstFS.create(dstFile);
        try {
            Object[] contents = srcFS.listStatus(srcDir);
            Arrays.sort(contents);
            for (int i = 0; i < contents.length; ++i) {
                if (!((FileStatus)contents[i]).isFile()) continue;
                FSDataInputStream in = srcFS.open(((FileStatus)contents[i]).getPath());
                try {
                    IOUtils.copyBytes((InputStream)in, (OutputStream)out, conf, false);
                    if (addString == null) continue;
                    ((OutputStream)out).write(addString.getBytes("UTF-8"));
                    continue;
                }
                finally {
                    ((InputStream)in).close();
                }
            }
        }
        finally {
            ((OutputStream)out).close();
        }
        if (deleteSource) {
            return srcFS.delete(srcDir, true);
        }
        return true;
    }

    public static boolean copy(File src, FileSystem dstFS, Path dst, boolean deleteSource, Configuration conf) throws IOException {
        dst = FileUtil.checkDest(src.getName(), dstFS, dst, false);
        if (src.isDirectory()) {
            if (!dstFS.mkdirs(dst)) {
                return false;
            }
            File[] contents = FileUtil.listFiles(src);
            for (int i = 0; i < contents.length; ++i) {
                FileUtil.copy(contents[i], dstFS, new Path(dst, contents[i].getName()), deleteSource, conf);
            }
        } else if (src.isFile()) {
            FileInputStream in = null;
            FSDataOutputStream out = null;
            try {
                in = new FileInputStream(src);
                out = dstFS.create(dst);
                IOUtils.copyBytes((InputStream)in, (OutputStream)out, conf);
            }
            catch (IOException e) {
                IOUtils.closeStream(out);
                IOUtils.closeStream(in);
                throw e;
            }
        } else {
            throw new IOException(src.toString() + ": No such file or directory");
        }
        if (deleteSource) {
            return FileUtil.fullyDelete(src);
        }
        return true;
    }

    public static boolean copy(FileSystem srcFS, Path src, File dst, boolean deleteSource, Configuration conf) throws IOException {
        FileStatus filestatus = srcFS.getFileStatus(src);
        return FileUtil.copy(srcFS, filestatus, dst, deleteSource, conf);
    }

    private static boolean copy(FileSystem srcFS, FileStatus srcStatus, File dst, boolean deleteSource, Configuration conf) throws IOException {
        Path src = srcStatus.getPath();
        if (srcStatus.isDirectory()) {
            if (!dst.mkdirs()) {
                return false;
            }
            FileStatus[] contents = srcFS.listStatus(src);
            for (int i = 0; i < contents.length; ++i) {
                FileUtil.copy(srcFS, contents[i], new File(dst, contents[i].getPath().getName()), deleteSource, conf);
            }
        } else {
            FSDataInputStream in = srcFS.open(src);
            IOUtils.copyBytes((InputStream)in, (OutputStream)new FileOutputStream(dst), conf);
        }
        if (deleteSource) {
            return srcFS.delete(src, true);
        }
        return true;
    }

    private static Path checkDest(String srcName, FileSystem dstFS, Path dst, boolean overwrite) throws IOException {
        if (dstFS.exists(dst)) {
            FileStatus sdst = dstFS.getFileStatus(dst);
            if (sdst.isDirectory()) {
                if (null == srcName) {
                    throw new IOException("Target " + dst + " is a directory");
                }
                return FileUtil.checkDest(null, dstFS, new Path(dst, srcName), overwrite);
            }
            if (!overwrite) {
                throw new IOException("Target " + dst + " already exists");
            }
        }
        return dst;
    }

    public static String makeShellPath(String filename) throws IOException {
        return filename;
    }

    public static String makeShellPath(File file) throws IOException {
        return FileUtil.makeShellPath(file, false);
    }

    public static String makeShellPath(File file, boolean makeCanonicalPath) throws IOException {
        if (makeCanonicalPath) {
            return FileUtil.makeShellPath(file.getCanonicalPath());
        }
        return FileUtil.makeShellPath(file.toString());
    }

    public static long getDU(File dir) {
        long size = 0L;
        if (!dir.exists()) {
            return 0L;
        }
        if (!dir.isDirectory()) {
            return dir.length();
        }
        File[] allFiles = dir.listFiles();
        if (allFiles != null) {
            for (int i = 0; i < allFiles.length; ++i) {
                boolean isSymLink;
                try {
                    isSymLink = FileUtils.isSymlink(allFiles[i]);
                }
                catch (IOException ioe) {
                    isSymLink = true;
                }
                if (isSymLink) continue;
                size += FileUtil.getDU(allFiles[i]);
            }
        }
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unZip(File inFile, File unzipDir) throws IOException {
        ZipFile zipFile = new ZipFile(inFile);
        try {
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (entry.isDirectory()) continue;
                InputStream in = zipFile.getInputStream(entry);
                try {
                    File file = new File(unzipDir, entry.getName());
                    if (!file.getParentFile().mkdirs() && !file.getParentFile().isDirectory()) {
                        throw new IOException("Mkdirs failed to create " + file.getParentFile().toString());
                    }
                    FileOutputStream out = new FileOutputStream(file);
                    try {
                        int i;
                        byte[] buffer = new byte[8192];
                        while ((i = in.read(buffer)) != -1) {
                            ((OutputStream)out).write(buffer, 0, i);
                        }
                    }
                    finally {
                        ((OutputStream)out).close();
                    }
                }
                finally {
                    in.close();
                }
            }
        }
        finally {
            zipFile.close();
        }
    }

    public static void unTar(File inFile, File untarDir) throws IOException {
        if (!untarDir.mkdirs() && !untarDir.isDirectory()) {
            throw new IOException("Mkdirs failed to create " + untarDir);
        }
        boolean gzipped = inFile.toString().endsWith("gz");
        if (Shell.WINDOWS) {
            FileUtil.unTarUsingJava(inFile, untarDir, gzipped);
        } else {
            FileUtil.unTarUsingTar(inFile, untarDir, gzipped);
        }
    }

    private static void unTarUsingTar(File inFile, File untarDir, boolean gzipped) throws IOException {
        StringBuffer untarCommand = new StringBuffer();
        if (gzipped) {
            untarCommand.append(" gzip -dc '");
            untarCommand.append(FileUtil.makeShellPath(inFile));
            untarCommand.append("' | (");
        }
        untarCommand.append("cd '");
        untarCommand.append(FileUtil.makeShellPath(untarDir));
        untarCommand.append("' ; ");
        untarCommand.append("tar -xf ");
        if (gzipped) {
            untarCommand.append(" -)");
        } else {
            untarCommand.append(FileUtil.makeShellPath(inFile));
        }
        String[] shellCmd = new String[]{"bash", "-c", untarCommand.toString()};
        Shell.ShellCommandExecutor shexec = new Shell.ShellCommandExecutor(shellCmd);
        shexec.execute();
        int exitcode = shexec.getExitCode();
        if (exitcode != 0) {
            throw new IOException("Error untarring file " + inFile + ". Tar process exited with exit code " + exitcode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void unTarUsingJava(File inFile, File untarDir, boolean gzipped) throws IOException {
        BufferedInputStream inputStream = null;
        TarArchiveInputStream tis = null;
        try {
            inputStream = gzipped ? new BufferedInputStream(new GZIPInputStream(new FileInputStream(inFile))) : new BufferedInputStream(new FileInputStream(inFile));
            tis = new TarArchiveInputStream((InputStream)inputStream);
            TarArchiveEntry entry = tis.getNextTarEntry();
            while (entry != null) {
                FileUtil.unpackEntries(tis, entry, untarDir);
                entry = tis.getNextTarEntry();
            }
        }
        catch (Throwable throwable) {
            IOUtils.cleanup(LOG, new Closeable[]{tis, inputStream});
            throw throwable;
        }
        IOUtils.cleanup(LOG, new Closeable[]{tis, inputStream});
    }

    private static void unpackEntries(TarArchiveInputStream tis, TarArchiveEntry entry, File outputDir) throws IOException {
        int count;
        if (entry.isDirectory()) {
            File subDir = new File(outputDir, entry.getName());
            if (!subDir.mkdir() && !subDir.isDirectory()) {
                throw new IOException("Mkdirs failed to create tar internal dir " + outputDir);
            }
            for (TarArchiveEntry e : entry.getDirectoryEntries()) {
                FileUtil.unpackEntries(tis, e, subDir);
            }
            return;
        }
        File outputFile = new File(outputDir, entry.getName());
        if (!outputDir.exists() && !outputDir.mkdirs()) {
            throw new IOException("Mkdirs failed to create tar internal dir " + outputDir);
        }
        byte[] data = new byte[2048];
        BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(outputFile));
        while ((count = tis.read(data)) != -1) {
            outputStream.write(data, 0, count);
        }
        outputStream.flush();
        outputStream.close();
    }

    public static int symLink(String target, String linkname) throws IOException {
        Shell.ShellCommandExecutor shExec;
        File targetFile = new File(Path.getPathWithoutSchemeAndAuthority(new Path(target)).toString());
        File linkFile = new File(Path.getPathWithoutSchemeAndAuthority(new Path(linkname)).toString());
        if (Shell.WINDOWS && !Shell.isJava7OrAbove() && targetFile.isFile()) {
            try {
                LOG.warn("FileUtil#symlink: On Windows+Java6, copying file instead of creating a symlink. Copying " + target + " -> " + linkname);
                if (!linkFile.getParentFile().exists()) {
                    LOG.warn("Parent directory " + linkFile.getParent() + " does not exist.");
                    return 1;
                }
                FileUtils.copyFile(targetFile, linkFile);
            }
            catch (IOException ex) {
                LOG.warn("FileUtil#symlink failed to copy the file with error: " + ex.getMessage());
                return 1;
            }
            return 0;
        }
        String[] cmd = Shell.getSymlinkCommand(targetFile.toString(), linkFile.toString());
        try {
            shExec = Shell.WINDOWS && linkFile.getParentFile() != null && !new Path(target).isAbsolute() ? new Shell.ShellCommandExecutor(cmd, linkFile.getParentFile()) : new Shell.ShellCommandExecutor(cmd);
            shExec.execute();
        }
        catch (Shell.ExitCodeException ec) {
            int returnVal = ec.getExitCode();
            if (Shell.WINDOWS && returnVal == 2) {
                LOG.warn("Fail to create symbolic links on Windows. The default security settings in Windows disallow non-elevated administrators and all non-administrators from creating symbolic links. This behavior can be changed in the Local Security Policy management console");
            } else if (returnVal != 0) {
                LOG.warn("Command '" + StringUtils.join((CharSequence)" ", cmd) + "' failed " + returnVal + " with: " + ec.getMessage());
            }
            return returnVal;
        }
        catch (IOException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Error while create symlink " + linkname + " to " + target + "." + " Exception: " + StringUtils.stringifyException(e));
            }
            throw e;
        }
        return shExec.getExitCode();
    }

    public static int chmod(String filename, String perm) throws IOException, InterruptedException {
        return FileUtil.chmod(filename, perm, false);
    }

    public static int chmod(String filename, String perm, boolean recursive) throws IOException {
        Shell.ShellCommandExecutor shExec;
        block2: {
            String[] cmd = Shell.getSetPermissionCommand(perm, recursive);
            String[] args = new String[cmd.length + 1];
            System.arraycopy(cmd, 0, args, 0, cmd.length);
            args[cmd.length] = new File(filename).getPath();
            shExec = new Shell.ShellCommandExecutor(args);
            try {
                shExec.execute();
            }
            catch (IOException e) {
                if (!LOG.isDebugEnabled()) break block2;
                LOG.debug("Error while changing permission : " + filename + " Exception: " + StringUtils.stringifyException(e));
            }
        }
        return shExec.getExitCode();
    }

    public static void setOwner(File file, String username, String groupname) throws IOException {
        if (username == null && groupname == null) {
            throw new IOException("username == null && groupname == null");
        }
        String arg = (username == null ? "" : username) + (groupname == null ? "" : ":" + groupname);
        String[] cmd = Shell.getSetOwnerCommand(arg);
        FileUtil.execCommand(file, cmd);
    }

    public static boolean setReadable(File f, boolean readable) {
        if (Shell.WINDOWS) {
            try {
                String permission = readable ? "u+r" : "u-r";
                FileUtil.chmod(f.getCanonicalPath(), permission, false);
                return true;
            }
            catch (IOException ex) {
                return false;
            }
        }
        return f.setReadable(readable);
    }

    public static boolean setWritable(File f, boolean writable) {
        if (Shell.WINDOWS) {
            try {
                String permission = writable ? "u+w" : "u-w";
                FileUtil.chmod(f.getCanonicalPath(), permission, false);
                return true;
            }
            catch (IOException ex) {
                return false;
            }
        }
        return f.setWritable(writable);
    }

    public static boolean setExecutable(File f, boolean executable) {
        if (Shell.WINDOWS) {
            try {
                String permission = executable ? "u+x" : "u-x";
                FileUtil.chmod(f.getCanonicalPath(), permission, false);
                return true;
            }
            catch (IOException ex) {
                return false;
            }
        }
        return f.setExecutable(executable);
    }

    public static boolean canRead(File f) {
        if (Shell.WINDOWS) {
            try {
                return NativeIO.Windows.access(f.getCanonicalPath(), NativeIO.Windows.AccessRight.ACCESS_READ);
            }
            catch (IOException e) {
                return false;
            }
        }
        return f.canRead();
    }

    public static boolean canWrite(File f) {
        if (Shell.WINDOWS) {
            try {
                return NativeIO.Windows.access(f.getCanonicalPath(), NativeIO.Windows.AccessRight.ACCESS_WRITE);
            }
            catch (IOException e) {
                return false;
            }
        }
        return f.canWrite();
    }

    public static boolean canExecute(File f) {
        if (Shell.WINDOWS) {
            try {
                return NativeIO.Windows.access(f.getCanonicalPath(), NativeIO.Windows.AccessRight.ACCESS_EXECUTE);
            }
            catch (IOException e) {
                return false;
            }
        }
        return f.canExecute();
    }

    public static void setPermission(File f, FsPermission permission) throws IOException {
        FsAction other;
        FsAction user = permission.getUserAction();
        FsAction group = permission.getGroupAction();
        if (group != (other = permission.getOtherAction()) || NativeIO.isAvailable() || Shell.WINDOWS) {
            FileUtil.execSetPermission(f, permission);
            return;
        }
        boolean rv = true;
        rv = f.setReadable(group.implies(FsAction.READ), false);
        FileUtil.checkReturnValue(rv, f, permission);
        if (group.implies(FsAction.READ) != user.implies(FsAction.READ)) {
            rv = f.setReadable(user.implies(FsAction.READ), true);
            FileUtil.checkReturnValue(rv, f, permission);
        }
        rv = f.setWritable(group.implies(FsAction.WRITE), false);
        FileUtil.checkReturnValue(rv, f, permission);
        if (group.implies(FsAction.WRITE) != user.implies(FsAction.WRITE)) {
            rv = f.setWritable(user.implies(FsAction.WRITE), true);
            FileUtil.checkReturnValue(rv, f, permission);
        }
        rv = f.setExecutable(group.implies(FsAction.EXECUTE), false);
        FileUtil.checkReturnValue(rv, f, permission);
        if (group.implies(FsAction.EXECUTE) != user.implies(FsAction.EXECUTE)) {
            rv = f.setExecutable(user.implies(FsAction.EXECUTE), true);
            FileUtil.checkReturnValue(rv, f, permission);
        }
    }

    private static void checkReturnValue(boolean rv, File p, FsPermission permission) throws IOException {
        if (!rv) {
            throw new IOException("Failed to set permissions of path: " + p + " to " + String.format("%04o", permission.toShort()));
        }
    }

    private static void execSetPermission(File f, FsPermission permission) throws IOException {
        if (NativeIO.isAvailable()) {
            NativeIO.POSIX.chmod(f.getCanonicalPath(), permission.toShort());
        } else {
            FileUtil.execCommand(f, Shell.getSetPermissionCommand(String.format("%04o", permission.toShort()), false));
        }
    }

    static String execCommand(File f, String ... cmd) throws IOException {
        String[] args = new String[cmd.length + 1];
        System.arraycopy(cmd, 0, args, 0, cmd.length);
        args[cmd.length] = f.getCanonicalPath();
        String output = Shell.execCommand(args);
        return output;
    }

    public static final File createLocalTempFile(File basefile, String prefix, boolean isDeleteOnExit) throws IOException {
        File tmp = File.createTempFile(prefix + basefile.getName(), "", basefile.getParentFile());
        if (isDeleteOnExit) {
            tmp.deleteOnExit();
        }
        return tmp;
    }

    public static void replaceFile(File src, File target) throws IOException {
        if (!src.renameTo(target)) {
            int retries = 5;
            while (target.exists() && !target.delete() && retries-- >= 0) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    throw new IOException("replaceFile interrupted.");
                }
            }
            if (!src.renameTo(target)) {
                throw new IOException("Unable to rename " + src + " to " + target);
            }
        }
    }

    public static File[] listFiles(File dir) throws IOException {
        File[] files = dir.listFiles();
        if (files == null) {
            throw new IOException("Invalid directory or I/O error occurred for dir: " + dir.toString());
        }
        return files;
    }

    public static String[] list(File dir) throws IOException {
        String[] fileNames = dir.list();
        if (fileNames == null) {
            throw new IOException("Invalid directory or I/O error occurred for dir: " + dir.toString());
        }
        return fileNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String createJarWithClassPath(String inputClassPath, Path pwd, Map<String, String> callerEnv) throws IOException {
        CaseInsensitiveMap env = Shell.WINDOWS ? new CaseInsensitiveMap((Map)callerEnv) : callerEnv;
        String[] classPathEntries = inputClassPath.split(File.pathSeparator);
        for (int i = 0; i < classPathEntries.length; ++i) {
            classPathEntries[i] = StringUtils.replaceTokens(classPathEntries[i], StringUtils.ENV_VAR_PATTERN, (Map<String, String>)env);
        }
        File workingDir = new File(pwd.toString());
        if (!workingDir.mkdirs()) {
            LOG.debug("mkdirs false for " + workingDir + ", execution will continue");
        }
        ArrayList<String> classPathEntryList = new ArrayList<String>(classPathEntries.length);
        for (String classPathEntry : classPathEntries) {
            if (classPathEntry.length() == 0) continue;
            if (classPathEntry.endsWith("*")) {
                Path globPath = new Path(classPathEntry).suffix("{.jar,.JAR}");
                FileStatus[] wildcardJars = FileContext.getLocalFSFileContext().util().globStatus(globPath);
                if (wildcardJars == null) continue;
                for (FileStatus wildcardJar : wildcardJars) {
                    classPathEntryList.add(wildcardJar.getPath().toUri().toURL().toExternalForm());
                }
                continue;
            }
            File fileCpEntry = null;
            fileCpEntry = !new Path(classPathEntry).isAbsolute() ? new File(workingDir, classPathEntry) : new File(classPathEntry);
            String classPathEntryUrl = fileCpEntry.toURI().toURL().toExternalForm();
            if (classPathEntry.endsWith("/") && !classPathEntryUrl.endsWith("/")) {
                classPathEntryUrl = classPathEntryUrl + "/";
            }
            classPathEntryList.add(classPathEntryUrl);
        }
        String jarClassPath = StringUtils.join((CharSequence)" ", classPathEntryList);
        Manifest jarManifest = new Manifest();
        jarManifest.getMainAttributes().putValue(Attributes.Name.MANIFEST_VERSION.toString(), "1.0");
        jarManifest.getMainAttributes().putValue(Attributes.Name.CLASS_PATH.toString(), jarClassPath);
        File classPathJar = File.createTempFile("classpath-", ".jar", workingDir);
        FileOutputStream fos = null;
        BufferedOutputStream bos = null;
        JarOutputStream jos = null;
        try {
            fos = new FileOutputStream(classPathJar);
            bos = new BufferedOutputStream(fos);
            jos = new JarOutputStream((OutputStream)bos, jarManifest);
        }
        catch (Throwable throwable) {
            IOUtils.cleanup(LOG, jos, bos, fos);
            throw throwable;
        }
        IOUtils.cleanup(LOG, jos, bos, fos);
        return classPathJar.getCanonicalPath();
    }

    @Deprecated
    public static class HardLink
    extends org.apache.hadoop.fs.HardLink {
    }
}

