/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import com.facebook.presto.hadoop.shaded.org.apache.commons.logging.Log;
import com.facebook.presto.hadoop.shaded.org.apache.commons.logging.LogFactory;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.hadoop.hdfs.BlockReader;
import org.apache.hadoop.hdfs.BlockReaderUtil;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.FileInputStreamCache;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.server.datanode.BlockMetadataHeader;
import org.apache.hadoop.hdfs.util.DirectBufferPool;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.util.DataChecksum;

class BlockReaderLocal
implements BlockReader {
    static final Log LOG = LogFactory.getLog(BlockReaderLocal.class);
    private final FileInputStream dataIn;
    private final FileInputStream checksumIn;
    private final boolean verifyChecksum;
    private int offsetFromChunkBoundary;
    private byte[] skipBuf = null;
    private ByteBuffer slowReadBuff = null;
    private ByteBuffer checksumBuff = null;
    private DataChecksum checksum;
    private static DirectBufferPool bufferPool = new DirectBufferPool();
    private final int bytesPerChecksum;
    private final int checksumSize;
    private long startOffset;
    private final String filename;
    private final DatanodeID datanodeID;
    private final ExtendedBlock block;
    private final FileInputStreamCache fisCache;

    private static int getSlowReadBufferNumChunks(int bufSize, int bytesPerChecksum) {
        if (bufSize < bytesPerChecksum) {
            throw new IllegalArgumentException("Configured BlockReaderLocal buffer size (" + bufSize + ") is not large enough to hold a single chunk (" + bytesPerChecksum + "). Please configure " + "dfs.client.read.shortcircuit.buffer.size" + " appropriately");
        }
        return bufSize / bytesPerChecksum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BlockReaderLocal(DFSClient.Conf conf, String filename, ExtendedBlock block, long startOffset, long length, FileInputStream dataIn, FileInputStream checksumIn, DatanodeID datanodeID, boolean verifyChecksum, FileInputStreamCache fisCache) throws IOException {
        long firstChunkOffset;
        this.dataIn = dataIn;
        this.checksumIn = checksumIn;
        this.startOffset = Math.max(startOffset, 0L);
        this.filename = filename;
        this.datanodeID = datanodeID;
        this.block = block;
        this.fisCache = fisCache;
        checksumIn.getChannel().position(0L);
        BlockMetadataHeader header = BlockMetadataHeader.readHeader(new DataInputStream(new BufferedInputStream(checksumIn, BlockMetadataHeader.getHeaderSize())));
        short version = header.getVersion();
        if (version != 1) {
            throw new IOException("Wrong version (" + version + ") of the " + "metadata file for " + filename + ".");
        }
        boolean bl = this.verifyChecksum = verifyChecksum && !conf.skipShortCircuitChecksums;
        if (this.verifyChecksum) {
            this.checksum = header.getChecksum();
            this.bytesPerChecksum = this.checksum.getBytesPerChecksum();
            this.checksumSize = this.checksum.getChecksumSize();
            firstChunkOffset = startOffset - startOffset % (long)this.checksum.getBytesPerChecksum();
            this.offsetFromChunkBoundary = (int)(startOffset - firstChunkOffset);
            int chunksPerChecksumRead = BlockReaderLocal.getSlowReadBufferNumChunks(conf.shortCircuitBufferSize, this.bytesPerChecksum);
            this.slowReadBuff = bufferPool.getBuffer(this.bytesPerChecksum * chunksPerChecksumRead);
            this.checksumBuff = bufferPool.getBuffer(this.checksumSize * chunksPerChecksumRead);
            this.slowReadBuff.flip();
            this.checksumBuff.flip();
            long checkSumOffset = firstChunkOffset / (long)this.bytesPerChecksum * (long)this.checksumSize;
            IOUtils.skipFully(checksumIn, checkSumOffset);
        } else {
            firstChunkOffset = startOffset;
            this.checksum = null;
            this.bytesPerChecksum = 0;
            this.checksumSize = 0;
            this.offsetFromChunkBoundary = 0;
        }
        boolean success = false;
        try {
            this.dataIn.getChannel().position(firstChunkOffset);
            success = true;
        }
        finally {
            if (success) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Created BlockReaderLocal for file " + filename + " block " + block + " in datanode " + datanodeID);
                }
            } else {
                if (this.slowReadBuff != null) {
                    bufferPool.returnBuffer(this.slowReadBuff);
                }
                if (this.checksumBuff != null) {
                    bufferPool.returnBuffer(this.checksumBuff);
                }
            }
        }
    }

    private int fillBuffer(FileInputStream stream, ByteBuffer buf) throws IOException {
        int bytesRead = stream.getChannel().read(buf);
        if (bytesRead < 0) {
            return bytesRead;
        }
        while (buf.remaining() > 0) {
            int n = stream.getChannel().read(buf);
            if (n < 0) {
                return bytesRead;
            }
            bytesRead += n;
        }
        return bytesRead;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeSlice(ByteBuffer from, ByteBuffer to, int length) {
        int oldLimit = from.limit();
        from.limit(from.position() + length);
        try {
            to.put(from);
        }
        finally {
            from.limit(oldLimit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int read(ByteBuffer buf) throws IOException {
        int nRead = 0;
        if (this.verifyChecksum) {
            if (this.slowReadBuff.hasRemaining()) {
                int fromSlowReadBuff = Math.min(buf.remaining(), this.slowReadBuff.remaining());
                this.writeSlice(this.slowReadBuff, buf, fromSlowReadBuff);
                nRead += fromSlowReadBuff;
            }
            if (buf.remaining() >= this.bytesPerChecksum && this.offsetFromChunkBoundary == 0) {
                int len = buf.remaining() - buf.remaining() % this.bytesPerChecksum;
                len = Math.min(len, this.slowReadBuff.capacity());
                int oldlimit = buf.limit();
                buf.limit(buf.position() + len);
                int readResult = 0;
                try {
                    readResult = this.doByteBufferRead(buf);
                }
                finally {
                    buf.limit(oldlimit);
                }
                if (readResult == -1) {
                    return nRead;
                }
                nRead += readResult;
                buf.position(buf.position() + readResult);
            }
            if (buf.remaining() > 0 && buf.remaining() < this.bytesPerChecksum || this.offsetFromChunkBoundary > 0) {
                int toRead = Math.min(buf.remaining(), this.bytesPerChecksum - this.offsetFromChunkBoundary);
                int readResult = this.fillSlowReadBuffer(toRead);
                if (readResult == -1) {
                    return nRead;
                }
                int fromSlowReadBuff = Math.min(readResult, buf.remaining());
                this.writeSlice(this.slowReadBuff, buf, fromSlowReadBuff);
                nRead += fromSlowReadBuff;
            }
        } else {
            nRead = this.doByteBufferRead(buf);
            if (nRead > 0) {
                buf.position(buf.position() + nRead);
            }
        }
        return nRead;
    }

    private synchronized int doByteBufferRead(ByteBuffer buf) throws IOException {
        if (this.verifyChecksum) assert (buf.remaining() % this.bytesPerChecksum == 0);
        int dataRead = -1;
        int oldpos = buf.position();
        dataRead = this.fillBuffer(this.dataIn, buf);
        if (dataRead == -1) {
            return -1;
        }
        if (this.verifyChecksum) {
            ByteBuffer toChecksum = buf.duplicate();
            toChecksum.position(oldpos);
            toChecksum.limit(oldpos + dataRead);
            this.checksumBuff.clear();
            int numChunks = (toChecksum.remaining() + this.bytesPerChecksum - 1) / this.bytesPerChecksum;
            this.checksumBuff.limit(this.checksumSize * numChunks);
            this.fillBuffer(this.checksumIn, this.checksumBuff);
            this.checksumBuff.flip();
            this.checksum.verifyChunkedSums(toChecksum, this.checksumBuff, this.filename, this.startOffset);
        }
        if (dataRead >= 0) {
            buf.position(oldpos + Math.min(this.offsetFromChunkBoundary, dataRead));
        }
        if (dataRead < this.offsetFromChunkBoundary) {
            this.offsetFromChunkBoundary -= dataRead;
            dataRead = 0;
        } else {
            dataRead -= this.offsetFromChunkBoundary;
            this.offsetFromChunkBoundary = 0;
        }
        return dataRead;
    }

    private synchronized int fillSlowReadBuffer(int len) throws IOException {
        int nRead = -1;
        if (this.slowReadBuff.hasRemaining()) {
            nRead = Math.min(len, this.slowReadBuff.remaining());
        } else {
            int nextChunk = len + this.offsetFromChunkBoundary + (this.bytesPerChecksum - (len + this.offsetFromChunkBoundary) % this.bytesPerChecksum);
            int limit = Math.min(nextChunk, this.slowReadBuff.capacity());
            assert (limit % this.bytesPerChecksum == 0);
            this.slowReadBuff.clear();
            this.slowReadBuff.limit(limit);
            nRead = this.doByteBufferRead(this.slowReadBuff);
            if (nRead > 0) {
                this.slowReadBuff.limit(nRead + this.slowReadBuff.position());
            }
        }
        return nRead;
    }

    @Override
    public synchronized int read(byte[] buf, int off, int len) throws IOException {
        if (LOG.isTraceEnabled()) {
            LOG.trace("read off " + off + " len " + len);
        }
        if (!this.verifyChecksum) {
            return this.dataIn.read(buf, off, len);
        }
        int nRead = this.fillSlowReadBuffer(this.slowReadBuff.capacity());
        if (nRead > 0) {
            nRead = Math.min(len, nRead);
            this.slowReadBuff.get(buf, off, nRead);
        }
        return nRead;
    }

    @Override
    public synchronized long skip(long n) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("skip " + n);
        }
        if (n <= 0L) {
            return 0L;
        }
        if (!this.verifyChecksum) {
            return this.dataIn.skip(n);
        }
        int remaining = this.slowReadBuff.remaining();
        int position = this.slowReadBuff.position();
        int newPosition = position + (int)n;
        if (n <= (long)remaining) {
            assert (this.offsetFromChunkBoundary == 0);
            this.slowReadBuff.position(newPosition);
            return n;
        }
        if (n - (long)remaining <= (long)this.bytesPerChecksum) {
            this.slowReadBuff.position(position + remaining);
            if (this.skipBuf == null) {
                this.skipBuf = new byte[this.bytesPerChecksum];
            }
            int ret = this.read(this.skipBuf, 0, (int)(n - (long)remaining));
            return ret;
        }
        int myOffsetFromChunkBoundary = newPosition % this.bytesPerChecksum;
        long toskip = n - (long)remaining - (long)myOffsetFromChunkBoundary;
        this.slowReadBuff.position(this.slowReadBuff.limit());
        this.checksumBuff.position(this.checksumBuff.limit());
        IOUtils.skipFully(this.dataIn, toskip);
        long checkSumOffset = toskip / (long)this.bytesPerChecksum * (long)this.checksumSize;
        IOUtils.skipFully(this.checksumIn, checkSumOffset);
        if (this.skipBuf == null) {
            this.skipBuf = new byte[this.bytesPerChecksum];
        }
        assert (this.skipBuf.length == this.bytesPerChecksum);
        assert (myOffsetFromChunkBoundary < this.bytesPerChecksum);
        int ret = this.read(this.skipBuf, 0, myOffsetFromChunkBoundary);
        if (ret == -1) {
            return toskip;
        }
        return toskip + (long)ret;
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.fisCache != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("putting FileInputStream for " + this.filename + " back into FileInputStreamCache");
            }
            this.fisCache.put(this.datanodeID, this.block, new FileInputStream[]{this.dataIn, this.checksumIn});
        } else {
            LOG.debug("closing FileInputStream for " + this.filename);
            IOUtils.cleanup(LOG, this.dataIn, this.checksumIn);
        }
        if (this.slowReadBuff != null) {
            bufferPool.returnBuffer(this.slowReadBuff);
            this.slowReadBuff = null;
        }
        if (this.checksumBuff != null) {
            bufferPool.returnBuffer(this.checksumBuff);
            this.checksumBuff = null;
        }
        this.startOffset = -1L;
        this.checksum = null;
    }

    @Override
    public int readAll(byte[] buf, int offset, int len) throws IOException {
        return BlockReaderUtil.readAll(this, buf, offset, len);
    }

    @Override
    public void readFully(byte[] buf, int off, int len) throws IOException {
        BlockReaderUtil.readFully(this, buf, off, len);
    }

    @Override
    public int available() throws IOException {
        return Integer.MAX_VALUE;
    }

    @Override
    public boolean isLocal() {
        return true;
    }

    @Override
    public boolean isShortCircuit() {
        return true;
    }
}

