/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.client;

import java.io.IOException;
import java.net.URI;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class HdfsAdmin {
    private DistributedFileSystem dfs;

    public HdfsAdmin(URI uri, Configuration conf) throws IOException {
        FileSystem fs = FileSystem.get(uri, conf);
        if (!(fs instanceof DistributedFileSystem)) {
            throw new IllegalArgumentException("'" + uri + "' is not an HDFS URI.");
        }
        this.dfs = (DistributedFileSystem)fs;
    }

    public void setQuota(Path src, long quota) throws IOException {
        this.dfs.setQuota(src, quota, Long.MAX_VALUE);
    }

    public void clearQuota(Path src) throws IOException {
        this.dfs.setQuota(src, -1L, Long.MAX_VALUE);
    }

    public void setSpaceQuota(Path src, long spaceQuota) throws IOException {
        this.dfs.setQuota(src, Long.MAX_VALUE, spaceQuota);
    }

    public void clearSpaceQuota(Path src) throws IOException {
        this.dfs.setQuota(src, Long.MAX_VALUE, -1L);
    }

    public void allowSnapshot(Path path) throws IOException {
        this.dfs.allowSnapshot(path);
    }

    public void disallowSnapshot(Path path) throws IOException {
        this.dfs.disallowSnapshot(path);
    }
}

