/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import com.facebook.presto.hadoop.shaded.com.google.common.annotations.VisibleForTesting;
import com.facebook.presto.hadoop.shaded.com.google.common.base.Predicate;
import com.facebook.presto.hadoop.shaded.com.google.common.collect.Collections2;
import com.facebook.presto.hadoop.shaded.org.apache.commons.logging.Log;
import com.facebook.presto.hadoop.shaded.org.apache.commons.logging.LogFactory;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.DF;
import org.apache.hadoop.hdfs.server.common.Util;
import org.apache.hadoop.hdfs.server.namenode.CheckableNameNodeResource;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.NameNodeResourcePolicy;

@InterfaceAudience.Private
public class NameNodeResourceChecker {
    private static final Log LOG = LogFactory.getLog(NameNodeResourceChecker.class.getName());
    private long duReserved;
    private final Configuration conf;
    private Map<String, CheckedVolume> volumes;
    private int minimumRedundantVolumes;

    public NameNodeResourceChecker(Configuration conf) throws IOException {
        this.conf = conf;
        this.volumes = new HashMap<String, CheckedVolume>();
        this.duReserved = conf.getLong("dfs.namenode.resource.du.reserved", 0x6400000L);
        List<URI> extraCheckedVolumes = Util.stringCollectionAsURIs(conf.getTrimmedStringCollection("dfs.namenode.resource.checked.volumes"));
        Collection<URI> localEditDirs = Collections2.filter(FSNamesystem.getNamespaceEditsDirs(conf), new Predicate<URI>(){

            @Override
            public boolean apply(URI input) {
                return input.getScheme().equals("file");
            }
        });
        for (URI editsDirToCheck : localEditDirs) {
            this.addDirToCheck(editsDirToCheck, FSNamesystem.getRequiredNamespaceEditsDirs(conf).contains(editsDirToCheck));
        }
        for (URI extraDirToCheck : extraCheckedVolumes) {
            this.addDirToCheck(extraDirToCheck, true);
        }
        this.minimumRedundantVolumes = conf.getInt("dfs.namenode.resource.checked.volumes.minimum", 1);
    }

    private void addDirToCheck(URI directoryToCheck, boolean required) throws IOException {
        File dir = new File(directoryToCheck.getPath());
        if (!dir.exists()) {
            throw new IOException("Missing directory " + dir.getAbsolutePath());
        }
        CheckedVolume newVolume = new CheckedVolume(dir, required);
        CheckedVolume volume = this.volumes.get(newVolume.getVolume());
        if (volume == null || !volume.isRequired()) {
            this.volumes.put(newVolume.getVolume(), newVolume);
        }
    }

    public boolean hasAvailableDiskSpace() {
        return NameNodeResourcePolicy.areResourcesAvailable(this.volumes.values(), this.minimumRedundantVolumes);
    }

    @VisibleForTesting
    Collection<String> getVolumesLowOnSpace() throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Going to check the following volumes disk space: " + this.volumes);
        }
        ArrayList<String> lowVolumes = new ArrayList<String>();
        for (CheckedVolume volume : this.volumes.values()) {
            lowVolumes.add(volume.getVolume());
        }
        return lowVolumes;
    }

    @VisibleForTesting
    void setVolumes(Map<String, CheckedVolume> volumes) {
        this.volumes = volumes;
    }

    @VisibleForTesting
    void setMinimumReduntdantVolumes(int minimumRedundantVolumes) {
        this.minimumRedundantVolumes = minimumRedundantVolumes;
    }

    @VisibleForTesting
    class CheckedVolume
    implements CheckableNameNodeResource {
        private DF df;
        private boolean required;
        private String volume;

        public CheckedVolume(File dirToCheck, boolean required) throws IOException {
            this.df = new DF(dirToCheck, NameNodeResourceChecker.this.conf);
            this.required = required;
            this.volume = this.df.getFilesystem();
        }

        public String getVolume() {
            return this.volume;
        }

        @Override
        public boolean isRequired() {
            return this.required;
        }

        @Override
        public boolean isResourceAvailable() {
            long availableSpace = this.df.getAvailable();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Space available on volume '" + this.volume + "' is " + availableSpace);
            }
            if (availableSpace < NameNodeResourceChecker.this.duReserved) {
                LOG.warn("Space available on volume '" + this.volume + "' is " + availableSpace + ", which is below the configured reserved amount " + NameNodeResourceChecker.this.duReserved);
                return false;
            }
            return true;
        }

        public String toString() {
            return "volume: " + this.volume + " required: " + this.required + " resource available: " + this.isResourceAvailable();
        }
    }
}

