/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.tools;

import com.facebook.presto.hadoop.shaded.com.google.common.base.Charsets;
import com.facebook.presto.hadoop.shaded.org.apache.commons.cli.CommandLine;
import com.facebook.presto.hadoop.shaded.org.apache.commons.cli.Options;
import com.facebook.presto.hadoop.shaded.org.apache.commons.logging.Log;
import com.facebook.presto.hadoop.shaded.org.apache.commons.logging.LogFactory;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.URL;
import java.net.URLConnection;
import java.security.PrivilegedExceptionAction;
import java.util.Collection;
import java.util.Date;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.HftpFileSystem;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenSecretManager;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.util.GenericOptionsParser;

@InterfaceAudience.Private
public class DelegationTokenFetcher {
    private static final Log LOG = LogFactory.getLog(DelegationTokenFetcher.class);
    private static final String WEBSERVICE = "webservice";
    private static final String RENEWER = "renewer";
    private static final String CANCEL = "cancel";
    private static final String RENEW = "renew";
    private static final String PRINT = "print";
    private static final String HELP = "help";
    private static final String HELP_SHORT = "h";

    private static void printUsage(PrintStream err) {
        err.println("fetchdt retrieves delegation tokens from the NameNode");
        err.println();
        err.println("fetchdt <opts> <token file>");
        err.println("Options:");
        err.println("  --webservice <url>  Url to contact NN on");
        err.println("  --renewer <name>    Name of the delegation token renewer");
        err.println("  --cancel            Cancel the delegation token");
        err.println("  --renew             Renew the delegation token.  Delegation token must have been fetched using the --renewer <name> option.");
        err.println("  --print             Print the delegation token");
        err.println();
        GenericOptionsParser.printGenericCommandUsage(err);
        System.exit(1);
    }

    private static Collection<Token<?>> readTokens(Path file, Configuration conf) throws IOException {
        Credentials creds = Credentials.readTokenStorageFile(file, conf);
        return creds.getAllTokens();
    }

    public static void main(String[] args) throws Exception {
        final HdfsConfiguration conf = new HdfsConfiguration();
        Options fetcherOptions = new Options();
        fetcherOptions.addOption(WEBSERVICE, true, "HTTP url to reach the NameNode at");
        fetcherOptions.addOption(RENEWER, true, "Name of the delegation token renewer");
        fetcherOptions.addOption(CANCEL, false, "cancel the token");
        fetcherOptions.addOption(RENEW, false, "renew the token");
        fetcherOptions.addOption(PRINT, false, "print the token");
        fetcherOptions.addOption(HELP_SHORT, HELP, false, "print out help information");
        GenericOptionsParser parser = new GenericOptionsParser(conf, fetcherOptions, args);
        CommandLine cmd = parser.getCommandLine();
        final String webUrl = cmd.hasOption(WEBSERVICE) ? cmd.getOptionValue(WEBSERVICE) : null;
        final String renewer = cmd.hasOption(RENEWER) ? cmd.getOptionValue(RENEWER) : null;
        final boolean cancel = cmd.hasOption(CANCEL);
        final boolean renew = cmd.hasOption(RENEW);
        final boolean print = cmd.hasOption(PRINT);
        boolean help = cmd.hasOption(HELP);
        String[] remaining = parser.getRemainingArgs();
        if (help) {
            DelegationTokenFetcher.printUsage(System.out);
            System.exit(0);
        }
        if (cancel && renew || cancel && print || renew && print || cancel && renew && print) {
            System.err.println("ERROR: Only specify cancel, renew or print.");
            DelegationTokenFetcher.printUsage(System.err);
        }
        if (remaining.length != 1 || remaining[0].charAt(0) == '-') {
            System.err.println("ERROR: Must specify exacltly one token file");
            DelegationTokenFetcher.printUsage(System.err);
        }
        LocalFileSystem local = FileSystem.getLocal(conf);
        final Path tokenFile = new Path(((FileSystem)local).getWorkingDirectory(), remaining[0]);
        UserGroupInformation.getCurrentUser().doAs(new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws Exception {
                if (print) {
                    DelegationTokenIdentifier id = new DelegationTokenSecretManager(0L, 0L, 0L, 0L, null).createIdentifier();
                    for (Token token : DelegationTokenFetcher.readTokens(tokenFile, conf)) {
                        DataInputStream in = new DataInputStream(new ByteArrayInputStream(token.getIdentifier()));
                        id.readFields(in);
                        System.out.println("Token (" + id + ") for " + token.getService());
                    }
                    return null;
                }
                if (renew) {
                    for (Token token : DelegationTokenFetcher.readTokens(tokenFile, conf)) {
                        if (!token.isManaged()) continue;
                        long result = token.renew(conf);
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug("Renewed token for " + token.getService() + " until: " + new Date(result));
                    }
                } else if (cancel) {
                    for (Token token : DelegationTokenFetcher.readTokens(tokenFile, conf)) {
                        if (!token.isManaged()) continue;
                        token.cancel(conf);
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug("Cancelled token for " + token.getService());
                    }
                } else if (webUrl != null) {
                    Credentials creds = DelegationTokenFetcher.getDTfromRemote(webUrl, renewer);
                    creds.writeTokenStorageFile(tokenFile, conf);
                    for (Token<? extends TokenIdentifier> token : creds.getAllTokens()) {
                        System.out.println("Fetched token via " + webUrl + " for " + token.getService() + " into " + tokenFile);
                    }
                } else {
                    FileSystem fs = FileSystem.get(conf);
                    Credentials cred = new Credentials();
                    Token<?>[] tokens = fs.addDelegationTokens(renewer, cred);
                    cred.writeTokenStorageFile(tokenFile, conf);
                    for (Token<?> token : tokens) {
                        System.out.println("Fetched token for " + token.getService() + " into " + tokenFile);
                    }
                }
                return null;
            }
        });
    }

    public static Credentials getDTfromRemote(String nnAddr, String renewer) throws IOException {
        FilterInputStream dis = null;
        InetSocketAddress serviceAddr = NetUtils.createSocketAddr(nnAddr);
        try {
            StringBuffer url = new StringBuffer();
            if (renewer != null) {
                url.append(nnAddr).append("/getDelegationToken").append("?").append(RENEWER).append("=").append(renewer);
            } else {
                url.append(nnAddr).append("/getDelegationToken");
            }
            URL remoteURL = new URL(url.toString());
            URLConnection connection = SecurityUtil.openSecureHttpConnection(remoteURL);
            InputStream in = connection.getInputStream();
            Credentials ts = new Credentials();
            dis = new DataInputStream(in);
            ts.readFields((DataInput)((Object)dis));
            for (Token<? extends TokenIdentifier> token : ts.getAllTokens()) {
                token.setKind(HftpFileSystem.TOKEN_KIND);
                SecurityUtil.setTokenService(token, serviceAddr);
            }
            Credentials credentials = ts;
            return credentials;
        }
        catch (Exception e) {
            throw new IOException("Unable to obtain remote token", e);
        }
        finally {
            if (dis != null) {
                dis.close();
            }
        }
    }

    public static long renewDelegationToken(String nnAddr, Token<DelegationTokenIdentifier> tok) throws IOException {
        StringBuilder buf = new StringBuilder();
        buf.append(nnAddr);
        buf.append("/renewDelegationToken");
        buf.append("?");
        buf.append("token");
        buf.append("=");
        buf.append(tok.encodeToUrlString());
        BufferedReader in = null;
        HttpURLConnection connection = null;
        try {
            URL url = new URL(buf.toString());
            connection = (HttpURLConnection)SecurityUtil.openSecureHttpConnection(url);
            if (connection.getResponseCode() != 200) {
                throw new IOException("Error renewing token: " + connection.getResponseMessage());
            }
            in = new BufferedReader(new InputStreamReader(connection.getInputStream(), Charsets.UTF_8));
            long result = Long.parseLong(in.readLine());
            in.close();
            return result;
        }
        catch (IOException ie) {
            LOG.info("error in renew over HTTP", ie);
            IOException e = DelegationTokenFetcher.getExceptionFromResponse(connection);
            IOUtils.cleanup(LOG, in);
            if (e != null) {
                LOG.info("rethrowing exception from HTTP request: " + e.getLocalizedMessage());
                throw e;
            }
            throw ie;
        }
    }

    private static IOException getExceptionFromResponse(HttpURLConnection con) {
        String resp;
        Throwable e = null;
        if (con == null) {
            return null;
        }
        try {
            resp = con.getResponseMessage();
        }
        catch (IOException ie) {
            return null;
        }
        if (resp == null || resp.isEmpty()) {
            return null;
        }
        String exceptionClass = "";
        String exceptionMsg = "";
        String[] rs = resp.split(";");
        if (rs.length < 2) {
            return null;
        }
        exceptionClass = rs[0];
        exceptionMsg = rs[1];
        LOG.info("Error response from HTTP request=" + resp + ";ec=" + exceptionClass + ";em=" + exceptionMsg);
        if (exceptionClass == null || exceptionClass.isEmpty()) {
            return null;
        }
        try {
            Class<Exception> ec = Class.forName(exceptionClass).asSubclass(Exception.class);
            Constructor<Exception> constructor = ec.getConstructor(String.class);
            e = (IOException)constructor.newInstance(exceptionMsg);
        }
        catch (Exception ee) {
            LOG.warn("failed to create object of this class", ee);
        }
        if (e == null) {
            return null;
        }
        e.setStackTrace(new StackTraceElement[0]);
        LOG.info("Exception from HTTP response=" + e.getLocalizedMessage());
        return e;
    }

    public static void cancelDelegationToken(String nnAddr, Token<DelegationTokenIdentifier> tok) throws IOException {
        StringBuilder buf = new StringBuilder();
        buf.append(nnAddr);
        buf.append("/cancelDelegationToken");
        buf.append("?");
        buf.append("token");
        buf.append("=");
        buf.append(tok.encodeToUrlString());
        Object in = null;
        HttpURLConnection connection = null;
        try {
            URL url = new URL(buf.toString());
            connection = (HttpURLConnection)SecurityUtil.openSecureHttpConnection(url);
            if (connection.getResponseCode() != 200) {
                throw new IOException("Error cancelling token: " + connection.getResponseMessage());
            }
        }
        catch (IOException ie) {
            LOG.info("error in cancel over HTTP", ie);
            IOException e = DelegationTokenFetcher.getExceptionFromResponse(connection);
            IOUtils.cleanup(LOG, in);
            if (e != null) {
                LOG.info("rethrowing exception from HTTP request: " + e.getLocalizedMessage());
                throw e;
            }
            throw ie;
        }
    }
}

