/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.discovery.client;

import com.google.common.base.Preconditions;
import io.airlift.discovery.client.Announcer;
import io.airlift.discovery.client.MergingServiceSelector;
import io.airlift.discovery.client.ServiceSelector;
import io.airlift.discovery.client.ServiceSelectorConfig;
import io.airlift.discovery.client.ServiceSelectorFactory;
import io.airlift.node.NodeInfo;

public class MergingServiceSelectorFactory
implements ServiceSelectorFactory {
    private final ServiceSelectorFactory selectorFactory;
    private final Announcer announcer;
    private final NodeInfo nodeInfo;

    public MergingServiceSelectorFactory(ServiceSelectorFactory selectorFactory, Announcer announcer, NodeInfo nodeInfo) {
        this.selectorFactory = (ServiceSelectorFactory)Preconditions.checkNotNull((Object)selectorFactory, (Object)"selectorFactory is null");
        this.announcer = (Announcer)Preconditions.checkNotNull((Object)announcer, (Object)"announcer is null");
        this.nodeInfo = (NodeInfo)Preconditions.checkNotNull((Object)nodeInfo, (Object)"nodeInfo is null");
    }

    @Override
    public ServiceSelector createServiceSelector(String type, ServiceSelectorConfig selectorConfig) {
        ServiceSelector selector = this.selectorFactory.createServiceSelector(type, selectorConfig);
        return new MergingServiceSelector(selector, this.announcer, this.nodeInfo);
    }
}

