/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spark;

import com.facebook.airlift.bootstrap.LifeCycleManager;
import com.facebook.airlift.log.Level;
import com.facebook.airlift.log.Logger;
import com.facebook.airlift.log.Logging;
import com.facebook.presto.Session;
import com.facebook.presto.common.QualifiedObjectName;
import com.facebook.presto.connector.ConnectorManager;
import com.facebook.presto.cost.HistoryBasedPlanStatisticsManager;
import com.facebook.presto.cost.StatsCalculator;
import com.facebook.presto.functionNamespace.SqlInvokedFunctionNamespaceManagerConfig;
import com.facebook.presto.functionNamespace.execution.NoopSqlFunctionExecutor;
import com.facebook.presto.functionNamespace.execution.SqlFunctionExecutors;
import com.facebook.presto.functionNamespace.testing.InMemoryFunctionNamespaceManager;
import com.facebook.presto.hive.ColumnConverterProvider;
import com.facebook.presto.hive.HdfsConfiguration;
import com.facebook.presto.hive.HdfsConfigurationInitializer;
import com.facebook.presto.hive.HdfsEnvironment;
import com.facebook.presto.hive.HiveClientConfig;
import com.facebook.presto.hive.HiveColumnConverterProvider;
import com.facebook.presto.hive.HiveHdfsConfiguration;
import com.facebook.presto.hive.HivePlugin;
import com.facebook.presto.hive.MetastoreClientConfig;
import com.facebook.presto.hive.authentication.HdfsAuthentication;
import com.facebook.presto.hive.authentication.NoHdfsAuthentication;
import com.facebook.presto.hive.metastore.Database;
import com.facebook.presto.hive.metastore.MetastoreContext;
import com.facebook.presto.hive.metastore.file.FileHiveMetastore;
import com.facebook.presto.metadata.Catalog;
import com.facebook.presto.metadata.CatalogManager;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataUtil;
import com.facebook.presto.metadata.SessionPropertyManager;
import com.facebook.presto.server.PluginManager;
import com.facebook.presto.spark.PrestoSparkInjectorFactory;
import com.facebook.presto.spark.PrestoSparkLocalMetadataStorageModule;
import com.facebook.presto.spark.PrestoSparkService;
import com.facebook.presto.spark.PrestoSparkServiceWaitTimeMetrics;
import com.facebook.presto.spark.classloader_interface.IPrestoSparkQueryExecution;
import com.facebook.presto.spark.classloader_interface.IPrestoSparkQueryExecutionFactory;
import com.facebook.presto.spark.classloader_interface.IPrestoSparkTaskExecutorFactory;
import com.facebook.presto.spark.classloader_interface.PrestoSparkBootstrapTimer;
import com.facebook.presto.spark.classloader_interface.PrestoSparkConfInitializer;
import com.facebook.presto.spark.classloader_interface.PrestoSparkFailure;
import com.facebook.presto.spark.classloader_interface.PrestoSparkSession;
import com.facebook.presto.spark.classloader_interface.PrestoSparkTaskExecutorFactoryProvider;
import com.facebook.presto.spark.classloader_interface.RetryExecutionStrategy;
import com.facebook.presto.spark.classloader_interface.SparkProcessType;
import com.facebook.presto.spark.execution.AbstractPrestoSparkQueryExecution;
import com.facebook.presto.spark.execution.NativeExecutionModule;
import com.facebook.presto.spark.execution.PrestoSparkAccessControlCheckerExecution;
import com.facebook.presto.spi.ConnectorId;
import com.facebook.presto.spi.Plugin;
import com.facebook.presto.spi.eventlistener.EventListener;
import com.facebook.presto.spi.function.FunctionImplementationType;
import com.facebook.presto.spi.function.FunctionNamespaceManager;
import com.facebook.presto.spi.function.RoutineCharacteristics;
import com.facebook.presto.spi.function.SqlFunctionExecutor;
import com.facebook.presto.spi.security.AccessControl;
import com.facebook.presto.spi.security.PrincipalType;
import com.facebook.presto.split.PageSourceManager;
import com.facebook.presto.split.SplitManager;
import com.facebook.presto.sql.parser.SqlParserOptions;
import com.facebook.presto.sql.planner.ConnectorPlanOptimizerManager;
import com.facebook.presto.sql.planner.NodePartitioningManager;
import com.facebook.presto.testing.MaterializedResult;
import com.facebook.presto.testing.MaterializedRow;
import com.facebook.presto.testing.QueryRunner;
import com.facebook.presto.testing.TestingAccessControlManager;
import com.facebook.presto.testing.TestingSession;
import com.facebook.presto.tests.AbstractTestQueries;
import com.facebook.presto.tests.QueryAssertions;
import com.facebook.presto.tpch.TpchPlugin;
import com.facebook.presto.transaction.TransactionBuilder;
import com.facebook.presto.transaction.TransactionManager;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.base.Ticker;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import io.airlift.tpch.TpchTable;
import io.airlift.units.Duration;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;

public class PrestoSparkQueryRunner
implements QueryRunner {
    private static final Logger log = Logger.get(PrestoSparkQueryRunner.class);
    private static final int DEFAULT_AVAILABLE_CPU_COUNT = 4;
    private static final int DEFAULT_TASK_CONCURRENCY = 4;
    private static final Map<String, PrestoSparkQueryRunner> instances = new ConcurrentHashMap<String, PrestoSparkQueryRunner>();
    private static final SparkContextHolder sparkContextHolder = new SparkContextHolder();
    private final Session defaultSession;
    private final TransactionManager transactionManager;
    private final Metadata metadata;
    private final SplitManager splitManager;
    private final PageSourceManager pageSourceManager;
    private final NodePartitioningManager nodePartitioningManager;
    private final ConnectorPlanOptimizerManager connectorPlanOptimizerManager;
    private final StatsCalculator statsCalculator;
    private final PluginManager pluginManager;
    private final ConnectorManager connectorManager;
    private final Set<PrestoSparkServiceWaitTimeMetrics> waitTimeMetrics;
    private final HistoryBasedPlanStatisticsManager historyBasedPlanStatisticsManager;
    private final LifeCycleManager lifeCycleManager;
    private SparkContext sparkContext;
    private final PrestoSparkService prestoSparkService;
    private final TestingAccessControlManager testingAccessControlManager;
    private final FileHiveMetastore metastore;
    private final String instanceId;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    protected static final MetastoreContext METASTORE_CONTEXT = new MetastoreContext("test_user", "test_queryId", Optional.empty(), Optional.empty(), Optional.empty(), false, (ColumnConverterProvider)HiveColumnConverterProvider.DEFAULT_COLUMN_CONVERTER_PROVIDER);

    public static PrestoSparkQueryRunner createHivePrestoSparkQueryRunner() {
        return PrestoSparkQueryRunner.createHivePrestoSparkQueryRunner(TpchTable.getTables(), Optional.empty());
    }

    public static PrestoSparkQueryRunner createHivePrestoSparkQueryRunner(Optional<Path> dataDirectory) {
        return PrestoSparkQueryRunner.createHivePrestoSparkQueryRunner(TpchTable.getTables(), dataDirectory);
    }

    public static PrestoSparkQueryRunner createHivePrestoSparkQueryRunner(Iterable<TpchTable<?>> tables) {
        return PrestoSparkQueryRunner.createHivePrestoSparkQueryRunner(tables, (Map<String, String>)ImmutableMap.of(), (Map<String, String>)ImmutableMap.of(), Optional.empty());
    }

    public static PrestoSparkQueryRunner createSpilledHivePrestoSparkQueryRunner(Iterable<TpchTable<?>> tables) {
        return PrestoSparkQueryRunner.createSpilledHivePrestoSparkQueryRunner(tables, (Map<String, String>)ImmutableMap.of(), (Map<String, String>)ImmutableMap.of());
    }

    public static PrestoSparkQueryRunner createHivePrestoSparkQueryRunner(Map<String, String> additionalConfigProperties, Map<String, String> hiveProperties, Optional<Path> dataDirectory) {
        return PrestoSparkQueryRunner.createHivePrestoSparkQueryRunner(TpchTable.getTables(), additionalConfigProperties, hiveProperties, dataDirectory);
    }

    public static PrestoSparkQueryRunner createHivePrestoSparkQueryRunner(Iterable<TpchTable<?>> tables, Optional<Path> dataDirectory) {
        return PrestoSparkQueryRunner.createHivePrestoSparkQueryRunner(tables, (Map<String, String>)ImmutableMap.of(), (Map<String, String>)ImmutableMap.of(), dataDirectory);
    }

    public static PrestoSparkQueryRunner createHivePrestoSparkQueryRunner(Iterable<TpchTable<?>> tables, Map<String, String> additionalConfigProperties) {
        return PrestoSparkQueryRunner.createSpilledHivePrestoSparkQueryRunner(tables, additionalConfigProperties, (Map<String, String>)ImmutableMap.of());
    }

    public static PrestoSparkQueryRunner createSpilledHivePrestoSparkQueryRunner(Iterable<TpchTable<?>> tables, Map<String, String> additionalConfigProperties) {
        return PrestoSparkQueryRunner.createSpilledHivePrestoSparkQueryRunner(tables, additionalConfigProperties, (Map<String, String>)ImmutableMap.of());
    }

    public static PrestoSparkQueryRunner createSpilledHivePrestoSparkQueryRunner(Iterable<TpchTable<?>> tables, Map<String, String> additionalConfigProperties, Map<String, String> hiveProperties) {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("experimental.spill-enabled", "true");
        properties.put("experimental.temp-storage-buffer-size", "1MB");
        properties.put("spark.memory-revoking-threshold", "0.0");
        properties.put("experimental.spiller-spill-path", Paths.get(System.getProperty("java.io.tmpdir"), "presto", "spills").toString());
        properties.put("experimental.spiller-threads", Integer.toString(16));
        properties.putAll(additionalConfigProperties);
        return PrestoSparkQueryRunner.createHivePrestoSparkQueryRunner(tables, properties, hiveProperties, Optional.empty());
    }

    public static PrestoSparkQueryRunner createHivePrestoSparkQueryRunner(Iterable<TpchTable<?>> tables, Map<String, String> additionalConfigProperties, Map<String, String> hiveProperties, Optional<Path> dataDirectory) {
        PrestoSparkQueryRunner queryRunner = new PrestoSparkQueryRunner("hive", additionalConfigProperties, hiveProperties, (Map<String, String>)ImmutableMap.of(), dataDirectory, (ImmutableList<Module>)ImmutableList.of((Object)new NativeExecutionModule()), 4);
        FileHiveMetastore metastore = queryRunner.getMetastore();
        if (!metastore.getDatabase(METASTORE_CONTEXT, "tpch").isPresent()) {
            metastore.createDatabase(METASTORE_CONTEXT, PrestoSparkQueryRunner.createDatabaseMetastoreObject("tpch"));
            QueryAssertions.copyTpchTables((QueryRunner)queryRunner, (String)"tpch", (String)"tiny", (Session)queryRunner.getDefaultSession(), tables);
            PrestoSparkQueryRunner.copyTpchTablesBucketed(queryRunner, "tpch", "tiny", queryRunner.getDefaultSession(), tables);
        }
        return queryRunner;
    }

    public static void copyTpchTablesBucketed(QueryRunner queryRunner, String sourceCatalog, String sourceSchema, Session session, Iterable<TpchTable<?>> tables) {
        log.info("Loading data from %s.%s...", new Object[]{sourceCatalog, sourceSchema});
        long startTime = System.nanoTime();
        for (TpchTable<?> table : tables) {
            PrestoSparkQueryRunner.copyTableBucketed(queryRunner, new QualifiedObjectName(sourceCatalog, sourceSchema, table.getTableName().toLowerCase(Locale.ENGLISH)), session);
        }
        log.info("Loading from %s.%s complete in %s", new Object[]{sourceCatalog, sourceSchema, Duration.nanosSince((long)startTime).toString(TimeUnit.SECONDS)});
    }

    private static void copyTableBucketed(QueryRunner queryRunner, QualifiedObjectName table, Session session) {
        String sql;
        long start = System.nanoTime();
        String tableName = table.getObjectName() + "_bucketed";
        log.info("Running import for %s", new Object[]{tableName});
        switch (tableName) {
            case "lineitem_bucketed": 
            case "orders_bucketed": {
                sql = String.format("CREATE TABLE %s WITH (bucketed_by=array['orderkey'], bucket_count=11) AS SELECT * FROM %s", tableName, table);
                break;
            }
            default: {
                log.info("Skipping %s", new Object[]{tableName});
                return;
            }
        }
        long rows = (Long)((MaterializedRow)queryRunner.execute(session, sql).getMaterializedRows().get(0)).getField(0);
        log.info("Imported %s rows for %s in %s", new Object[]{rows, tableName, Duration.nanosSince((long)start).convertToMostSuccinctTimeUnit()});
    }

    public PrestoSparkQueryRunner(String defaultCatalog, Map<String, String> additionalConfigProperties, Map<String, String> hiveProperties, Map<String, String> additionalSparkProperties, Optional<Path> dataDirectory, ImmutableList<Module> additionalModules, int availableCpuCount) {
        Path baseDir;
        PrestoSparkQueryRunner.setupLogging();
        ImmutableMap.Builder configProperties = ImmutableMap.builder();
        configProperties.put((Object)"presto.version", (Object)"testversion");
        configProperties.put((Object)"query.hash-partition-count", (Object)Integer.toString(8));
        configProperties.put((Object)"task.writer-count", (Object)Integer.toString(2));
        configProperties.put((Object)"task.partitioned-writer-count", (Object)Integer.toString(4));
        configProperties.put((Object)"task.concurrency", (Object)Integer.toString(4));
        configProperties.putAll(additionalConfigProperties);
        ImmutableList.Builder moduleBuilder = ImmutableList.builder();
        moduleBuilder.add((Object)new PrestoSparkLocalMetadataStorageModule());
        moduleBuilder.addAll(additionalModules);
        PrestoSparkInjectorFactory injectorFactory = new PrestoSparkInjectorFactory(SparkProcessType.DRIVER, (Map)configProperties.build(), (Map)ImmutableMap.of(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), new SqlParserOptions(), (List)moduleBuilder.build(), true);
        Injector injector = injectorFactory.create(new PrestoSparkBootstrapTimer(Ticker.systemTicker(), false));
        this.defaultSession = TestingSession.testSessionBuilder((SessionPropertyManager)((SessionPropertyManager)injector.getInstance(SessionPropertyManager.class))).setCatalog(defaultCatalog).setSchema("tpch").build();
        this.transactionManager = (TransactionManager)injector.getInstance(TransactionManager.class);
        this.metadata = (Metadata)injector.getInstance(Metadata.class);
        this.splitManager = (SplitManager)injector.getInstance(SplitManager.class);
        this.pageSourceManager = (PageSourceManager)injector.getInstance(PageSourceManager.class);
        this.nodePartitioningManager = (NodePartitioningManager)injector.getInstance(NodePartitioningManager.class);
        this.connectorPlanOptimizerManager = (ConnectorPlanOptimizerManager)injector.getInstance(ConnectorPlanOptimizerManager.class);
        this.statsCalculator = (StatsCalculator)injector.getInstance(StatsCalculator.class);
        this.pluginManager = (PluginManager)injector.getInstance(PluginManager.class);
        this.connectorManager = (ConnectorManager)injector.getInstance(ConnectorManager.class);
        this.waitTimeMetrics = (Set)injector.getInstance((Key)new Key<Set<PrestoSparkServiceWaitTimeMetrics>>(){});
        this.historyBasedPlanStatisticsManager = (HistoryBasedPlanStatisticsManager)injector.getInstance(HistoryBasedPlanStatisticsManager.class);
        this.lifeCycleManager = (LifeCycleManager)injector.getInstance(LifeCycleManager.class);
        this.sparkContext = sparkContextHolder.get(additionalSparkProperties, availableCpuCount);
        this.prestoSparkService = (PrestoSparkService)injector.getInstance(PrestoSparkService.class);
        this.testingAccessControlManager = (TestingAccessControlManager)injector.getInstance(TestingAccessControlManager.class);
        this.pluginManager.installPlugin((Plugin)new TpchPlugin());
        ImmutableMap tpchProperties = ImmutableMap.builder().put((Object)"tpch.column-naming", (Object)"standard").build();
        if ("tpchstandard".equalsIgnoreCase(defaultCatalog)) {
            this.connectorManager.createConnection(defaultCatalog, "tpch", (Map)tpchProperties);
        } else {
            this.connectorManager.createConnection("tpch", "tpch", (Map)ImmutableMap.of());
        }
        if (dataDirectory.isPresent()) {
            baseDir = dataDirectory.get();
        } else {
            try {
                baseDir = Files.createTempDirectory("PrestoTest", new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        HiveClientConfig hiveClientConfig = new HiveClientConfig();
        MetastoreClientConfig metastoreClientConfig = new MetastoreClientConfig();
        HiveHdfsConfiguration hdfsConfiguration = new HiveHdfsConfiguration(new HdfsConfigurationInitializer(hiveClientConfig, metastoreClientConfig), (Set)ImmutableSet.of(), hiveClientConfig);
        HdfsEnvironment hdfsEnvironment = new HdfsEnvironment((HdfsConfiguration)hdfsConfiguration, metastoreClientConfig, (HdfsAuthentication)new NoHdfsAuthentication());
        this.metastore = new FileHiveMetastore(hdfsEnvironment, baseDir.resolve("hive_data").toFile().toURI().toString(), "test");
        if (!this.metastore.getDatabase(METASTORE_CONTEXT, "hive_test").isPresent()) {
            this.metastore.createDatabase(METASTORE_CONTEXT, PrestoSparkQueryRunner.createDatabaseMetastoreObject("hive_test"));
        }
        this.pluginManager.installPlugin((Plugin)new HivePlugin("hive", Optional.of(this.metastore)));
        ImmutableMap properties = ImmutableMap.builder().put((Object)"hive.experimental-optimized-partition-update-serialization-enabled", (Object)"true").put((Object)"hive.allow-drop-table", (Object)"true").put((Object)"hive.allow-rename-table", (Object)"true").put((Object)"hive.allow-rename-column", (Object)"true").put((Object)"hive.allow-add-column", (Object)"true").put((Object)"hive.allow-drop-column", (Object)"true").putAll(hiveProperties).build();
        this.connectorManager.createConnection("hive", "hive", (Map)properties);
        this.metadata.registerBuiltInFunctions(AbstractTestQueries.CUSTOM_FUNCTIONS);
        this.metadata.getFunctionAndTypeManager().addFunctionNamespace("unittest", (FunctionNamespaceManager)new InMemoryFunctionNamespaceManager("unittest", new SqlFunctionExecutors((Map)ImmutableMap.of((Object)RoutineCharacteristics.Language.SQL, (Object)FunctionImplementationType.SQL), (SqlFunctionExecutor)new NoopSqlFunctionExecutor()), new SqlInvokedFunctionNamespaceManagerConfig().setSupportedFunctionLanguages("sql")));
        CatalogManager catalogManager = (CatalogManager)injector.getInstance(CatalogManager.class);
        Catalog bogusTestingCatalog = TestingSession.createBogusTestingCatalog((String)"testing_catalog");
        catalogManager.registerCatalog(bogusTestingCatalog);
        SessionPropertyManager sessionPropertyManager = this.metadata.getSessionPropertyManager();
        sessionPropertyManager.addSystemSessionProperties(AbstractTestQueries.TEST_SYSTEM_PROPERTIES);
        sessionPropertyManager.addConnectorSessionProperties(bogusTestingCatalog.getConnectorId(), AbstractTestQueries.TEST_CATALOG_PROPERTIES);
        this.instanceId = UUID.randomUUID().toString();
        instances.put(this.instanceId, this);
    }

    private static void setupLogging() {
        Logging logging = Logging.initialize();
        logging.setLevel("org.apache.spark", Level.INFO);
        logging.setLevel("org.spark_project", Level.WARN);
        logging.setLevel("com.facebook.presto.spark", Level.INFO);
        logging.setLevel("org.apache.spark.util.ClosureCleaner", Level.ERROR);
        logging.setLevel("com.facebook.presto.security.AccessControlManager", Level.WARN);
        logging.setLevel("com.facebook.presto.server.PluginManager", Level.WARN);
        logging.setLevel("com.facebook.airlift.bootstrap", Level.WARN);
        logging.setLevel("org.apache.parquet.hadoop", Level.WARN);
        logging.setLevel("parquet.hadoop", Level.WARN);
    }

    public int getNodeCount() {
        return 4;
    }

    public Session getDefaultSession() {
        return this.defaultSession;
    }

    public TransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    public SplitManager getSplitManager() {
        return this.splitManager;
    }

    public PageSourceManager getPageSourceManager() {
        return this.pageSourceManager;
    }

    public NodePartitioningManager getNodePartitioningManager() {
        return this.nodePartitioningManager;
    }

    public ConnectorPlanOptimizerManager getPlanOptimizerManager() {
        return this.connectorPlanOptimizerManager;
    }

    public StatsCalculator getStatsCalculator() {
        return this.statsCalculator;
    }

    public Optional<EventListener> getEventListener() {
        return Optional.empty();
    }

    public TestingAccessControlManager getAccessControl() {
        return this.testingAccessControlManager;
    }

    public HistoryBasedPlanStatisticsManager getHistoryBasedPlanStatisticsManager() {
        return this.historyBasedPlanStatisticsManager;
    }

    public MaterializedResult execute(String sql) {
        return this.execute(this.defaultSession, sql);
    }

    public MaterializedResult execute(Session session, String sql) {
        try {
            return this.execute(session, sql, Optional.empty());
        }
        catch (PrestoSparkFailure failure) {
            if (failure.getRetryExecutionStrategy().isPresent()) {
                return this.execute(session, sql, failure.getRetryExecutionStrategy());
            }
            throw failure;
        }
    }

    private MaterializedResult execute(Session session, String sql, Optional<RetryExecutionStrategy> retryExecutionStrategy) {
        IPrestoSparkQueryExecution execution = this.createPrestoSparkQueryExecution(session, sql, retryExecutionStrategy);
        List results = execution.execute();
        List rows = (List)results.stream().map(result -> new MaterializedRow(5, result)).collect(ImmutableList.toImmutableList());
        if (execution instanceof AbstractPrestoSparkQueryExecution) {
            AbstractPrestoSparkQueryExecution p = (AbstractPrestoSparkQueryExecution)execution;
            if (!p.getUpdateType().isPresent()) {
                return new MaterializedResult(rows, p.getOutputTypes());
            }
            return new MaterializedResult(rows, p.getOutputTypes(), (Map)ImmutableMap.of(), (Set)ImmutableSet.of(), p.getUpdateType(), OptionalLong.of((Long)Iterables.getOnlyElement((Iterable)((MaterializedRow)Iterables.getOnlyElement((Iterable)rows)).getFields())), (List)ImmutableList.of());
        }
        if (execution instanceof PrestoSparkAccessControlCheckerExecution) {
            PrestoSparkAccessControlCheckerExecution accessControlCheckerExecution = (PrestoSparkAccessControlCheckerExecution)execution;
            return new MaterializedResult(rows, accessControlCheckerExecution.getOutputTypes(), (Map)ImmutableMap.of(), (Set)ImmutableSet.of(), Optional.empty(), OptionalLong.empty(), (List)ImmutableList.of());
        }
        return new MaterializedResult(rows, (List)ImmutableList.of(), (Map)ImmutableMap.of(), (Set)ImmutableSet.of(), Optional.empty(), OptionalLong.empty(), (List)ImmutableList.of());
    }

    public IPrestoSparkQueryExecution createPrestoSparkQueryExecution(Session session, String sql, Optional<RetryExecutionStrategy> retryExecutionStrategy) {
        IPrestoSparkQueryExecutionFactory executionFactory = this.prestoSparkService.getQueryExecutionFactory();
        IPrestoSparkQueryExecution execution = executionFactory.create(this.sparkContext, PrestoSparkQueryRunner.createSessionInfo(session, retryExecutionStrategy), Optional.of(sql), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), (PrestoSparkTaskExecutorFactoryProvider)new TestingPrestoSparkTaskExecutorFactoryProvider(this.instanceId), Optional.empty(), Optional.empty(), retryExecutionStrategy, Optional.empty());
        return execution;
    }

    private static PrestoSparkSession createSessionInfo(Session session, Optional<RetryExecutionStrategy> retryExecutionStrategy) {
        ImmutableMap.Builder catalogSessionProperties = ImmutableMap.builder();
        catalogSessionProperties.putAll((Map)session.getConnectorProperties().entrySet().stream().collect(ImmutableMap.toImmutableMap(entry -> ((ConnectorId)entry.getKey()).getCatalogName(), Map.Entry::getValue)));
        catalogSessionProperties.putAll(session.getUnprocessedCatalogProperties());
        return new PrestoSparkSession(session.getIdentity().getUser(), session.getIdentity().getPrincipal(), session.getIdentity().getExtraCredentials(), session.getCatalog(), session.getSchema(), session.getSource(), session.getUserAgent(), session.getClientInfo(), session.getClientTags(), Optional.of(session.getTimeZoneKey().getId()), Optional.empty(), session.getSystemProperties(), (Map)catalogSessionProperties.build(), session.getTraceToken());
    }

    public List<QualifiedObjectName> listTables(Session session, String catalog, String schema) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tableExists(Session session, String table) {
        this.lock.readLock().lock();
        try {
            boolean bl = (Boolean)TransactionBuilder.transaction((TransactionManager)this.transactionManager, (AccessControl)this.testingAccessControlManager).readOnly().execute(session, transactionSession -> MetadataUtil.tableExists((Metadata)this.getMetadata(), (Session)transactionSession, (String)table));
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void installPlugin(Plugin plugin) {
        this.pluginManager.installPlugin(plugin);
    }

    public void createCatalog(String catalogName, String connectorName, Map<String, String> properties) {
        this.connectorManager.createConnection(catalogName, connectorName, properties);
    }

    public void loadFunctionNamespaceManager(String functionNamespaceManagerName, String catalogName, Map<String, String> properties) {
        this.metadata.getFunctionAndTypeManager().loadFunctionNamespaceManager(functionNamespaceManagerName, catalogName, properties);
    }

    public Lock getExclusiveLock() {
        return this.lock.writeLock();
    }

    public PrestoSparkService getPrestoSparkService() {
        return this.prestoSparkService;
    }

    public FileHiveMetastore getMetastore() {
        return this.metastore;
    }

    public Set<PrestoSparkServiceWaitTimeMetrics> getWaitTimeMetrics() {
        return this.waitTimeMetrics;
    }

    public SparkContext getSparkContext() {
        return this.sparkContext;
    }

    public void resetSparkContext() {
        this.resetSparkContext((Map<String, String>)ImmutableMap.of(), 4);
    }

    public void resetSparkContext(Map<String, String> additionalSparkConfigs, int availableCpuCount) {
        sparkContextHolder.release(this.sparkContext, true);
        this.sparkContext = sparkContextHolder.get(additionalSparkConfigs, availableCpuCount);
    }

    public void close() {
        sparkContextHolder.release(this.sparkContext);
        try {
            if (this.lifeCycleManager != null) {
                this.lifeCycleManager.stop();
            }
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
        if (this.instanceId != null) {
            instances.remove(this.instanceId);
        }
    }

    private static Database createDatabaseMetastoreObject(String name) {
        return Database.builder().setDatabaseName(name).setOwnerName("public").setOwnerType(PrincipalType.ROLE).build();
    }

    private static class SparkContextHolder {
        private static SparkContext sparkContext;
        private static int referenceCount;

        private SparkContextHolder() {
        }

        public SparkContext get() {
            return this.get((Map<String, String>)ImmutableMap.of(), 4);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SparkContext get(Map<String, String> additionalSparkConfigs, int availableCpuCount) {
            Class<SparkContextHolder> clazz = SparkContextHolder.class;
            synchronized (SparkContextHolder.class) {
                if (sparkContext == null) {
                    SparkConf sparkConfiguration = new SparkConf().setMaster(String.format("local[%s]", availableCpuCount)).setAppName("presto").set("spark.driver.host", "localhost").set("spark.executor.cores", String.valueOf(4)).set("spark.task.cpus", String.valueOf(4));
                    additionalSparkConfigs.forEach((arg_0, arg_1) -> ((SparkConf)sparkConfiguration).set(arg_0, arg_1));
                    PrestoSparkConfInitializer.initialize((SparkConf)sparkConfiguration);
                    sparkContext = new SparkContext(sparkConfiguration);
                }
                ++referenceCount;
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return sparkContext;
            }
        }

        public void release(SparkContext sparkContext) {
            this.release(sparkContext, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void release(SparkContext sparkContext, boolean forceRelease) {
            Class<SparkContextHolder> clazz = SparkContextHolder.class;
            synchronized (SparkContextHolder.class) {
                Preconditions.checkState((forceRelease || sparkContext.isStopped() || SparkContextHolder.sparkContext == sparkContext ? 1 : 0) != 0, (Object)"unexpected spark context");
                if (--referenceCount == 0) {
                    sparkContext.cancelAllJobs();
                    sparkContext.stop();
                    SparkContextHolder.sparkContext = null;
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return;
            }
        }
    }

    private static class TestingPrestoSparkTaskExecutorFactoryProvider
    implements PrestoSparkTaskExecutorFactoryProvider {
        private final String instanceId;

        private TestingPrestoSparkTaskExecutorFactoryProvider(String instanceId) {
            this.instanceId = Objects.requireNonNull(instanceId, "instanceId is null");
        }

        public IPrestoSparkTaskExecutorFactory get() {
            return ((PrestoSparkQueryRunner)instances.get(this.instanceId)).getPrestoSparkService().getTaskExecutorFactory();
        }
    }
}

