/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spark;

import com.facebook.airlift.configuration.testing.ConfigAssertions;
import com.facebook.presto.spark.PrestoSparkConfig;
import com.google.common.collect.ImmutableMap;
import io.airlift.units.DataSize;
import java.util.Map;
import org.testng.annotations.Test;

public class TestPrestoSparkConfig {
    @Test
    public void testDefaults() {
        ConfigAssertions.assertRecordedDefaults((Object)((PrestoSparkConfig)ConfigAssertions.recordDefaults(PrestoSparkConfig.class)).setSparkPartitionCountAutoTuneEnabled(true).setInitialSparkPartitionCount(16).setMinSparkInputPartitionCountForAutoTune(100).setMaxSparkInputPartitionCountForAutoTune(1000).setMaxSplitsDataSizePerSparkPartition(new DataSize(2.0, DataSize.Unit.GIGABYTE)).setShuffleOutputTargetAverageRowSize(new DataSize(1.0, DataSize.Unit.KILOBYTE)).setStorageBasedBroadcastJoinEnabled(false).setStorageBasedBroadcastJoinStorage("local").setStorageBasedBroadcastJoinWriteBufferSize(new DataSize(24.0, DataSize.Unit.MEGABYTE)).setSparkBroadcastJoinMaxMemoryOverride(null).setSmileSerializationEnabled(true).setSplitAssignmentBatchSize(1000000).setMemoryRevokingThreshold(0.0).setMemoryRevokingTarget(0.0).setRetryOnOutOfMemoryBroadcastJoinEnabled(false).setRetryOnOutOfMemoryWithIncreasedMemorySettingsEnabled(false).setOutOfMemoryRetryPrestoSessionProperties("").setOutOfMemoryRetrySparkConfigs("").setAverageInputDataSizePerExecutor(new DataSize(10.0, DataSize.Unit.GIGABYTE)).setMaxExecutorCount(600).setMinExecutorCount(200).setAverageInputDataSizePerPartition(new DataSize(2.0, DataSize.Unit.GIGABYTE)).setMaxHashPartitionCount(4096).setMinHashPartitionCount(1024).setSparkResourceAllocationStrategyEnabled(false).setRetryOnOutOfMemoryWithHigherHashPartitionCountEnabled(false).setHashPartitionCountScalingFactorOnOutOfMemory(2.0).setAdaptiveQueryExecutionEnabled(false).setAdaptiveJoinSideSwitchingEnabled(false).setExecutorAllocationStrategyEnabled(false).setHashPartitionCountAllocationStrategyEnabled(false));
    }

    @Test
    public void testExplicitPropertyMappings() {
        ImmutableMap properties = new ImmutableMap.Builder().put((Object)"spark.partition-count-auto-tune-enabled", (Object)"false").put((Object)"spark.initial-partition-count", (Object)"128").put((Object)"spark.min-spark-input-partition-count-for-auto-tune", (Object)"200").put((Object)"spark.max-spark-input-partition-count-for-auto-tune", (Object)"2000").put((Object)"spark.max-splits-data-size-per-partition", (Object)"4GB").put((Object)"spark.shuffle-output-target-average-row-size", (Object)"10kB").put((Object)"spark.storage-based-broadcast-join-enabled", (Object)"true").put((Object)"spark.storage-based-broadcast-join-storage", (Object)"tempfs").put((Object)"spark.storage-based-broadcast-join-write-buffer-size", (Object)"4MB").put((Object)"spark.broadcast-join-max-memory-override", (Object)"1GB").put((Object)"spark.smile-serialization-enabled", (Object)"false").put((Object)"spark.split-assignment-batch-size", (Object)"420").put((Object)"spark.memory-revoking-threshold", (Object)"0.5").put((Object)"spark.memory-revoking-target", (Object)"0.5").put((Object)"spark.retry-on-out-of-memory-broadcast-join-enabled", (Object)"true").put((Object)"spark.retry-on-out-of-memory-with-increased-memory-settings-enabled", (Object)"true").put((Object)"spark.retry-presto-session-properties", (Object)"query_max_memory_per_node=1MB,query_max_total_memory_per_node=1MB").put((Object)"spark.retry-spark-configs", (Object)"spark.executor.memory=1g,spark.task.cpus=5").put((Object)"spark.average-input-datasize-per-executor", (Object)"5GB").put((Object)"spark.max-executor-count", (Object)"29").put((Object)"spark.min-executor-count", (Object)"2").put((Object)"spark.average-input-datasize-per-partition", (Object)"1GB").put((Object)"spark.max-hash-partition-count", (Object)"333").put((Object)"spark.min-hash-partition-count", (Object)"30").put((Object)"spark.resource-allocation-strategy-enabled", (Object)"true").put((Object)"spark.retry-on-out-of-memory-higher-hash-partition-count-enabled", (Object)"true").put((Object)"spark.hash-partition-count-scaling-factor-on-out-of-memory", (Object)"5.6").put((Object)"spark.adaptive-query-execution-enabled", (Object)"true").put((Object)"optimizer.adaptive-join-side-switching-enabled", (Object)"true").put((Object)"spark.executor-allocation-strategy-enabled", (Object)"true").put((Object)"spark.hash-partition-count-allocation-strategy-enabled", (Object)"true").build();
        PrestoSparkConfig expected = new PrestoSparkConfig().setSparkPartitionCountAutoTuneEnabled(false).setInitialSparkPartitionCount(128).setMinSparkInputPartitionCountForAutoTune(200).setMaxSparkInputPartitionCountForAutoTune(2000).setMaxSplitsDataSizePerSparkPartition(new DataSize(4.0, DataSize.Unit.GIGABYTE)).setShuffleOutputTargetAverageRowSize(new DataSize(10.0, DataSize.Unit.KILOBYTE)).setStorageBasedBroadcastJoinEnabled(true).setStorageBasedBroadcastJoinStorage("tempfs").setStorageBasedBroadcastJoinWriteBufferSize(new DataSize(4.0, DataSize.Unit.MEGABYTE)).setSparkBroadcastJoinMaxMemoryOverride(new DataSize(1.0, DataSize.Unit.GIGABYTE)).setSmileSerializationEnabled(false).setSplitAssignmentBatchSize(420).setMemoryRevokingThreshold(0.5).setMemoryRevokingTarget(0.5).setRetryOnOutOfMemoryBroadcastJoinEnabled(true).setRetryOnOutOfMemoryWithIncreasedMemorySettingsEnabled(true).setOutOfMemoryRetryPrestoSessionProperties("query_max_memory_per_node=1MB,query_max_total_memory_per_node=1MB").setOutOfMemoryRetrySparkConfigs("spark.executor.memory=1g,spark.task.cpus=5").setAverageInputDataSizePerExecutor(new DataSize(5.0, DataSize.Unit.GIGABYTE)).setMaxExecutorCount(29).setMinExecutorCount(2).setAverageInputDataSizePerPartition(new DataSize(1.0, DataSize.Unit.GIGABYTE)).setMaxHashPartitionCount(333).setMinHashPartitionCount(30).setSparkResourceAllocationStrategyEnabled(true).setRetryOnOutOfMemoryWithHigherHashPartitionCountEnabled(true).setHashPartitionCountScalingFactorOnOutOfMemory(5.6).setAdaptiveQueryExecutionEnabled(true).setAdaptiveJoinSideSwitchingEnabled(true).setHashPartitionCountAllocationStrategyEnabled(true).setExecutorAllocationStrategyEnabled(true);
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
    }
}

