/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spark;

import com.facebook.presto.Session;
import com.facebook.presto.spark.PrestoSparkQueryRunner;
import com.facebook.presto.spi.Plugin;
import com.facebook.presto.spi.plan.OutputNode;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.TableScanNode;
import com.facebook.presto.spi.statistics.HistoryBasedPlanStatisticsProvider;
import com.facebook.presto.sql.planner.Plan;
import com.facebook.presto.sql.planner.assertions.PlanMatchPattern;
import com.facebook.presto.sql.planner.optimizations.PlanNodeSearcher;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.testing.QueryRunner;
import com.facebook.presto.tests.AbstractTestQueryFramework;
import com.facebook.presto.tests.statistics.InMemoryHistoryBasedPlanStatisticsProvider;
import com.google.common.collect.ImmutableList;
import io.airlift.tpch.TpchTable;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestPrestoSparkHistoryBasedTracking
extends AbstractTestQueryFramework {
    protected QueryRunner createQueryRunner() throws Exception {
        PrestoSparkQueryRunner queryRunner = PrestoSparkQueryRunner.createHivePrestoSparkQueryRunner(ImmutableList.of((Object)TpchTable.NATION, (Object)TpchTable.ORDERS));
        queryRunner.installPlugin(new Plugin(){

            public Iterable<HistoryBasedPlanStatisticsProvider> getHistoryBasedPlanStatisticsProviders() {
                return ImmutableList.of((Object)new InMemoryHistoryBasedPlanStatisticsProvider());
            }
        });
        return queryRunner;
    }

    @Test
    public void testTracking() {
        this.assertPlan(this.getSession(), "SELECT * FROM nation where substr(name, 1, 1) = 'A'", PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.node(TableScanNode.class, (PlanMatchPattern[])new PlanMatchPattern[0]).withOutputRowCount(22.5)}));
        this.executeAndTrackHistory("SELECT * FROM nation where substr(name, 1, 1) = 'A'");
        this.assertPlan(this.getSession(), "SELECT * FROM nation where substr(name, 1, 1) = 'A'", PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.node(TableScanNode.class, (PlanMatchPattern[])new PlanMatchPattern[0]).withOutputRowCount(2.0)}));
        this.assertPlan(this.getSession(), "SELECT * FROM nation where substr(name, 1, 1) = 'A'", PlanMatchPattern.node(OutputNode.class, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.any((PlanMatchPattern[])new PlanMatchPattern[0])}).withOutputRowCount(2.0));
    }

    @Test
    public void testBroadcastJoin() {
        try {
            this.getQueryRunner().execute("CREATE TABLE test_orders WITH (partitioned_by = ARRAY['ds', 'ts']) AS SELECT orderkey, orderpriority, comment, custkey, '2020-09-01' as ds, '00:01' as ts FROM orders where orderkey < 2000 UNION ALL SELECT orderkey, orderpriority, comment, custkey, '2020-09-02' as ds, '00:02' as ts FROM orders WHERE orderkey >= 1000 AND orderkey < 2000");
            Plan plan = this.plan("SELECT * FROM (SELECT * FROM test_orders where ds = '2020-09-01' and substr(CAST(custkey AS VARCHAR), 1, 3) <> '370') t1 JOIN (SELECT * FROM test_orders where ds = '2020-09-02' and substr(CAST(custkey AS VARCHAR), 1, 3) = '370') t2 ON t1.orderkey = t2.orderkey", this.getSession());
            Assert.assertTrue((boolean)PlanNodeSearcher.searchFrom((PlanNode)plan.getRoot()).where(node -> node instanceof JoinNode && ((JoinNode.DistributionType)((JoinNode)node).getDistributionType().get()).equals((Object)JoinNode.DistributionType.PARTITIONED)).findFirst().isPresent());
            this.executeAndTrackHistory("SELECT * FROM (SELECT * FROM test_orders where ds = '2020-09-01' and substr(CAST(custkey AS VARCHAR), 1, 3) <> '370') t1 JOIN (SELECT * FROM test_orders where ds = '2020-09-02' and substr(CAST(custkey AS VARCHAR), 1, 3) = '370') t2 ON t1.orderkey = t2.orderkey");
            plan = this.plan("SELECT * FROM (SELECT * FROM test_orders where ds = '2020-09-01' and substr(CAST(custkey AS VARCHAR), 1, 3) <> '370') t1 JOIN (SELECT * FROM test_orders where ds = '2020-09-02' and substr(CAST(custkey AS VARCHAR), 1, 3) = '370') t2 ON t1.orderkey = t2.orderkey", this.getSession());
            Assert.assertTrue((boolean)PlanNodeSearcher.searchFrom((PlanNode)plan.getRoot()).where(node -> node instanceof JoinNode && ((JoinNode.DistributionType)((JoinNode)node).getDistributionType().get()).equals((Object)JoinNode.DistributionType.REPLICATED)).findFirst().isPresent());
        }
        finally {
            this.getQueryRunner().execute("DROP TABLE IF EXISTS test_orders");
        }
    }

    private void executeAndTrackHistory(String sql) {
        this.getQueryRunner().execute(this.getSession(), sql);
        this.getHistoryProvider().waitProcessQueryEvents();
    }

    private InMemoryHistoryBasedPlanStatisticsProvider getHistoryProvider() {
        PrestoSparkQueryRunner queryRunner = (PrestoSparkQueryRunner)this.getQueryRunner();
        return (InMemoryHistoryBasedPlanStatisticsProvider)queryRunner.getHistoryBasedPlanStatisticsManager().getHistoryBasedPlanStatisticsTracker().getHistoryBasedPlanStatisticsProvider();
    }

    protected Session getSession() {
        return Session.builder((Session)super.getSession()).setSystemProperty("use_history_based_plan_statistics", "true").setSystemProperty("track_history_based_plan_statistics", "true").setCatalogSessionProperty("hive", "pushdown_filter_enabled", "true").setSystemProperty("task_concurrency", "1").build();
    }
}

