/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spark;

import com.facebook.presto.Session;
import com.facebook.presto.cost.PlanNodeStatsEstimate;
import com.facebook.presto.cost.StatsAndCosts;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.spark.PrestoSparkQueryRunner;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.TableScanNode;
import com.facebook.presto.sql.planner.Plan;
import com.facebook.presto.sql.planner.PlanFragment;
import com.facebook.presto.sql.planner.SubPlan;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.planner.assertions.PlanAssert;
import com.facebook.presto.sql.planner.assertions.PlanMatchPattern;
import com.facebook.presto.sql.planner.plan.NativeExecutionNode;
import com.facebook.presto.testing.QueryRunner;
import com.facebook.presto.tests.AbstractTestQueryFramework;
import java.util.List;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestPrestoSparkNativeExecutionPlanRewrite
extends AbstractTestQueryFramework {
    private static final Metadata METADATA = MetadataManager.createTestMetadataManager();

    private void assertPlanMatch(Session session, PlanNode actual, PlanMatchPattern expected) {
        PlanAssert.assertPlan((Session)session, (Metadata)METADATA, (node, sourceStats, lookup, session2, types) -> PlanNodeStatsEstimate.unknown(), (Plan)new Plan(actual, TypeProvider.empty(), StatsAndCosts.empty()), (PlanMatchPattern)expected);
    }

    private void assertPlanNotMatch(Session session, PlanNode actual, PlanMatchPattern expected) {
        PlanAssert.assertPlanDoesNotMatch((Session)session, (Metadata)METADATA, (node, sourceStats, lookup, session2, types) -> PlanNodeStatsEstimate.unknown(), (Plan)new Plan(actual, TypeProvider.empty(), StatsAndCosts.empty()), (PlanMatchPattern)expected);
    }

    protected QueryRunner createQueryRunner() throws Exception {
        return PrestoSparkQueryRunner.createHivePrestoSparkQueryRunner();
    }

    @Test
    public void testSingleStagePlanFragment() {
        Session session = Session.builder((Session)this.getSession()).setSystemProperty("native_execution_enabled", "true").build();
        SubPlan subPlan = this.subplan("SELECT orderkey, custkey, orderstatus, totalprice, orderdate, orderpriority, clerk, shippriority, comment FROM orders_bucketed", session);
        PlanFragment fragment = subPlan.getFragment();
        PlanNode root = fragment.getRoot();
        Assert.assertEquals((int)1, (int)fragment.getTableScanSchedulingOrder().size());
        Assert.assertTrue((boolean)fragment.getTableScanSchedulingOrder().contains(root.getId()));
        Assert.assertEquals((int)1, (int)subPlan.getAllFragments().size());
        Assert.assertTrue((boolean)(root instanceof NativeExecutionNode));
        this.assertPlanMatch(session, ((NativeExecutionNode)root).getSubPlan(), PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.node(TableScanNode.class, (PlanMatchPattern[])new PlanMatchPattern[0])}));
    }

    @Test
    public void testMultiStagePlanFragmentsWithCoordinatorOnlyFragment() {
        Session session = Session.builder((Session)this.getSession()).setSystemProperty("native_execution_enabled", "true").setSystemProperty("table_writer_merge_operator_enabled", "false").setCatalogSessionProperty("hive", "collect_column_statistics_on_write", "false").build();
        SubPlan subPlan = this.subplan("CREATE TABLE test_table_1 as SELECT orderkey, custkey FROM orders ", session);
        List fragmentList = subPlan.getAllFragments();
        Assert.assertEquals((int)2, (int)fragmentList.size());
        PlanFragment fragment1 = (PlanFragment)fragmentList.get(0);
        Assert.assertTrue((boolean)fragment1.getPartitioning().isCoordinatorOnly());
        this.assertPlanNotMatch(session, fragment1.getRoot(), PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.node(NativeExecutionNode.class, (PlanMatchPattern[])new PlanMatchPattern[0])}));
        PlanFragment fragment2 = (PlanFragment)fragmentList.get(1);
        PlanNode root = fragment2.getRoot();
        Assert.assertFalse((boolean)fragment2.getPartitioning().isCoordinatorOnly());
        Assert.assertEquals((int)1, (int)fragment2.getTableScanSchedulingOrder().size());
        Assert.assertTrue((boolean)fragment2.getTableScanSchedulingOrder().contains(root.getId()));
        Assert.assertTrue((boolean)(root instanceof NativeExecutionNode));
        this.assertPlanMatch(session, ((NativeExecutionNode)root).getSubPlan(), PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.node(TableScanNode.class, (PlanMatchPattern[])new PlanMatchPattern[0])}));
    }
}

