/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spark;

import com.facebook.presto.Session;
import com.facebook.presto.spark.PrestoSparkQueryRunner;
import com.facebook.presto.spark.PrestoSparkServiceWaitTimeMetrics;
import com.facebook.presto.spark.PrestoSparkTestingServiceWaitTimeMetrics;
import com.facebook.presto.sql.analyzer.FeaturesConfig;
import com.facebook.presto.testing.MaterializedResult;
import com.facebook.presto.testing.QueryRunner;
import com.facebook.presto.tests.AbstractTestQueryFramework;
import com.facebook.presto.tests.QueryAssertions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Ordering;
import com.google.common.io.Files;
import com.google.common.io.MoreFiles;
import com.google.common.io.RecursiveDeleteOption;
import io.airlift.tpch.TpchTable;
import io.airlift.units.Duration;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.hadoop.fs.Path;
import org.assertj.core.api.Assertions;
import org.testng.Assert;
import org.testng.FileAssert;
import org.testng.annotations.Test;

public class TestPrestoSparkQueryRunner
extends AbstractTestQueryFramework {
    protected QueryRunner createQueryRunner() throws Exception {
        return PrestoSparkQueryRunner.createHivePrestoSparkQueryRunner();
    }

    @Test
    public void testTableWrite() {
        this.assertUpdate("CREATE TABLE hive.hive_test.hive_orders AS SELECT orderkey, custkey, orderstatus, totalprice, orderdate, orderpriority, clerk, shippriority, comment FROM orders", 15000L);
        this.assertUpdate("INSERT INTO hive.hive_test.hive_orders SELECT orderkey, custkey, orderstatus, totalprice, orderdate, orderpriority, clerk, shippriority, comment FROM orders UNION ALL SELECT orderkey, custkey, orderstatus, totalprice, orderdate, orderpriority, clerk, shippriority, comment FROM orders", 30000L);
        this.assertQuery("SELECT orderkey, custkey, orderstatus, totalprice, orderdate, orderpriority, clerk, shippriority, comment FROM hive.hive_test.hive_orders", "SELECT orderkey, custkey, orderstatus, totalprice, orderdate, orderpriority, clerk, shippriority, comment FROM orders UNION ALL SELECT orderkey, custkey, orderstatus, totalprice, orderdate, orderpriority, clerk, shippriority, comment FROM orders UNION ALL SELECT orderkey, custkey, orderstatus, totalprice, orderdate, orderpriority, clerk, shippriority, comment FROM orders");
        this.assertUpdate("CREATE TABLE hive.hive_test.test_table_write_with_union AS SELECT orderkey, 'dummy' AS dummy FROM orders", 15000L);
        this.assertUpdate("INSERT INTO hive.hive_test.test_table_write_with_union SELECT orderkey, dummy FROM (   SELECT orderkey, 'a' AS dummy FROM orders UNION ALL   SELECT orderkey, 'bb' AS dummy FROM orders UNION ALL   SELECT orderkey, 'ccc' AS dummy FROM orders )", 45000L);
    }

    @Test
    public void testZeroFileCreatorForBucketedTable() {
        this.assertUpdate(this.getSession(), String.format("CREATE TABLE hive.hive_test.test_hive_orders_bucketed_join_zero_file WITH (bucketed_by=array['orderkey'], bucket_count=8) AS SELECT orderkey, custkey, orderstatus, totalprice, orderdate, orderpriority, clerk, shippriority, comment FROM orders_bucketed WHERE orderkey = 1", new Object[0]), 1L);
    }

    @Test
    public void testBucketedTableWriteSimple() {
        this.testBucketedTableWriteSimple(this.getSession(), 8, 8);
        for (Session testSession : this.getTestCompatibleBucketCountSessions()) {
            this.testBucketedTableWriteSimple(testSession, 3, 13);
            this.testBucketedTableWriteSimple(testSession, 13, 7);
            this.testBucketedTableWriteSimple(testSession, 4, 8);
            this.testBucketedTableWriteSimple(testSession, 8, 4);
        }
    }

    private void testBucketedTableWriteSimple(Session session, int inputBucketCount, int outputBucketCount) {
        this.assertUpdate(session, String.format("CREATE TABLE hive.hive_test.test_hive_orders_bucketed_simple_input WITH (bucketed_by=array['orderkey'], bucket_count=%s) AS SELECT orderkey, custkey, orderstatus, totalprice, orderdate, orderpriority, clerk, shippriority, comment FROM orders_bucketed", inputBucketCount), 15000L);
        this.assertQuery(session, "SELECT count(*) FROM hive.hive_test.test_hive_orders_bucketed_simple_input WHERE \"$bucket\" = 0", String.format("SELECT count(*) FROM orders WHERE orderkey %% %s = 0", inputBucketCount));
        this.assertUpdate(session, String.format("CREATE TABLE hive.hive_test.test_hive_orders_bucketed_simple_output WITH (bucketed_by=array['orderkey'], bucket_count=%s) AS SELECT orderkey, custkey, orderstatus, totalprice, orderdate, orderpriority, clerk, shippriority, comment FROM hive.hive_test.test_hive_orders_bucketed_simple_input", outputBucketCount), 15000L);
        this.assertQuery(session, "SELECT count(*) FROM hive.hive_test.test_hive_orders_bucketed_simple_output WHERE \"$bucket\" = 0", String.format("SELECT count(*) FROM orders WHERE orderkey %% %s = 0", outputBucketCount));
        this.dropTable("hive_test", "test_hive_orders_bucketed_simple_input");
        this.dropTable("hive_test", "test_hive_orders_bucketed_simple_output");
    }

    @Test
    public void testBucketedTableWriteAggregation() {
        this.testBucketedTableWriteAggregation(this.getSession(), 8, 8);
        for (Session testSession : this.getTestCompatibleBucketCountSessions()) {
            this.testBucketedTableWriteAggregation(testSession, 7, 13);
            this.testBucketedTableWriteAggregation(testSession, 13, 7);
            this.testBucketedTableWriteAggregation(testSession, 4, 8);
            this.testBucketedTableWriteAggregation(testSession, 8, 4);
        }
    }

    private void testBucketedTableWriteAggregation(Session session, int inputBucketCount, int outputBucketCount) {
        this.assertUpdate(session, String.format("CREATE TABLE hive.hive_test.test_hive_orders_bucketed_aggregation_input WITH (bucketed_by=array['orderkey'], bucket_count=%s) AS SELECT orderkey, custkey, orderstatus, totalprice, orderdate, orderpriority, clerk, shippriority, comment FROM orders_bucketed", inputBucketCount), 15000L);
        this.assertUpdate(session, String.format("CREATE TABLE hive.hive_test.test_hive_orders_bucketed_aggregation_output WITH (bucketed_by=array['orderkey'], bucket_count=%s) AS SELECT orderkey, sum(totalprice) totalprice FROM hive.hive_test.test_hive_orders_bucketed_aggregation_input GROUP BY orderkey", outputBucketCount), 15000L);
        this.assertQuery(session, "SELECT count(*) FROM hive.hive_test.test_hive_orders_bucketed_aggregation_output WHERE \"$bucket\" = 0", String.format("SELECT count(*) FROM orders WHERE orderkey %% %s = 0", outputBucketCount));
        this.dropTable("hive_test", "test_hive_orders_bucketed_aggregation_input");
        this.dropTable("hive_test", "test_hive_orders_bucketed_aggregation_output");
    }

    @Test
    public void testBucketedTableWriteJoin() {
        this.testBucketedTableWriteJoin(this.getSession(), 8, 8, 8);
        for (Session testSession : this.getTestCompatibleBucketCountSessions()) {
            this.testBucketedTableWriteJoin(testSession, 7, 13, 17);
            this.testBucketedTableWriteJoin(testSession, 13, 7, 17);
            this.testBucketedTableWriteJoin(testSession, 7, 7, 17);
            this.testBucketedTableWriteJoin(testSession, 4, 4, 8);
            this.testBucketedTableWriteJoin(testSession, 8, 8, 4);
            this.testBucketedTableWriteJoin(testSession, 4, 8, 8);
            this.testBucketedTableWriteJoin(testSession, 8, 4, 8);
            this.testBucketedTableWriteJoin(testSession, 4, 8, 4);
            this.testBucketedTableWriteJoin(testSession, 8, 4, 4);
        }
    }

    private void testBucketedTableWriteJoin(Session session, int firstInputBucketCount, int secondInputBucketCount, int outputBucketCount) {
        this.assertUpdate(session, String.format("CREATE TABLE hive.hive_test.test_hive_orders_bucketed_join_input_1 WITH (bucketed_by=array['orderkey'], bucket_count=%s) AS SELECT orderkey, custkey, orderstatus, totalprice, orderdate, orderpriority, clerk, shippriority, comment FROM orders_bucketed", firstInputBucketCount), 15000L);
        this.assertUpdate(session, String.format("CREATE TABLE hive.hive_test.test_hive_orders_bucketed_join_input_2 WITH (bucketed_by=array['orderkey'], bucket_count=%s) AS SELECT orderkey, custkey, orderstatus, totalprice, orderdate, orderpriority, clerk, shippriority, comment FROM orders_bucketed", secondInputBucketCount), 15000L);
        this.assertUpdate(session, String.format("CREATE TABLE hive.hive_test.test_hive_orders_bucketed_join_output WITH (bucketed_by=array['orderkey'], bucket_count=%s) AS SELECT  first.orderkey, second.totalprice FROM hive.hive_test.test_hive_orders_bucketed_join_input_1 first INNER JOIN hive.hive_test.test_hive_orders_bucketed_join_input_2 second ON first.orderkey = second.orderkey ", outputBucketCount), 15000L);
        this.assertQuery(session, "SELECT count(*) FROM hive.hive_test.test_hive_orders_bucketed_join_output WHERE \"$bucket\" = 0", String.format("SELECT count(*) FROM orders WHERE orderkey %% %s = 0", outputBucketCount));
        this.dropTable("hive_test", "test_hive_orders_bucketed_join_input_1");
        this.dropTable("hive_test", "test_hive_orders_bucketed_join_input_2");
        this.dropTable("hive_test", "test_hive_orders_bucketed_join_output");
    }

    private void dropTable(String schema, String table) {
        ((PrestoSparkQueryRunner)this.getQueryRunner()).getMetastore().dropTable(PrestoSparkQueryRunner.METASTORE_CONTEXT, schema, table, true);
    }

    @Test
    public void testAggregation() {
        this.assertQuery("select partkey, count(*) c from lineitem where partkey % 10 = 1 group by partkey having count(*) = 42");
    }

    @Test
    public void testBucketedAggregation() {
        this.assertBucketedQuery("SELECT orderkey, count(*) c FROM lineitem_bucketed WHERE partkey % 10 = 1 GROUP BY orderkey");
    }

    @Test
    public void testJoin() {
        this.assertQuery("SELECT l.orderkey, l.linenumber, p.brand FROM lineitem l, part p WHERE l.partkey = p.partkey");
    }

    @Test
    public void testBucketedJoin() {
        this.assertBucketedQuery("SELECT l.orderkey, l.linenumber, o.orderstatus FROM lineitem_bucketed l JOIN orders_bucketed o ON l.orderkey = o.orderkey WHERE l.orderkey % 223 = 42 AND l.linenumber = 4 and o.orderstatus = 'O'");
        this.assertBucketedQuery("SELECT l.orderkey, l.linenumber, o.orderstatus FROM lineitem_bucketed l JOIN orders o ON l.orderkey = o.orderkey WHERE l.orderkey % 223 = 42 AND l.linenumber = 4 and o.orderstatus = 'O'");
        this.assertBucketedQuery("SELECT l.orderkey, l.linenumber, o.orderstatus FROM lineitem l JOIN orders_bucketed o ON l.orderkey = o.orderkey WHERE l.orderkey % 223 = 42 AND l.linenumber = 4 and o.orderstatus = 'O'");
        this.assertUpdate("create table if not exists hive.hive_test.bucketed_nation_for_join_4 WITH (bucket_count = 4, bucketed_by = ARRAY['nationkey']) as select * from nation", 25L);
        this.assertUpdate("create table if not exists hive.hive_test.bucketed_nation_for_join_8 WITH (bucket_count = 8, bucketed_by = ARRAY['nationkey']) as select * from nation", 25L);
        for (Session session : this.getTestCompatibleBucketCountSessions()) {
            String expected = "SELECT * FROM nation first INNER JOIN nation second ON first.nationkey = second.nationkey";
            this.assertQuery(session, "SELECT * FROM hive.hive_test.bucketed_nation_for_join_4 first INNER JOIN hive.hive_test.bucketed_nation_for_join_8 second ON first.nationkey = second.nationkey", expected);
            this.assertQuery(session, "SELECT * FROM hive.hive_test.bucketed_nation_for_join_8 first INNER JOIN hive.hive_test.bucketed_nation_for_join_4 second ON first.nationkey = second.nationkey", expected);
            expected = "SELECT * FROM nation first INNER JOIN nation second ON first.nationkey = second.nationkey INNER JOIN nation third ON second.nationkey = third.nationkey";
            this.assertQuery(session, "SELECT * FROM hive.hive_test.bucketed_nation_for_join_4 first INNER JOIN hive.hive_test.bucketed_nation_for_join_8 second ON first.nationkey = second.nationkey INNER JOIN nation third ON second.nationkey = third.nationkey", expected);
            this.assertQuery(session, "SELECT * FROM hive.hive_test.bucketed_nation_for_join_8 first INNER JOIN hive.hive_test.bucketed_nation_for_join_4 second ON first.nationkey = second.nationkey INNER JOIN nation third ON second.nationkey = third.nationkey", expected);
        }
    }

    private List<Session> getTestCompatibleBucketCountSessions() {
        return ImmutableList.of((Object)Session.builder((Session)this.getSession()).setSystemProperty("partial_merge_pushdown_strategy", FeaturesConfig.PartialMergePushdownStrategy.PUSH_THROUGH_LOW_MEMORY_OPERATORS.name()).build(), (Object)Session.builder((Session)this.getSession()).setCatalogSessionProperty("hive", "optimize_mismatched_bucket_count", "true").build());
    }

    @Test
    public void testJoinUnderUnionALL() {
        this.assertUpdate("create table if not exists hive.hive_test.partitioned_nation_10 WITH (bucket_count = 10, bucketed_by = ARRAY['nationkey']) as select * from nation", 25L);
        this.assertUpdate("create table if not exists hive.hive_test.partitioned_nation_20 WITH (bucket_count = 20, bucketed_by = ARRAY['nationkey']) as select * from nation", 25L);
        this.assertUpdate("create table if not exists hive.hive_test.partitioned_nation_30 WITH (bucket_count = 30, bucketed_by = ARRAY['nationkey']) as select * from nation", 25L);
        this.assertQuery("SELECT hive.hive_test.partitioned_nation_10.nationkey FROM hive.hive_test.partitioned_nation_10 JOIN hive.hive_test.partitioned_nation_20   ON hive.hive_test.partitioned_nation_10.nationkey = hive.hive_test.partitioned_nation_20.nationkey UNION ALL SELECT hive.hive_test.partitioned_nation_10.nationkey FROM hive.hive_test.partitioned_nation_10 JOIN hive.hive_test.partitioned_nation_30   ON hive.hive_test.partitioned_nation_10.nationkey = hive.hive_test.partitioned_nation_30.nationkey ", "SELECT m.nationkey FROM nation m JOIN nation n   ON m.nationkey = n.nationkey UNION ALL SELECT m.nationkey FROM nation m JOIN nation n   ON m.nationkey = n.nationkey");
        this.assertQuery("SELECT nationkey FROM nation UNION ALL SELECT hive.hive_test.partitioned_nation_10.nationkey FROM hive.hive_test.partitioned_nation_10 JOIN hive.hive_test.partitioned_nation_30   ON hive.hive_test.partitioned_nation_10.nationkey = hive.hive_test.partitioned_nation_30.nationkey ", "SELECT nationkey FROM nation UNION ALL SELECT m.nationkey FROM nation m JOIN nation n   ON m.nationkey = n.nationkey");
    }

    @Test
    public void testAggregationUnderUnionAll() {
        this.assertQuery("SELECT orderkey, 1 FROM orders UNION ALL SELECT orderkey, count(*) FROM orders GROUP BY 1", "SELECT orderkey, 1 FROM orders UNION ALL SELECT orderkey, count(*) FROM orders GROUP BY orderkey");
        this.assertQuery("SELECT    o.regionkey,    l.orderkey FROM (   SELECT        *    FROM lineitem    WHERE       linenumber = 4) l CROSS JOIN (   SELECT       regionkey,       1    FROM nation    UNION ALL    SELECT       regionkey,       count(*)    FROM nation        GROUP BY regionkey) o", "SELECT    o.regionkey,    l.orderkey FROM (   SELECT        *    FROM lineitem    WHERE       linenumber = 4) l CROSS JOIN (   SELECT       regionkey,       1    FROM nation    UNION ALL    SELECT       regionkey,       count(*)    FROM nation        GROUP BY regionkey) o");
    }

    @Test
    public void testCrossJoin() {
        this.assertQuery("SELECT o.custkey, l.orderkey FROM (SELECT * FROM lineitem WHERE linenumber = 4) l CROSS JOIN (SELECT * FROM orders WHERE orderkey = 5) o");
        this.assertQuery("SELECT o.custkey, l.orderkey FROM (SELECT * FROM lineitem  WHERE linenumber = 4) l CROSS JOIN (   SELECT * FROM orders WHERE orderkey = 5    UNION ALL    SELECT * FROM orders WHERE orderkey = 5 ) o");
        this.assertUpdate("create table if not exists hive.hive_test.partitioned_nation_11 WITH (bucket_count = 11, bucketed_by = ARRAY['nationkey']) as select * from nation", 25L);
        this.assertUpdate("create table if not exists hive.hive_test.partitioned_nation_22 WITH (bucket_count = 22, bucketed_by = ARRAY['nationkey']) as select * from nation", 25L);
        this.assertUpdate("create table if not exists hive.hive_test.partitioned_nation_33 WITH (bucket_count = 33, bucketed_by = ARRAY['nationkey']) as select * from nation", 25L);
        this.assertQuery("SELECT o.orderkey, l.orderkey FROM (SELECT * FROM lineitem  WHERE linenumber = 4) l CROSS JOIN (   SELECT orderkey, 1 FROM orders WHERE orderkey = 5    UNION ALL    SELECT orderkey, count(*)        FROM orders WHERE orderkey = 5    GROUP BY 1    ) o", "SELECT o.orderkey, l.orderkey FROM (SELECT * FROM lineitem  WHERE linenumber = 4) l CROSS JOIN (   SELECT orderkey, 1 FROM orders WHERE orderkey = 5    UNION ALL    SELECT orderkey, count(*)        FROM orders WHERE orderkey = 5    GROUP BY orderkey    ) o");
        this.assertQuery("SELECT o.regionkey, l.orderkey FROM (SELECT * FROM lineitem  WHERE linenumber = 4) l CROSS JOIN (   SELECT * FROM hive.hive_test.partitioned_nation_22    UNION ALL    SELECT * FROM hive.hive_test.partitioned_nation_11 ) o", "SELECT o.regionkey, l.orderkey FROM (SELECT * FROM lineitem  WHERE linenumber = 4) l CROSS JOIN (   SELECT * FROM nation    UNION ALL    SELECT * FROM nation) o");
        this.assertQuery("SELECT o.regionkey, l.orderkey FROM (SELECT * FROM lineitem  WHERE linenumber = 4) l CROSS JOIN (   SELECT * FROM hive.hive_test.partitioned_nation_11    UNION ALL    SELECT * FROM hive.hive_test.partitioned_nation_22 ) o", "SELECT o.regionkey, l.orderkey FROM (SELECT * FROM lineitem  WHERE linenumber = 4) l CROSS JOIN (   SELECT * FROM nation    UNION ALL    SELECT * FROM nation) o");
        this.assertQuery("SELECT o.regionkey, l.orderkey FROM (SELECT * FROM lineitem  WHERE linenumber = 4) l CROSS JOIN (   SELECT * FROM hive.hive_test.partitioned_nation_11    UNION ALL    SELECT * FROM nation ) o", "SELECT o.regionkey, l.orderkey FROM (SELECT * FROM lineitem  WHERE linenumber = 4) l CROSS JOIN (   SELECT * FROM nation    UNION ALL    SELECT * FROM nation) o");
        this.assertQuery("SELECT o.regionkey, l.orderkey FROM (SELECT * FROM lineitem  WHERE linenumber = 4) l CROSS JOIN (   SELECT * FROM nation    UNION ALL    SELECT * FROM hive.hive_test.partitioned_nation_11 ) o", "SELECT o.regionkey, l.orderkey FROM (SELECT * FROM lineitem  WHERE linenumber = 4) l CROSS JOIN (   SELECT * FROM nation    UNION ALL    SELECT * FROM nation) o");
        this.assertQuery("SELECT o.regionkey, l.orderkey FROM (SELECT * FROM lineitem  WHERE linenumber = 4) l CROSS JOIN (   SELECT * FROM hive.hive_test.partitioned_nation_11    UNION ALL    SELECT * FROM nation    UNION ALL    SELECT * FROM hive.hive_test.partitioned_nation_22 ) o", "SELECT o.regionkey, l.orderkey FROM (SELECT * FROM lineitem  WHERE linenumber = 4) l CROSS JOIN (   SELECT * FROM nation    UNION ALL    SELECT * FROM nation   UNION ALL    SELECT * FROM nation) o");
    }

    @Test
    public void testNWayJoin() {
        this.assertQuery("SELECT l.orderkey, l.linenumber, p1.brand, p2.brand, p3.brand, p4.brand, p5.brand, p6.brand FROM lineitem l, part p1, part p2, part p3, part p4, part p5, part p6 WHERE l.partkey = p1.partkey AND l.partkey = p2.partkey AND l.partkey = p3.partkey AND l.partkey = p4.partkey AND l.partkey = p5.partkey AND l.partkey = p6.partkey");
    }

    @Test
    public void testBucketedNWayJoin() {
        this.assertBucketedQuery("SELECT l.orderkey, l.linenumber, o1.orderstatus, o2.orderstatus, o3.orderstatus, o4.orderstatus, o5.orderstatus, o6.orderstatus FROM lineitem_bucketed l, orders_bucketed o1, orders_bucketed o2, orders_bucketed o3, orders_bucketed o4, orders_bucketed o5, orders_bucketed o6 WHERE l.orderkey = o1.orderkey AND l.orderkey = o2.orderkey AND l.orderkey = o3.orderkey AND l.orderkey = o4.orderkey AND l.orderkey = o5.orderkey AND l.orderkey = o6.orderkey");
        this.assertBucketedQuery("SELECT l.orderkey, l.linenumber, o1.orderstatus, o2.orderstatus, o3.orderstatus, o4.orderstatus, o5.orderstatus, o6.orderstatus FROM lineitem_bucketed l, orders o1, orders_bucketed o2, orders o3, orders_bucketed o4, orders o5, orders_bucketed o6 WHERE l.orderkey = o1.orderkey AND l.orderkey = o2.orderkey AND l.orderkey = o3.orderkey AND l.orderkey = o4.orderkey AND l.orderkey = o5.orderkey AND l.orderkey = o6.orderkey");
        this.assertBucketedQuery("SELECT l.orderkey, l.linenumber, o1.orderstatus, o2.orderstatus, o3.orderstatus, o4.orderstatus, o5.orderstatus, o6.orderstatus FROM lineitem l, orders o1, orders_bucketed o2, orders o3, orders_bucketed o4, orders o5, orders_bucketed o6 WHERE l.orderkey = o1.orderkey AND l.orderkey = o2.orderkey AND l.orderkey = o3.orderkey AND l.orderkey = o4.orderkey AND l.orderkey = o5.orderkey AND l.orderkey = o6.orderkey");
    }

    @Test
    public void testUnionAll() {
        this.assertQuery("SELECT * FROM orders UNION ALL SELECT * FROM orders");
        this.assertBucketedQuery("SELECT * FROM lineitem_bucketed UNION ALL SELECT * FROM lineitem_bucketed");
        this.assertBucketedQuery("SELECT * FROM lineitem UNION ALL SELECT * FROM lineitem_bucketed");
        this.assertBucketedQuery("SELECT * FROM lineitem_bucketed UNION ALL SELECT * FROM lineitem");
    }

    @Test
    public void testBucketedUnionAll() {
        this.assertBucketedQuery("SELECT orderkey, count(*) c FROM (   SELECT * FROM lineitem_bucketed    UNION ALL    SELECT * FROM lineitem_bucketed   UNION ALL    SELECT * FROM lineitem_bucketed) GROUP BY orderkey");
        this.assertBucketedQuery("SELECT orderkey, count(*) c FROM (   SELECT * FROM lineitem_bucketed    UNION ALL    SELECT * FROM lineitem   UNION ALL    SELECT * FROM lineitem_bucketed) GROUP BY orderkey");
        this.assertBucketedQuery("SELECT orderkey, count(*) c FROM (   SELECT * FROM lineitem    UNION ALL    SELECT * FROM lineitem_bucketed   UNION ALL    SELECT * FROM lineitem) GROUP BY orderkey");
        this.assertBucketedQuery("SELECT orderkey, count(*) c FROM (   SELECT * FROM lineitem    UNION ALL    SELECT * FROM lineitem_bucketed) GROUP BY orderkey");
    }

    @Test
    public void testValues() {
        this.assertQuery("SELECT a, b FROM (VALUES (1, 'a'), (2, 'b'), (3, 'c'), (4, 'd')) t1 (a, b) ");
    }

    @Test
    public void testUnionWithAggregationAndJoin() {
        this.assertQuery("SELECT * FROM ( SELECT orderkey, count(*) FROM (   SELECT orderdate ds, orderkey FROM orders    UNION ALL    SELECT shipdate ds, orderkey FROM lineitem) a GROUP BY orderkey) t JOIN orders o ON (o.orderkey = t.orderkey)");
    }

    @Test
    public void testFailures() {
        this.assertQueryFails("SELECT * FROM orders WHERE custkey / (orderkey - orderkey) = 0", "/ by zero");
        this.assertQueryFails("CREATE TABLE hive.hive_test.hive_orders_test_failures AS (SELECT orderkey, custkey, orderstatus, totalprice, orderdate, orderpriority, clerk, shippriority, comment FROM orders) UNION ALL (SELECT orderkey, custkey, orderstatus, totalprice, orderdate, orderpriority, clerk, shippriority, comment FROM orders WHERE custkey / (orderkey - orderkey) = 0 )", "/ by zero");
    }

    @Test
    public void testSelectFromEmptyTable() {
        this.assertUpdate("CREATE TABLE hive.hive_test.empty_orders AS SELECT orderkey, custkey, orderstatus, totalprice, orderdate, orderpriority, clerk, shippriority, comment FROM orders WITH NO DATA", 0L);
        this.assertQuery("SELECT count(*) FROM hive.hive_test.empty_orders", "SELECT 0");
    }

    @Test
    public void testSelectFromEmptyBucketedTable() {
        this.assertUpdate("CREATE TABLE hive.hive_test.empty_orders_bucketed WITH (bucketed_by=array['orderkey'], bucket_count=11) AS SELECT orderkey, custkey, orderstatus, totalprice, orderdate, orderpriority, clerk, shippriority, comment FROM orders WITH NO DATA", 0L);
        this.assertQuery("SELECT count(*) FROM (SELECT orderkey, count(*) FROM hive.hive_test.empty_orders_bucketed GROUP BY orderkey)", "SELECT 0");
    }

    @Test
    public void testLimit() {
        MaterializedResult actual = this.computeActual("SELECT * FROM orders LIMIT 10");
        Assert.assertEquals((int)actual.getRowCount(), (int)10);
        actual = this.computeActual("SELECT 'a' FROM orders LIMIT 10");
        Assert.assertEquals((int)actual.getRowCount(), (int)10);
    }

    @Test
    public void testTableSampleSystem() {
        long totalRows = (Long)this.computeActual("SELECT count(*) FROM orders").getOnlyValue();
        long sampledRows = (Long)this.computeActual("SELECT count(*) FROM orders TABLESAMPLE SYSTEM (1)").getOnlyValue();
        Assertions.assertThat((long)sampledRows).isLessThan(totalRows);
    }

    @Test(enabled=false)
    public void testTimeouts() {
        String longRunningCrossJoin = "SELECT count(l1.orderkey), count(l2.orderkey) FROM lineitem l1, lineitem l2";
        Session queryMaxRunTimeLimitSession = Session.builder((Session)this.getSession()).setSystemProperty("query_max_run_time", "2s").build();
        this.assertQueryFails(queryMaxRunTimeLimitSession, longRunningCrossJoin, "Query exceeded maximum time limit of 2.00s");
        Session queryMaxExecutionTimeLimitSession = Session.builder((Session)this.getSession()).setSystemProperty("query_max_run_time", "3s").setSystemProperty("query_max_execution_time", "2s").build();
        this.assertQueryFails(queryMaxExecutionTimeLimitSession, longRunningCrossJoin, "Query exceeded maximum time limit of 2.00s");
        Set<PrestoSparkServiceWaitTimeMetrics> waitTimeMetrics = ((PrestoSparkQueryRunner)this.getQueryRunner()).getWaitTimeMetrics();
        PrestoSparkTestingServiceWaitTimeMetrics testingServiceWaitTimeMetrics = (PrestoSparkTestingServiceWaitTimeMetrics)waitTimeMetrics.stream().filter(metric -> metric instanceof PrestoSparkTestingServiceWaitTimeMetrics).findFirst().get();
        testingServiceWaitTimeMetrics.setWaitTime(new Duration(600.0, TimeUnit.SECONDS));
        queryMaxRunTimeLimitSession = Session.builder((Session)this.getSession()).setSystemProperty("query_max_execution_time", "5s").build();
        this.assertQuerySucceeds(queryMaxRunTimeLimitSession, longRunningCrossJoin);
        testingServiceWaitTimeMetrics.setWaitTime(new Duration(0.0, TimeUnit.SECONDS));
    }

    @Test
    public void testDiskBasedBroadcastJoin() {
        Session session = Session.builder((Session)this.getSession()).setSystemProperty("join_distribution_type", "BROADCAST").setSystemProperty("storage_based_broadcast_join_enabled", "true").build();
        this.assertQuery(session, "select * from lineitem l join orders o on l.orderkey = o.orderkey");
        this.assertQuery(session, "select l.orderkey from lineitem l join orders o on l.orderkey = o.orderkey Union all SELECT m.nationkey FROM nation m JOIN nation n  ON m.nationkey = n.nationkey");
        this.assertQuery(session, "SELECT o.custkey, l.orderkey FROM (SELECT * FROM lineitem WHERE linenumber = 4) l CROSS JOIN (SELECT * FROM orders WHERE orderkey = 5) o");
        this.assertQuery(session, "WITH broadcast_table1 AS (     SELECT         *     FROM lineitem     WHERE         linenumber = 1 ),broadcast_table2 AS (     SELECT         *     FROM lineitem     WHERE         linenumber = 2 ),broadcast_table3 AS (     SELECT         *     FROM lineitem     WHERE         linenumber = 3 ),broadcast_table4 AS (     SELECT         *     FROM lineitem     WHERE         linenumber = 4 )SELECT     * FROM broadcast_table1 a JOIN broadcast_table2 b     ON a.orderkey = b.orderkey JOIN broadcast_table3 c     ON a.orderkey = c.orderkey JOIN broadcast_table4 d     ON a.orderkey = d.orderkey");
    }

    @Test
    public void testStorageBasedBroadcastJoinMaxThreshold() {
        Session session = Session.builder((Session)this.getSession()).setSystemProperty("join_distribution_type", "BROADCAST").setSystemProperty("storage_based_broadcast_join_enabled", "true").setSystemProperty("query_max_total_memory_per_node", "1MB").build();
        this.assertQueryFails(session, "select * from lineitem l join orders o on l.orderkey = o.orderkey", "Query exceeded per-node broadcast memory limit of 1MB \\[Broadcast size: .*MB\\]");
    }

    @Test
    public void testStorageBasedBroadcastJoinDeserializedMaxThreshold() {
        Session session = Session.builder((Session)this.getSession()).setSystemProperty("join_distribution_type", "BROADCAST").setSystemProperty("storage_based_broadcast_join_enabled", "true").setSystemProperty("spark_broadcast_join_max_memory_override", "2MB").setSystemProperty("query_max_total_memory_per_node", "100MB").build();
        this.assertQueryFails(session, "select * from lineitem l join orders o on l.orderkey = o.orderkey", "Query exceeded per-node broadcast memory limit of 2MB \\[Broadcast size: 2.*MB\\]");
    }

    @Test
    public void testCorrectErrorMessageWhenSubPlanCreationFails() {
        String query = "with l as (select * from lineitem UNION ALL select * from lineitem UNION ALL select * from lineitem), o as (select * from orders UNION ALL select * from orders UNION ALL select * from orders) select * from l right outer join o on l.orderkey = o.orderkey";
        Session session = Session.builder((Session)this.getSession()).setSystemProperty("join_distribution_type", "partitioned").setSystemProperty("hash_partition_count", "1").setSystemProperty("query_max_total_memory_per_node", "10MB").setSystemProperty("query_max_memory", "100MB").setSystemProperty("verbose_exceeded_memory_limit_errors_enabled", "true").setSystemProperty("spark_retry_on_out_of_memory_higher_hash_partition_count_enabled", "false").setSystemProperty("query_max_stage_count", "2").build();
        this.assertQueryFails(session, query, "Number of stages in the query.* exceeds the allowed maximum.*");
    }

    @Test
    public void testRetryWithHigherHashPartitionCount() {
        String query = "with l as (select * from lineitem UNION ALL select * from lineitem UNION ALL select * from lineitem), o as (select * from orders UNION ALL select * from orders UNION ALL select * from orders) select * from l right outer join o on l.orderkey = o.orderkey";
        Session session = Session.builder((Session)this.getSession()).setSystemProperty("join_distribution_type", "partitioned").setSystemProperty("hash_partition_count", "1").setSystemProperty("query_max_total_memory_per_node", "6.5MB").setSystemProperty("query_max_memory", "100MB").setSystemProperty("verbose_exceeded_memory_limit_errors_enabled", "true").setSystemProperty("spark_retry_on_out_of_memory_higher_hash_partition_count_enabled", "false").build();
        this.assertQueryFails(session, query, "Query exceeded per-node total memory limit of .*Top Consumers: \\{HashBuilderOperator.*");
        session = Session.builder((Session)this.getSession()).setSystemProperty("join_distribution_type", "partitioned").setSystemProperty("hash_partition_count", "1").setSystemProperty("query_max_total_memory_per_node", "6.5MB").setSystemProperty("query_max_memory", "100MB").setSystemProperty("verbose_exceeded_memory_limit_errors_enabled", "true").setSystemProperty("spark_retry_on_out_of_memory_higher_hash_partition_count_enabled", "true").setSystemProperty("spark_hash_partition_count_scaling_factor_on_out_of_memory", "1.0").build();
        this.assertQueryFails(session, query, "Query exceeded per-node total memory limit of .*Top Consumers: \\{HashBuilderOperator.*");
        session = Session.builder((Session)this.getSession()).setSystemProperty("join_distribution_type", "partitioned").setSystemProperty("hash_partition_count", "1").setSystemProperty("query_max_total_memory_per_node", "6.5MB").setSystemProperty("query_max_memory", "100MB").setSystemProperty("verbose_exceeded_memory_limit_errors_enabled", "true").setSystemProperty("spark_retry_on_out_of_memory_higher_hash_partition_count_enabled", "true").build();
        this.assertQuerySucceeds(session, query);
        session = Session.builder((Session)this.getSession()).setSystemProperty("join_distribution_type", "partitioned").setSystemProperty("hash_partition_count", "1").setSystemProperty("query_max_total_memory_per_node", "6.5MB").setSystemProperty("query_max_memory", "100MB").setSystemProperty("verbose_exceeded_memory_limit_errors_enabled", "true").setSystemProperty("spark_retry_on_out_of_memory_higher_hash_partition_count_enabled", "true").setSystemProperty("spark_hash_partition_count_scaling_factor_on_out_of_memory", "2.0").build();
        this.assertQuerySucceeds(session, query);
    }

    @Test
    public void testRetryOnOutOfMemoryBroadcastJoin() {
        Session session = Session.builder((Session)this.getSession()).setSystemProperty("join_distribution_type", "BROADCAST").setSystemProperty("storage_based_broadcast_join_enabled", "true").setSystemProperty("spark_broadcast_join_max_memory_override", "10B").setSystemProperty("spark_retry_on_out_of_memory_broadcast_join_enabled", "false").build();
        this.assertQueryFails(session, "select * from lineitem l join orders o on l.orderkey = o.orderkey", "Query exceeded per-node broadcast memory limit of 10B \\[Broadcast size: .*MB\\]");
        session = Session.builder((Session)this.getSession()).setSystemProperty("join_distribution_type", "BROADCAST").setSystemProperty("storage_based_broadcast_join_enabled", "true").setSystemProperty("spark_broadcast_join_max_memory_override", "10B").setSystemProperty("spark_retry_on_out_of_memory_broadcast_join_enabled", "true").build();
        this.assertQuery(session, "select * from lineitem l join orders o on l.orderkey = o.orderkey");
    }

    @Test
    public void testRetryOnOutOfMemoryWithIncreasedContainerSize() {
        Session session = Session.builder((Session)this.getSession()).setSystemProperty("query_max_memory_per_node", "2MB").setSystemProperty("query_max_total_memory_per_node", "2MB").setSystemProperty("spark_retry_on_out_of_memory_with_increased_memory_settings_enabled", "false").build();
        this.assertQueryFails(session, "select * from lineitem l join orders o on l.orderkey = o.orderkey", ".*Query exceeded per-node .* memory limit of 2MB.*");
        session = Session.builder((Session)this.getSession()).setSystemProperty("query_max_memory_per_node", "2MB").setSystemProperty("query_max_total_memory_per_node", "2MB").setSystemProperty("spark_retry_on_out_of_memory_with_increased_memory_settings_enabled", "true").setSystemProperty("out_of_memory_retry_presto_session_properties", "query_max_memory_per_node=100MB,query_max_total_memory_per_node=100MB").setSystemProperty("out_of_memory_retry_spark_configs", "spark.executor.memory=1G").build();
        this.assertQuery(session, "select * from lineitem l join orders o on l.orderkey = o.orderkey");
    }

    @Test
    public void testSmileSerialization() {
        MaterializedResult actual;
        String query = "SELECT * FROM nation";
        try (PrestoSparkQueryRunner queryRunner = PrestoSparkQueryRunner.createHivePrestoSparkQueryRunner(ImmutableList.of((Object)TpchTable.NATION), (Map<String, String>)ImmutableMap.of((Object)"spark.smile-serialization-enabled", (Object)"true"));){
            actual = queryRunner.execute(query);
            QueryAssertions.assertEqualsIgnoreOrder((Iterable)actual, (Iterable)this.computeExpected(query, actual.getTypes()));
        }
        queryRunner = PrestoSparkQueryRunner.createHivePrestoSparkQueryRunner(ImmutableList.of((Object)TpchTable.NATION), (Map<String, String>)ImmutableMap.of((Object)"spark.smile-serialization-enabled", (Object)"false"));
        var3_3 = null;
        try {
            actual = queryRunner.execute(query);
            QueryAssertions.assertEqualsIgnoreOrder((Iterable)actual, (Iterable)this.computeExpected(query, actual.getTypes()));
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        finally {
            if (queryRunner != null) {
                if (var3_3 != null) {
                    try {
                        queryRunner.close();
                    }
                    catch (Throwable throwable) {
                        var3_3.addSuppressed(throwable);
                    }
                } else {
                    queryRunner.close();
                }
            }
        }
    }

    @Test
    public void testIterativeSplitEnumeration() {
        for (int batchSize = 1; batchSize <= 8; batchSize *= 2) {
            Session session = Session.builder((Session)this.getSession()).setSystemProperty("spark_split_assignment_batch_size", batchSize + "").build();
            this.assertQuery(session, "select partkey, count(*) c from lineitem where partkey % 10 = 1 group by partkey having count(*) = 42");
            this.assertQuery(session, "SELECT l.orderkey, l.linenumber, p.brand FROM lineitem l, part p WHERE l.partkey = p.partkey");
        }
    }

    @Test
    public void testDropTable() {
        this.assertUpdate("CREATE TABLE hive.hive_test.hive_orders1 AS SELECT orderkey, custkey, orderstatus, totalprice, orderdate, orderpriority, clerk, shippriority, comment FROM orders", 15000L);
        this.assertQuery("select count(*) from hive.hive_test.hive_orders1", "select 15000");
        this.assertQuerySucceeds("DROP TABLE hive.hive_test.hive_orders1");
        this.assertQueryFails("select count(*) from hive.hive_test.hive_orders1", ".*Table hive.hive_test.hive_orders1 does not exist");
    }

    @Test
    public void testCreateDropSchema() {
        this.assertQuerySucceeds("CREATE SCHEMA hive.hive_test_new");
        this.assertQuerySucceeds("CREATE TABLE  hive.hive_test_new.test (x bigint)");
        this.assertQueryFails("DROP SCHEMA hive.hive_test_new", "Schema not empty: hive_test_new");
        this.assertQuerySucceeds("DROP TABLE hive.hive_test_new.test");
        this.assertQuerySucceeds("ALTER SCHEMA hive.hive_test_new RENAME TO hive_test_new1");
        this.assertQueryFails("DROP SCHEMA hive.hive_test_new", ".* Schema 'hive.hive_test_new' does not exist");
        this.assertQuerySucceeds("DROP SCHEMA hive.hive_test_new1");
    }

    @Test
    public void testCreateAlterTable() {
        String createTableSql = "CREATE TABLE hive.hive_test.hive_orders_new (\n   \"x\" bigint\n)\nWITH (\n   format = 'ORC'\n)";
        this.assertQuerySucceeds(createTableSql);
        MaterializedResult actual = this.computeActual("SHOW CREATE TABLE hive.hive_test.hive_orders_new");
        Assert.assertEquals((Object)createTableSql, (Object)actual.getOnlyValue());
        this.assertQuerySucceeds("ALTER TABLE hive.hive_test.hive_orders_new RENAME TO hive.hive_test.hive_orders_new1");
        this.assertQueryFails("DROP TABLE hive.hive_test.hive_orders_new", ".* Table 'hive.hive_test.hive_orders_new' does not exist");
        this.assertQuerySucceeds("DROP TABLE hive.hive_test.hive_orders_new1");
    }

    @Test
    public void testCreateDropView() {
        String createViewSql = "CREATE VIEW hive.hive_test.hive_view AS\nSELECT *\nFROM\n  orders";
        this.assertQuerySucceeds(createViewSql);
        MaterializedResult actual = this.computeActual("SHOW CREATE VIEW hive.hive_test.hive_view");
        Assert.assertEquals((Object)createViewSql, (Object)actual.getOnlyValue());
        this.assertQuerySucceeds("DROP VIEW hive.hive_test.hive_view");
    }

    @Test
    public void testCreateExternalTable() throws Exception {
        File tempDir = Files.createTempDir();
        File dataFile = new File(tempDir, "test.txt");
        Files.write((CharSequence)"hello\nworld\n", (File)dataFile, (Charset)StandardCharsets.UTF_8);
        String createTableSql = String.format("CREATE TABLE %s.%s.test_create_external (\n   \"name\" varchar\n)\nWITH (\n   external_location = '%s',\n   format = 'TEXTFILE'\n)", this.getSession().getCatalog().get(), this.getSession().getSchema().get(), new Path(tempDir.toURI().toASCIIString()).toString());
        this.assertQuerySucceeds(createTableSql);
        MaterializedResult actual = this.computeActual("SHOW CREATE TABLE test_create_external");
        Assert.assertEquals((Object)actual.getOnlyValue(), (Object)createTableSql);
        actual = this.computeActual("SELECT name FROM test_create_external");
        Assert.assertEquals((Set)actual.getOnlyColumnAsSet(), (Set)ImmutableSet.of((Object)"hello", (Object)"world"));
        this.assertQuerySucceeds("DROP TABLE test_create_external");
        FileAssert.assertFile((File)dataFile);
        MoreFiles.deleteRecursively((java.nio.file.Path)tempDir.toPath(), (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
    }

    @Test
    public void testGrants() {
        this.assertQuerySucceeds("CREATE SCHEMA hive.hive_test_new");
        this.assertQuerySucceeds("CREATE TABLE  hive.hive_test_new.test (x bigint)");
        this.assertQuerySucceeds("GRANT SELECT,INSERT,DELETE,UPDATE ON hive.hive_test_new.test to user");
        MaterializedResult actual = this.computeActual("SHOW GRANTS ON TABLE hive.hive_test_new.test");
        List grants = actual.getMaterializedRows().stream().map(row -> row.getField(7).toString()).collect(Collectors.toList());
        Assert.assertEquals((Collection)Ordering.natural().sortedCopy(grants), (Collection)ImmutableList.of((Object)"DELETE", (Object)"INSERT", (Object)"SELECT", (Object)"UPDATE"));
        this.assertQuerySucceeds("REVOKE SELECT,INSERT ON hive.hive_test_new.test FROM user");
        actual = this.computeActual("SHOW GRANTS ON TABLE hive.hive_test_new.test");
        grants = actual.getMaterializedRows().stream().map(row -> row.getField(7).toString()).collect(Collectors.toList());
        Assert.assertEquals((Collection)Ordering.natural().sortedCopy(grants), (Collection)ImmutableList.of((Object)"DELETE", (Object)"UPDATE"));
        this.assertQuerySucceeds("DROP TABLE hive.hive_test_new.test");
        this.assertQuerySucceeds("DROP SCHEMA hive.hive_test_new");
    }

    @Test
    public void testRoles() {
        this.assertQuerySucceeds("CREATE ROLE admin");
        this.assertQuerySucceeds("CREATE ROLE test_role");
        this.assertQuerySucceeds("GRANT test_role TO USER user");
        MaterializedResult actual = this.computeActual("SHOW ROLES");
        List roles = actual.getMaterializedRows().stream().map(row -> row.getField(0).toString()).collect(Collectors.toList());
        Assert.assertEquals((Collection)Ordering.natural().sortedCopy(roles), (Collection)ImmutableList.of((Object)"admin", (Object)"test_role"));
        actual = this.computeActual("SHOW ROLE GRANTS");
        roles = actual.getMaterializedRows().stream().map(row -> row.getField(0).toString()).collect(Collectors.toList());
        Assert.assertEquals((Collection)Ordering.natural().sortedCopy(roles), (Collection)ImmutableList.of((Object)"public", (Object)"test_role"));
        this.assertQuerySucceeds("REVOKE test_role FROM USER user");
        actual = this.computeActual("SHOW ROLE GRANTS");
        roles = actual.getMaterializedRows().stream().map(row -> row.getField(0).toString()).collect(Collectors.toList());
        Assert.assertEquals((Collection)Ordering.natural().sortedCopy(roles), (Collection)ImmutableList.of((Object)"public"));
        this.assertQuerySucceeds("DROP ROLE test_role");
    }

    @Test
    public void testAddColumns() {
        this.assertQuerySucceeds("CREATE TABLE test_add_column (a bigint COMMENT 'test comment AAA')");
        this.assertQuerySucceeds("ALTER TABLE test_add_column ADD COLUMN b bigint COMMENT 'test comment BBB'");
        this.assertQueryFails("ALTER TABLE test_add_column ADD COLUMN a varchar", ".* Column 'a' already exists");
        this.assertQueryFails("ALTER TABLE test_add_column ADD COLUMN c bad_type", ".* Unknown type 'bad_type' for column 'c'");
        this.assertQuery("SHOW COLUMNS FROM test_add_column", "VALUES ('a', 'bigint', '', 'test comment AAA'), ('b', 'bigint', '', 'test comment BBB')");
        this.assertQuerySucceeds("DROP TABLE test_add_column");
    }

    @Test
    public void testRenameColumn() {
        String createTable = "CREATE TABLE test_rename_column\nWITH (\n  partitioned_by = ARRAY ['orderstatus']\n)\nAS\nSELECT orderkey, orderstatus FROM orders";
        this.assertUpdate(createTable, "SELECT count(*) FROM orders");
        this.assertQuerySucceeds("ALTER TABLE test_rename_column RENAME COLUMN orderkey TO new_orderkey");
        this.assertQuery("SELECT new_orderkey, orderstatus FROM test_rename_column", "SELECT orderkey, orderstatus FROM orders");
        this.assertQueryFails("ALTER TABLE test_rename_column RENAME COLUMN \"$path\" TO test", ".* Cannot rename hidden column");
        this.assertQueryFails("ALTER TABLE test_rename_column RENAME COLUMN orderstatus TO new_orderstatus", "Renaming partition columns is not supported");
        this.assertQuery("SELECT new_orderkey, orderstatus FROM test_rename_column", "SELECT orderkey, orderstatus FROM orders");
        this.assertQuerySucceeds("DROP TABLE test_rename_column");
    }

    @Test
    public void testDropColumn() {
        this.assertQueryFails("DROP TABLE hive.hive_test.hive_orders_new", ".* Table 'hive.hive_test.hive_orders_new' does not exist");
        String createTable = "CREATE TABLE test_drop_column\nWITH (\n  partitioned_by = ARRAY ['orderstatus']\n)\nAS\nSELECT custkey, orderkey, orderstatus FROM orders";
        this.assertUpdate(createTable, "SELECT count(*) FROM orders");
        this.assertQuery("SELECT orderkey, orderstatus FROM test_drop_column", "SELECT orderkey, orderstatus FROM orders");
        this.assertQueryFails("ALTER TABLE test_drop_column DROP COLUMN \"$path\"", ".* Cannot drop hidden column");
        this.assertQueryFails("ALTER TABLE test_drop_column DROP COLUMN orderstatus", "Cannot drop partition columns");
        this.assertQuerySucceeds("ALTER TABLE test_drop_column DROP COLUMN orderkey");
        this.assertQueryFails("ALTER TABLE test_drop_column DROP COLUMN custkey", "Cannot drop the only non-partition column in a table");
        this.assertQuery("SELECT * FROM test_drop_column", "SELECT custkey, orderstatus FROM orders");
        this.assertQuerySucceeds("DROP TABLE test_drop_column");
    }

    @Test
    public void testCreateType() {
        this.assertQuerySucceeds("CREATE TYPE unittest.memory.num AS integer");
        this.assertQuerySucceeds("CREATE TYPE unittest.memory.pair AS (fst integer, snd integer)");
        this.assertQuerySucceeds("CREATE TYPE unittest.memory.pair3 AS (fst unittest.memory.pair, snd integer)");
        this.assertQuery("SELECT p.fst.fst FROM(SELECT CAST(ROW(CAST(ROW(1,2) AS unittest.memory.pair), 3) AS unittest.memory.pair3) AS p)", "SELECT 1");
        this.assertQuerySucceeds("CREATE TYPE unittest.memory.pair3Alt AS (fst ROW(fst integer, snd integer), snd integer)");
        this.assertQuery("SELECT p.fst.snd FROM(SELECT CAST(ROW(ROW(1,2), 3) AS  unittest.memory.pair3Alt) AS p)", "SELECT 2");
    }

    @Test
    public void testCreatePartitionedTable() {
        String createPartitionedTable = "CREATE TABLE test_partition_table\nWITH (\n  format = 'Parquet',   partitioned_by = ARRAY ['orderstatus']\n)\nAS\nSELECT custkey, orderkey, orderstatus FROM orders";
        this.assertQuerySucceeds(createPartitionedTable);
        MaterializedResult actual = this.computeActual("SELECT count(*) FROM \"test_partition_table$partitions\"");
        Assert.assertEquals((String)actual.getOnlyValue().toString(), (String)"3");
        this.assertQuerySucceeds(String.format("CALL system.create_empty_partition('%s', '%s', ARRAY['orderstatus'], ARRAY['%s'])", "tpch", "test_partition_table", "x"));
        this.assertQuerySucceeds(String.format("CALL system.create_empty_partition('%s', '%s', ARRAY['orderstatus'], ARRAY['%s'])", "tpch", "test_partition_table", "y"));
        actual = this.computeActual("SELECT count(*) FROM \"test_partition_table$partitions\"");
        Assert.assertEquals((String)actual.getOnlyValue().toString(), (String)"5");
        this.assertQuerySucceeds("DROP TABLE test_partition_table");
    }

    private void assertBucketedQuery(String sql) {
        this.assertQuery(sql, sql.replaceAll("_bucketed", ""));
    }
}

