/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spark.execution;

import com.facebook.airlift.bootstrap.Bootstrap;
import com.facebook.airlift.configuration.ConfigBinder;
import com.facebook.airlift.json.JsonBinder;
import com.facebook.airlift.json.JsonCodec;
import com.facebook.airlift.json.JsonCodecBinder;
import com.facebook.airlift.json.JsonModule;
import com.facebook.presto.Session;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.execution.Location;
import com.facebook.presto.execution.ScheduledSplit;
import com.facebook.presto.execution.TaskId;
import com.facebook.presto.execution.TaskSource;
import com.facebook.presto.execution.TaskTestUtils;
import com.facebook.presto.execution.buffer.OutputBuffers;
import com.facebook.presto.execution.scheduler.TableWriteInfo;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.metadata.HandleJsonModule;
import com.facebook.presto.metadata.RemoteTransactionHandle;
import com.facebook.presto.metadata.Split;
import com.facebook.presto.server.TaskUpdateRequest;
import com.facebook.presto.spark.execution.BatchTaskUpdateRequest;
import com.facebook.presto.spark.execution.PrestoSparkLocalShuffleReadInfo;
import com.facebook.presto.spark.execution.PrestoSparkLocalShuffleWriteInfo;
import com.facebook.presto.spark.execution.PrestoSparkShuffleReadInfo;
import com.facebook.presto.spark.execution.PrestoSparkShuffleWriteInfo;
import com.facebook.presto.spark.execution.shuffle.PrestoSparkLocalShuffleInfoTranslator;
import com.facebook.presto.spi.ConnectorId;
import com.facebook.presto.spi.ConnectorSplit;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.split.RemoteSplit;
import com.facebook.presto.sql.analyzer.FeaturesConfig;
import com.facebook.presto.sql.planner.PlanFragment;
import com.facebook.presto.testing.TestingSession;
import com.facebook.presto.type.TypeDeserializer;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.multibindings.Multibinder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestBatchTaskUpdateRequest {
    private static final JsonCodec<PlanFragment> PLAN_FRAGMENT_JSON_CODEC = JsonCodec.jsonCodec(PlanFragment.class);
    private static final JsonCodec<PrestoSparkLocalShuffleReadInfo> PRESTO_SPARK_LOCAL_SHUFFLE_READ_INFO_JSON_CODEC = JsonCodec.jsonCodec(PrestoSparkLocalShuffleReadInfo.class);
    private static final JsonCodec<PrestoSparkLocalShuffleWriteInfo> PRESTO_SPARK_LOCAL_SHUFFLE_WRITE_INFO_JSON_CODEC = JsonCodec.jsonCodec(PrestoSparkLocalShuffleWriteInfo.class);

    @Test
    public void testJsonConversion() throws Exception {
        PrestoSparkLocalShuffleInfoTranslator shuffleInfoTranslator = new PrestoSparkLocalShuffleInfoTranslator(PRESTO_SPARK_LOCAL_SHUFFLE_READ_INFO_JSON_CODEC, PRESTO_SPARK_LOCAL_SHUFFLE_WRITE_INFO_JSON_CODEC);
        PrestoSparkLocalShuffleReadInfo readInfo = new PrestoSparkLocalShuffleReadInfo(0, "test_query_id", (List)ImmutableList.of((Object)"shuffle1"), "/dummy/read/path");
        String stringSerializedReadInfo = shuffleInfoTranslator.createSerializedReadInfo((PrestoSparkShuffleReadInfo)readInfo);
        PlanNodeId planNodeId = new PlanNodeId("planNodeId");
        ArrayList<TaskSource> sources = new ArrayList<TaskSource>();
        sources.add(new TaskSource(planNodeId, (Set)ImmutableSet.of((Object)new ScheduledSplit(0L, planNodeId, new Split(new ConnectorId("connector_id"), (ConnectorTransactionHandle)new RemoteTransactionHandle(), (ConnectorSplit)new RemoteSplit(new Location(stringSerializedReadInfo), TaskId.valueOf((String)"foo.0.0.0.0"))))), true));
        Session session = TestingSession.testSessionBuilder().build();
        TaskUpdateRequest updateRequest = new TaskUpdateRequest(session.toSessionRepresentation(), session.getIdentity().getExtraCredentials(), Optional.of(TaskTestUtils.createPlanFragment().toBytes(PLAN_FRAGMENT_JSON_CODEC)), sources, OutputBuffers.createInitialEmptyOutputBuffers((OutputBuffers.BufferType)OutputBuffers.BufferType.PARTITIONED), Optional.of(new TableWriteInfo(Optional.empty(), Optional.empty(), Optional.empty())));
        String shuffleWriteInfo = "dummy-shuffle-write-info";
        BatchTaskUpdateRequest batchUpdateRequest = new BatchTaskUpdateRequest(updateRequest, Optional.of(shuffleWriteInfo));
        JsonCodec<BatchTaskUpdateRequest> batchTaskUpdateRequestJsonCodec = this.getJsonCodec();
        byte[] batchUpdateRequestJson = batchTaskUpdateRequestJsonCodec.toBytes((Object)batchUpdateRequest);
        BatchTaskUpdateRequest recoveredBatchUpdateRequest = (BatchTaskUpdateRequest)batchTaskUpdateRequestJsonCodec.fromBytes(batchUpdateRequestJson);
        List recoveredSources = recoveredBatchUpdateRequest.getTaskUpdateRequest().getSources();
        Assert.assertEquals((int)1, (int)recoveredSources.size());
        TaskSource source = (TaskSource)recoveredSources.get(0);
        Assert.assertEquals((Object)planNodeId, (Object)source.getPlanNodeId());
        Assert.assertEquals((int)1, (int)source.getSplits().size());
        Assert.assertTrue((boolean)(((ScheduledSplit)source.getSplits().toArray()[0]).getSplit().getConnectorSplit() instanceof RemoteSplit));
        RemoteSplit remoteSplit = (RemoteSplit)((ScheduledSplit)source.getSplits().toArray()[0]).getSplit().getConnectorSplit();
        Assert.assertEquals((String)stringSerializedReadInfo, (String)remoteSplit.getLocation().getLocation());
        Assert.assertEquals((String)((String)batchUpdateRequest.getShuffleWriteInfo().get()), (String)((String)recoveredBatchUpdateRequest.getShuffleWriteInfo().get()));
        Assert.assertEquals((Map)batchUpdateRequest.getTaskUpdateRequest().getExtraCredentials(), (Map)recoveredBatchUpdateRequest.getTaskUpdateRequest().getExtraCredentials());
        Assert.assertEquals((Object)batchUpdateRequest.getTaskUpdateRequest().getSession().getCatalog(), (Object)recoveredBatchUpdateRequest.getTaskUpdateRequest().getSession().getCatalog());
    }

    @Test
    public void testShuffleInfoSerialization() {
        PrestoSparkLocalShuffleInfoTranslator shuffleTranslator = new PrestoSparkLocalShuffleInfoTranslator(PRESTO_SPARK_LOCAL_SHUFFLE_READ_INFO_JSON_CODEC, PRESTO_SPARK_LOCAL_SHUFFLE_WRITE_INFO_JSON_CODEC);
        PrestoSparkLocalShuffleReadInfo readInfo = new PrestoSparkLocalShuffleReadInfo(0, "test_query_id", (List)ImmutableList.of((Object)"shuffle1"), "/dummy/read/path");
        PrestoSparkLocalShuffleWriteInfo writeInfo = new PrestoSparkLocalShuffleWriteInfo(1, "test_query_id", 0, "/dummy/write/path");
        String stringSerializedReadInfo = shuffleTranslator.createSerializedReadInfo((PrestoSparkShuffleReadInfo)readInfo);
        String stringSerializedWriteInfo = shuffleTranslator.createSerializedWriteInfo((PrestoSparkShuffleWriteInfo)writeInfo);
        Assert.assertEquals((String)stringSerializedReadInfo, (String)"{\n  \"numPartitions\" : 0,\n  \"queryId\" : \"test_query_id\",\n  \"partitionIds\" : [ \"shuffle1\" ],\n  \"rootPath\" : \"/dummy/read/path\"\n}");
        Assert.assertEquals((String)stringSerializedWriteInfo, (String)"{\n  \"numPartitions\" : 1,\n  \"queryId\" : \"test_query_id\",\n  \"shuffleId\" : 0,\n  \"rootPath\" : \"/dummy/write/path\"\n}");
    }

    private JsonCodec<BatchTaskUpdateRequest> getJsonCodec() throws Exception {
        Module module = binder -> {
            binder.install((Module)new JsonModule());
            binder.install((Module)new HandleJsonModule());
            ConfigBinder.configBinder((Binder)binder).bindConfig(FeaturesConfig.class);
            FunctionAndTypeManager functionAndTypeManager = FunctionAndTypeManager.createTestFunctionAndTypeManager();
            binder.bind(TypeManager.class).toInstance((Object)functionAndTypeManager);
            JsonBinder.jsonBinder((Binder)binder).addDeserializerBinding(Type.class).to(TypeDeserializer.class);
            Multibinder.newSetBinder((Binder)binder, Type.class);
            JsonCodecBinder.jsonCodecBinder((Binder)binder).bindJsonCodec(TaskUpdateRequest.class);
            JsonCodecBinder.jsonCodecBinder((Binder)binder).bindJsonCodec(BatchTaskUpdateRequest.class);
        };
        Bootstrap app = new Bootstrap((Iterable)ImmutableList.of((Object)module));
        Injector injector = app.doNotInitializeLogging().quiet().initialize();
        return (JsonCodec)injector.getInstance((Key)new Key<JsonCodec<BatchTaskUpdateRequest>>(){});
    }
}

