/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spark.execution;

import com.facebook.airlift.http.client.HttpClient;
import com.facebook.airlift.http.client.HttpUriBuilder;
import com.facebook.airlift.json.JsonCodec;
import com.facebook.presto.Session;
import com.facebook.presto.client.ServerInfo;
import com.facebook.presto.execution.TaskId;
import com.facebook.presto.execution.TaskManagerConfig;
import com.facebook.presto.spark.classloader_interface.PrestoSparkFatalException;
import com.facebook.presto.spark.execution.NativeExecutionProcess;
import com.facebook.presto.spark.execution.NativeExecutionProcessFactory;
import com.facebook.presto.spark.execution.http.TestPrestoSparkHttpClient;
import com.facebook.presto.spark.execution.property.NativeExecutionConnectorConfig;
import com.facebook.presto.spark.execution.property.NativeExecutionNodeConfig;
import com.facebook.presto.spark.execution.property.NativeExecutionSystemConfig;
import com.facebook.presto.spark.execution.property.NativeExecutionVeloxConfig;
import com.facebook.presto.spark.execution.property.PrestoSparkWorkerProperty;
import com.facebook.presto.spark.execution.property.WorkerProperty;
import com.facebook.presto.testing.TestingSession;
import io.airlift.units.Duration;
import java.net.URI;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestNativeExecutionProcess {
    private static final JsonCodec<ServerInfo> SERVER_INFO_JSON_CODEC = JsonCodec.jsonCodec(ServerInfo.class);
    private static final URI BASE_URI = HttpUriBuilder.uriBuilder().scheme("http").host("localhost").port(8080).build();

    @Test
    public void testNativeProcessIsAlive() {
        Session session = TestingSession.testSessionBuilder().build();
        NativeExecutionProcessFactory factory = this.createNativeExecutionProcessFactory();
        NativeExecutionProcess process = factory.getNativeExecutionProcess(session, BASE_URI);
        process.close();
        Assert.assertFalse((boolean)process.isAlive());
    }

    @Test
    public void testNativeProcessRelaunch() {
        Session session = TestingSession.testSessionBuilder().build();
        NativeExecutionProcessFactory factory = this.createNativeExecutionProcessFactory();
        NativeExecutionProcess process = factory.getNativeExecutionProcess(session, BASE_URI);
        process.close();
        Assert.assertFalse((boolean)process.isAlive());
        NativeExecutionProcess process2 = factory.getNativeExecutionProcess(session, BASE_URI);
        Assert.assertNotSame((Object)process2, (Object)process);
    }

    @Test
    public void testNativeProcessShutdown() {
        Session session = TestingSession.testSessionBuilder().setSystemProperty("native_execution_executable_path", "/bin/echo").build();
        NativeExecutionProcessFactory factory = this.createNativeExecutionProcessFactory();
        NativeExecutionProcess process = factory.createNativeExecutionProcess(session, BASE_URI, new Duration(0.0, TimeUnit.MILLISECONDS));
        Throwable exception = Assert.expectThrows(PrestoSparkFatalException.class, () -> ((NativeExecutionProcess)process).start());
        Assert.assertTrue((boolean)exception.getMessage().contains("Native process launch failed with multiple retries"));
        Assert.assertFalse((boolean)process.isAlive());
    }

    private NativeExecutionProcessFactory createNativeExecutionProcessFactory() {
        TaskId taskId = new TaskId("testid", 0, 0, 0, 0);
        ScheduledExecutorService errorScheduler = Executors.newScheduledThreadPool(4);
        PrestoSparkWorkerProperty workerProperty = new PrestoSparkWorkerProperty(new NativeExecutionConnectorConfig(), new NativeExecutionNodeConfig(), new NativeExecutionSystemConfig(), new NativeExecutionVeloxConfig());
        NativeExecutionProcessFactory factory = new NativeExecutionProcessFactory((HttpClient)new TestPrestoSparkHttpClient.TestingHttpClient(new TestPrestoSparkHttpClient.TestingResponseManager(taskId.toString(), new TestPrestoSparkHttpClient.FailureRetryResponseManager(5))), Executors.newSingleThreadExecutor(), errorScheduler, SERVER_INFO_JSON_CODEC, new TaskManagerConfig(), (WorkerProperty)workerProperty);
        return factory;
    }
}

