/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spark.execution;

import com.facebook.airlift.json.JsonCodec;
import com.facebook.presto.common.ErrorCode;
import com.facebook.presto.execution.ExecutionFailureInfo;
import com.facebook.presto.execution.Failure;
import com.facebook.presto.spark.classloader_interface.PrestoSparkExecutionException;
import com.facebook.presto.spark.execution.PrestoSparkExecutionExceptionFactory;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import org.apache.spark.ExceptionFailure;
import org.apache.spark.SparkException;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import scala.collection.JavaConversions;
import scala.collection.Seq;

public class TestPrestoSparkExecutionExceptionFactory {
    private static final String SPARK_EXCEPTION_STRING = "Job aborted due to stage failure: Task 7 in stage 3.0 failed 1 times, most recent failure: Lost task 7.0 in stage 3.0 (TID 3, localhost): ";
    private PrestoSparkExecutionExceptionFactory factory;

    @BeforeClass
    public void setup() {
        this.factory = new PrestoSparkExecutionExceptionFactory(JsonCodec.jsonCodec(ExecutionFailureInfo.class));
    }

    @AfterClass(alwaysRun=true)
    public void teardown() {
        this.factory = null;
    }

    @Test
    public void testRoundTrip() {
        String causeMessage = "cause message";
        IOException cause = new IOException(causeMessage);
        String suppressedMessage = "suppressed message";
        IllegalArgumentException suppressed = new IllegalArgumentException(suppressedMessage);
        String message = "presto exception message";
        PrestoException prestoException = new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, message, (Throwable)cause);
        prestoException.addSuppressed((Throwable)suppressed);
        PrestoSparkExecutionException executionException = this.factory.toPrestoSparkExecutionException((Throwable)prestoException);
        Optional failure = this.factory.extractExecutionFailureInfo(executionException);
        Assert.assertTrue((boolean)failure.isPresent());
        TestPrestoSparkExecutionExceptionFactory.assertFailure(((ExecutionFailureInfo)failure.get()).toFailure(), (Throwable)prestoException);
        ExceptionFailure exceptionFailure = new ExceptionFailure((Throwable)executionException, (Seq)JavaConversions.asScalaBuffer((List)ImmutableList.of()));
        SparkException sparkException = new SparkException(SPARK_EXCEPTION_STRING + exceptionFailure.toErrorString());
        failure = this.factory.extractExecutionFailureInfo(sparkException);
        Assert.assertTrue((boolean)failure.isPresent());
        TestPrestoSparkExecutionExceptionFactory.assertFailure(((ExecutionFailureInfo)failure.get()).toFailure(), (Throwable)prestoException);
    }

    private static void assertFailure(Failure failure, Throwable expected) {
        ErrorCode expectedErrorCode = expected instanceof PrestoException ? ((PrestoException)expected).getErrorCode() : StandardErrorCode.GENERIC_INTERNAL_ERROR.toErrorCode();
        Assert.assertEquals((Object)failure.getErrorCode(), (Object)expectedErrorCode);
        Assert.assertEquals((String)failure.getType(), (String)expected.getClass().getName());
        Assert.assertEquals((String)failure.getMessage(), (String)expected.getMessage());
        if (expected.getCause() != null) {
            Assert.assertNotNull((Object)failure.getCause());
            TestPrestoSparkExecutionExceptionFactory.assertFailure((Failure)failure.getCause(), expected.getCause());
        }
        if (expected.getSuppressed() != null) {
            Assert.assertNotNull((Object)failure.getSuppressed());
            Assert.assertEquals((int)failure.getSuppressed().length, (int)expected.getSuppressed().length);
            for (int i = 0; i < expected.getSuppressed().length; ++i) {
                TestPrestoSparkExecutionExceptionFactory.assertFailure((Failure)failure.getSuppressed()[i], expected.getSuppressed()[i]);
            }
        }
    }
}

