/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spark.execution;

import com.facebook.presto.spark.classloader_interface.MutablePartitionId;
import com.facebook.presto.spark.classloader_interface.PrestoSparkMutableRow;
import com.facebook.presto.spark.execution.PrestoSparkRowBatch;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.SliceOutput;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.IntStream;
import org.assertj.core.api.Assertions;
import org.testng.Assert;
import org.testng.annotations.Test;
import scala.Tuple2;

public class TestPrestoSparkRowBatch {
    private static final int REPLICATED_ROW_PARTITION_ID = -1;
    private static final int DEFAULT_TARGET_SIZE = 0x100000;
    private static final int DEFAULT_EXPECTED_ROWS = 10000;
    private static final int NO_TARGET_ENTRY_SIZE_REQUIREMENT = 0;
    private static final int UNLIMITED_MAX_ENTRY_ROW_COUNT = Integer.MAX_VALUE;
    private static final int UNLIMITED_MAX_ENTRY_SIZE = Integer.MAX_VALUE;

    @Test
    public void testRoundTrip() {
        TestPrestoSparkRowBatch.assertRoundTrip((List<Row>)ImmutableList.of());
        TestPrestoSparkRowBatch.assertRoundTrip((List<Row>)ImmutableList.of((Object)TestPrestoSparkRowBatch.createRow(1, "row_data_1")));
        TestPrestoSparkRowBatch.assertRoundTrip((List<Row>)ImmutableList.of((Object)TestPrestoSparkRowBatch.createRow(1, "")));
        TestPrestoSparkRowBatch.assertRoundTrip((List<Row>)ImmutableList.of((Object)TestPrestoSparkRowBatch.createRow(1, ""), (Object)TestPrestoSparkRowBatch.createRow(1, "")));
        TestPrestoSparkRowBatch.assertRoundTrip((List<Row>)ImmutableList.of((Object)TestPrestoSparkRowBatch.createRow(1, ""), (Object)TestPrestoSparkRowBatch.createRow(1, ""), (Object)TestPrestoSparkRowBatch.createRow(1, "")));
        TestPrestoSparkRowBatch.assertRoundTrip((List<Row>)ImmutableList.of((Object)TestPrestoSparkRowBatch.createRow(1, "row_data_1"), (Object)TestPrestoSparkRowBatch.createRow(1, "row_data_2")));
        TestPrestoSparkRowBatch.assertRoundTrip((List<Row>)ImmutableList.of((Object)TestPrestoSparkRowBatch.createRow(1, "row_data_1"), (Object)TestPrestoSparkRowBatch.createRow(2, "row_data_2")));
        TestPrestoSparkRowBatch.assertRoundTrip((List<Row>)ImmutableList.of((Object)TestPrestoSparkRowBatch.createRow(1, "row_data_1"), (Object)TestPrestoSparkRowBatch.createRow(2, "row_data_2")));
        TestPrestoSparkRowBatch.assertRoundTrip((List)IntStream.range(0, 4).mapToObj(i -> TestPrestoSparkRowBatch.createRow(i, "row_data_" + i)).collect(ImmutableList.toImmutableList()));
        TestPrestoSparkRowBatch.assertRoundTrip((List)IntStream.range(0, 5).mapToObj(i -> TestPrestoSparkRowBatch.createRow(i, "row_data")).collect(ImmutableList.toImmutableList()));
        TestPrestoSparkRowBatch.assertRoundTrip((List)IntStream.range(0, 20).mapToObj(i -> TestPrestoSparkRowBatch.createRow(i, "")).collect(ImmutableList.toImmutableList()));
        TestPrestoSparkRowBatch.assertRoundTrip((List)IntStream.range(0, 20).mapToObj(i -> TestPrestoSparkRowBatch.createRow(0, "")).collect(ImmutableList.toImmutableList()));
    }

    @Test
    public void testBuilderFull() {
        PrestoSparkRowBatch.PrestoSparkRowBatchBuilder builder = PrestoSparkRowBatch.builder((int)10, (int)5, (int)10, (int)0, (int)Integer.MAX_VALUE, (int)Integer.MAX_VALUE);
        Assert.assertFalse((boolean)builder.isFull());
        Assert.assertTrue((boolean)builder.isEmpty());
        TestPrestoSparkRowBatch.addRow(builder, TestPrestoSparkRowBatch.createRow(1, "12345"));
        Assert.assertTrue((boolean)builder.isFull());
        Assert.assertFalse((boolean)builder.isEmpty());
    }

    @Test
    public void testReplicatedRows() {
        TestPrestoSparkRowBatch.assertRoundTrip((List<Row>)ImmutableList.of((Object)TestPrestoSparkRowBatch.createReplicatedRow("replicated")), 1, (List<Row>)ImmutableList.of((Object)TestPrestoSparkRowBatch.createRow(0, "replicated")));
        TestPrestoSparkRowBatch.assertRoundTrip((List<Row>)ImmutableList.of((Object)TestPrestoSparkRowBatch.createReplicatedRow("replicated")), 2, (List<Row>)ImmutableList.of((Object)TestPrestoSparkRowBatch.createRow(0, "replicated"), (Object)TestPrestoSparkRowBatch.createRow(1, "replicated")));
        TestPrestoSparkRowBatch.assertRoundTrip((List<Row>)ImmutableList.of((Object)TestPrestoSparkRowBatch.createReplicatedRow("replicated")), 3, (List<Row>)ImmutableList.of((Object)TestPrestoSparkRowBatch.createRow(0, "replicated"), (Object)TestPrestoSparkRowBatch.createRow(1, "replicated"), (Object)TestPrestoSparkRowBatch.createRow(2, "replicated")));
        TestPrestoSparkRowBatch.assertRoundTrip((List<Row>)ImmutableList.of((Object)TestPrestoSparkRowBatch.createReplicatedRow("replicated")), 3, (List<Row>)ImmutableList.of((Object)TestPrestoSparkRowBatch.createRow(0, "replicated"), (Object)TestPrestoSparkRowBatch.createRow(1, "replicated"), (Object)TestPrestoSparkRowBatch.createRow(2, "replicated")));
        TestPrestoSparkRowBatch.assertRoundTrip((List<Row>)ImmutableList.of((Object)TestPrestoSparkRowBatch.createReplicatedRow("replicated"), (Object)TestPrestoSparkRowBatch.createRow(1, "non_replicated_1")), 3, (List<Row>)ImmutableList.of((Object)TestPrestoSparkRowBatch.createRow(0, "replicated"), (Object)TestPrestoSparkRowBatch.createRow(1, "replicated"), (Object)TestPrestoSparkRowBatch.createRow(2, "replicated"), (Object)TestPrestoSparkRowBatch.createRow(1, "non_replicated_1")));
        TestPrestoSparkRowBatch.assertRoundTrip((List<Row>)ImmutableList.of((Object)TestPrestoSparkRowBatch.createRow(2, "non_replicated_22"), (Object)TestPrestoSparkRowBatch.createReplicatedRow("replicated")), 3, (List<Row>)ImmutableList.of((Object)TestPrestoSparkRowBatch.createRow(0, "replicated"), (Object)TestPrestoSparkRowBatch.createRow(1, "replicated"), (Object)TestPrestoSparkRowBatch.createRow(2, "replicated"), (Object)TestPrestoSparkRowBatch.createRow(2, "non_replicated_22")));
        TestPrestoSparkRowBatch.assertRoundTrip((List<Row>)ImmutableList.of((Object)TestPrestoSparkRowBatch.createRow(1, "non_replicated_22"), (Object)TestPrestoSparkRowBatch.createReplicatedRow("replicated"), (Object)TestPrestoSparkRowBatch.createRow(0, "non_replicated_1")), 2, (List<Row>)ImmutableList.of((Object)TestPrestoSparkRowBatch.createRow(0, "replicated"), (Object)TestPrestoSparkRowBatch.createRow(1, "replicated"), (Object)TestPrestoSparkRowBatch.createRow(1, "non_replicated_22"), (Object)TestPrestoSparkRowBatch.createRow(0, "non_replicated_1")));
        TestPrestoSparkRowBatch.assertRoundTrip((List<Row>)ImmutableList.of((Object)TestPrestoSparkRowBatch.createRow(1, "non_replicated_22"), (Object)TestPrestoSparkRowBatch.createReplicatedRow("replicated1"), (Object)TestPrestoSparkRowBatch.createReplicatedRow("replicated2"), (Object)TestPrestoSparkRowBatch.createRow(0, "non_replicated_1")), 2, (List<Row>)ImmutableList.of((Object)TestPrestoSparkRowBatch.createRow(0, "replicated1"), (Object)TestPrestoSparkRowBatch.createRow(1, "replicated1"), (Object)TestPrestoSparkRowBatch.createRow(0, "replicated2"), (Object)TestPrestoSparkRowBatch.createRow(1, "replicated2"), (Object)TestPrestoSparkRowBatch.createRow(1, "non_replicated_22"), (Object)TestPrestoSparkRowBatch.createRow(0, "non_replicated_1")));
    }

    @Test
    public void testRowIndex() {
        TestPrestoSparkRowBatch.assertRowIndex(new int[0], new int[0][], new int[0]);
        TestPrestoSparkRowBatch.assertRowIndex(new int[0], new int[][]{new int[0], new int[0]}, new int[0]);
        TestPrestoSparkRowBatch.assertRowIndex(new int[]{0}, new int[][]{{0}, new int[0]}, new int[0]);
        TestPrestoSparkRowBatch.assertRowIndex(new int[]{1}, new int[][]{new int[0], {0}}, new int[0]);
        TestPrestoSparkRowBatch.assertRowIndex(new int[]{0, 1}, new int[][]{{0}, {1}}, new int[0]);
        TestPrestoSparkRowBatch.assertRowIndex(new int[]{0, 1, 1, 0, 0, 1}, new int[][]{{0, 3, 4}, {1, 2, 5}}, new int[0]);
        TestPrestoSparkRowBatch.assertRowIndex(new int[]{0, 1, 1, 0, 0, 1}, new int[][]{{0, 3, 4}, {1, 2, 5}, new int[0]}, new int[0]);
        TestPrestoSparkRowBatch.assertRowIndex(new int[]{0, 1, 1, 2, 0, 2, 0, 1, 2}, new int[][]{{0, 4, 6}, {1, 2, 7}, {3, 5, 8}}, new int[0]);
        TestPrestoSparkRowBatch.assertRowIndex(new int[]{1, 1, 1, 2, 1, 2, 1, 1, 2}, new int[][]{new int[0], {0, 1, 2, 4, 6, 7}, {3, 5, 8}}, new int[0]);
        TestPrestoSparkRowBatch.assertRowIndex(new int[]{-1}, new int[0][], new int[]{0});
        TestPrestoSparkRowBatch.assertRowIndex(new int[]{-1, -1}, new int[0][], new int[]{0, 1});
        TestPrestoSparkRowBatch.assertRowIndex(new int[]{0, 1, -1}, new int[][]{{0}, {1}}, new int[]{2});
        TestPrestoSparkRowBatch.assertRowIndex(new int[]{1, 1, 1, 2, -1, 1, 2, 1, 1, 2, -1}, new int[][]{new int[0], {0, 1, 2, 5, 7, 8}, {3, 6, 9}}, new int[]{4, 10});
    }

    @Test
    public void testMultiRowEntries() {
        Row row01 = TestPrestoSparkRowBatch.createRow(0, "p0_1");
        Row row02 = TestPrestoSparkRowBatch.createRow(0, "p0_11");
        Row row03 = TestPrestoSparkRowBatch.createRow(0, "p0_111");
        Row row11 = TestPrestoSparkRowBatch.createRow(1, "p1_1");
        Row row21 = TestPrestoSparkRowBatch.createRow(2, "p2_1");
        ImmutableList rows = ImmutableList.of((Object)row01, (Object)row02, (Object)row03, (Object)row11, (Object)row21);
        TestPrestoSparkRowBatch.assertEntries((List<Row>)rows, 3, 4, Integer.MAX_VALUE, Integer.MAX_VALUE, (List<List<Row>>)ImmutableList.of((Object)ImmutableList.of((Object)row01), (Object)ImmutableList.of((Object)row02), (Object)ImmutableList.of((Object)row03), (Object)ImmutableList.of((Object)row11), (Object)ImmutableList.of((Object)row21)));
        TestPrestoSparkRowBatch.assertEntries((List<Row>)rows, 3, 11, Integer.MAX_VALUE, Integer.MAX_VALUE, (List<List<Row>>)ImmutableList.of((Object)ImmutableList.of((Object)row01, (Object)row02, (Object)row03), (Object)ImmutableList.of((Object)row11), (Object)ImmutableList.of((Object)row21)));
        TestPrestoSparkRowBatch.assertEntries((List<Row>)rows, 3, 11, Integer.MAX_VALUE, 2, (List<List<Row>>)ImmutableList.of((Object)ImmutableList.of((Object)row01, (Object)row02), (Object)ImmutableList.of((Object)row03), (Object)ImmutableList.of((Object)row11), (Object)ImmutableList.of((Object)row21)));
        TestPrestoSparkRowBatch.assertEntries((List<Row>)rows, 3, 11, 18, Integer.MAX_VALUE, (List<List<Row>>)ImmutableList.of((Object)ImmutableList.of((Object)row01, (Object)row02), (Object)ImmutableList.of((Object)row03), (Object)ImmutableList.of((Object)row11), (Object)ImmutableList.of((Object)row21)));
        TestPrestoSparkRowBatch.assertEntries((List<Row>)rows, 4, 10, 0, Integer.MAX_VALUE, (List<List<Row>>)ImmutableList.of((Object)ImmutableList.of((Object)row01), (Object)ImmutableList.of((Object)row02), (Object)ImmutableList.of((Object)row03), (Object)ImmutableList.of((Object)row11), (Object)ImmutableList.of((Object)row21)));
        TestPrestoSparkRowBatch.assertEntries((List<Row>)rows, 3, 10, Integer.MAX_VALUE, 0, (List<List<Row>>)ImmutableList.of((Object)ImmutableList.of((Object)row01), (Object)ImmutableList.of((Object)row02), (Object)ImmutableList.of((Object)row03), (Object)ImmutableList.of((Object)row11), (Object)ImmutableList.of((Object)row21)));
    }

    private static void assertRoundTrip(List<Row> rows) {
        Assertions.assertThat(rows).allMatch(row -> row.getPartition() >= 0);
        TestPrestoSparkRowBatch.assertRoundTrip(rows, 20, rows);
    }

    private static void assertRoundTrip(List<Row> inputRows, int partitionCount, List<Row> expectedOutputRows) {
        PrestoSparkRowBatch.PrestoSparkRowBatchBuilder singleRowEntryBuilder = PrestoSparkRowBatch.builder((int)partitionCount, (int)0x100000, (int)10000, (int)0, (int)Integer.MAX_VALUE, (int)Integer.MAX_VALUE);
        TestPrestoSparkRowBatch.assertRoundTrip(singleRowEntryBuilder, inputRows, partitionCount, expectedOutputRows);
        PrestoSparkRowBatch.PrestoSparkRowBatchBuilder multiRowEntryBuilder = PrestoSparkRowBatch.builder((int)partitionCount, (int)0x100000, (int)10000, (int)1024, (int)Integer.MAX_VALUE, (int)Integer.MAX_VALUE);
        TestPrestoSparkRowBatch.assertRoundTrip(multiRowEntryBuilder, inputRows, partitionCount, expectedOutputRows);
    }

    private static void assertRoundTrip(PrestoSparkRowBatch.PrestoSparkRowBatchBuilder builder, List<Row> inputRows, int partitionCount, List<Row> expectedOutputRows) {
        Assertions.assertThat(inputRows).allMatch(row -> row.getPartition() < partitionCount);
        Assert.assertTrue((boolean)builder.isEmpty());
        for (Row row2 : inputRows) {
            TestPrestoSparkRowBatch.addRow(builder, row2);
        }
        Assert.assertFalse((boolean)builder.isFull());
        PrestoSparkRowBatch rowBatch = builder.build();
        TestPrestoSparkRowBatch.assertContains(rowBatch, expectedOutputRows);
    }

    private static void assertEntries(List<Row> rows, int partitionCount, int targetEntrySize, int maxEntrySize, int maxRowsPerEntry, List<List<Row>> expectedEntries) {
        PrestoSparkRowBatch.PrestoSparkRowBatchBuilder builder = PrestoSparkRowBatch.builder((int)partitionCount, (int)0x100000, (int)10000, (int)targetEntrySize, (int)maxEntrySize, (int)maxRowsPerEntry);
        Assert.assertTrue((boolean)builder.isEmpty());
        for (Row row : rows) {
            TestPrestoSparkRowBatch.addRow(builder, row);
        }
        Assert.assertFalse((boolean)builder.isFull());
        PrestoSparkRowBatch rowBatch = builder.build();
        List<List<Row>> actualEntries = TestPrestoSparkRowBatch.getEntries(rowBatch);
        Assert.assertEquals(actualEntries, expectedEntries);
    }

    private static void addRow(PrestoSparkRowBatch.PrestoSparkRowBatchBuilder builder, Row row) {
        SliceOutput output = builder.beginRowEntry();
        byte[] data = row.getData().getBytes(StandardCharsets.UTF_8);
        int bufferSize = data.length + 4;
        ByteBuffer buffer = ByteBuffer.allocate(bufferSize);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        buffer.putInt(data.length);
        buffer.put(data);
        output.writeBytes(buffer.array(), 0, bufferSize);
        if (row.isReplicated()) {
            builder.closeEntryForReplicatedRow();
        } else {
            builder.closeEntryForNonReplicatedRow(row.getPartition());
        }
    }

    private static void assertContains(PrestoSparkRowBatch rowBatch, List<Row> expected) {
        List<List<Row>> entries = TestPrestoSparkRowBatch.getEntries(rowBatch);
        List rows = (List)entries.stream().flatMap(Collection::stream).collect(ImmutableList.toImmutableList());
        Assertions.assertThat((List)rows).containsExactlyInAnyOrder((Object[])expected.toArray(new Row[0]));
    }

    private static List<List<Row>> getEntries(PrestoSparkRowBatch rowBatch) {
        Tuple2 next;
        ImmutableList.Builder entries = ImmutableList.builder();
        PrestoSparkRowBatch.RowTupleSupplier rowTupleSupplier = rowBatch.createRowTupleSupplier();
        while ((next = rowTupleSupplier.getNext()) != null) {
            ImmutableList.Builder entry = ImmutableList.builder();
            int partition = ((MutablePartitionId)next._1).getPartition();
            PrestoSparkMutableRow mutableRow = (PrestoSparkMutableRow)next._2;
            ByteBuffer buffer = mutableRow.getBuffer();
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            int rowCount = buffer.getShort();
            Assert.assertEquals((long)mutableRow.getPositionCount(), (long)rowCount);
            for (int i = 0; i < rowCount; ++i) {
                entry.add((Object)new Row(partition, TestPrestoSparkRowBatch.readRowData(buffer)));
            }
            entries.add((Object)entry.build());
        }
        return entries.build();
    }

    private static String readRowData(ByteBuffer buffer) {
        int size = buffer.getInt();
        String data = new String(buffer.array(), buffer.arrayOffset() + buffer.position(), size, StandardCharsets.UTF_8);
        buffer.position(buffer.position() + size);
        return data;
    }

    private static Row createRow(int partition, String data) {
        return new Row(partition, data);
    }

    private static Row createReplicatedRow(String data) {
        return new Row(-1, data);
    }

    private static void assertRowIndex(int[] partitions, int[][] expected, int[] expectedReplicated) {
        PrestoSparkRowBatch.RowIndex rowIndex = PrestoSparkRowBatch.RowIndex.create((int)partitions.length, (int)expected.length, (int[])partitions);
        int[][] actual = new int[expected.length][];
        for (int partition = 0; partition < expected.length; ++partition) {
            IntArrayList partitionRows = new IntArrayList();
            while (rowIndex.hasNextRow(partition)) {
                partitionRows.add(rowIndex.nextRow(partition));
            }
            actual[partition] = partitionRows.toIntArray();
        }
        Assertions.assertThat((Object[])actual).isEqualTo((Object)expected);
        IntArrayList replicatedRows = new IntArrayList();
        while (rowIndex.hasNextRow(-1)) {
            replicatedRows.add(rowIndex.nextRow(-1));
        }
        Assertions.assertThat((int[])replicatedRows.toIntArray()).isEqualTo((Object)expectedReplicated);
    }

    private static class Row {
        private final int partition;
        private final String data;

        private Row(int partition, String data) {
            this.partition = partition;
            this.data = Objects.requireNonNull(data, "data is null");
        }

        public int getPartition() {
            return this.partition;
        }

        public String getData() {
            return this.data;
        }

        public boolean isReplicated() {
            return this.partition == -1;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Row row = (Row)o;
            return this.partition == row.partition && Objects.equals(this.data, row.data);
        }

        public int hashCode() {
            return Objects.hash(this.partition, this.data);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("partition", this.partition).add("data", (Object)this.data).toString();
        }
    }
}

