/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spark.execution.property;

import com.facebook.airlift.configuration.testing.ConfigAssertions;
import com.facebook.presto.spark.execution.property.NativeExecutionConnectorConfig;
import com.facebook.presto.spark.execution.property.NativeExecutionNodeConfig;
import com.facebook.presto.spark.execution.property.NativeExecutionSystemConfig;
import com.facebook.presto.spark.execution.property.NativeExecutionVeloxConfig;
import com.facebook.presto.spark.execution.property.PrestoSparkWorkerProperty;
import io.airlift.units.DataSize;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestNativeExecutionSystemConfig {
    @Test
    public void testNativeExecutionVeloxConfig() {
        ConfigAssertions.assertRecordedDefaults((Object)((NativeExecutionVeloxConfig)ConfigAssertions.recordDefaults(NativeExecutionVeloxConfig.class)).setCodegenEnabled(false));
        NativeExecutionVeloxConfig expected = new NativeExecutionVeloxConfig().setCodegenEnabled(true);
        Map properties = expected.getAllProperties();
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
    }

    @Test
    public void testNativeExecutionSystemConfig() {
        ConfigAssertions.assertRecordedDefaults((Object)((NativeExecutionSystemConfig)ConfigAssertions.recordDefaults(NativeExecutionSystemConfig.class)).setEnableSerializedPageChecksum(true).setEnableVeloxExpressionLogging(false).setEnableVeloxTaskLogging(true).setHttpServerReusePort(true).setHttpServerPort(7777).setHttpExecThreads(32).setHttpsServerPort(7778).setEnableHttpsCommunication(false).setHttpsCiphers("AES128-SHA,AES128-SHA256,AES256-GCM-SHA384").setHttpsCertPath("").setHttpsKeyPath("").setNumIoThreads(30).setShutdownOnsetSec(10).setSystemMemoryGb(10).setQueryMemoryGb(new DataSize(10.0, DataSize.Unit.GIGABYTE)).setConcurrentLifespansPerTask(5).setMaxDriversPerTask(15).setPrestoVersion("dummy.presto.version").setShuffleName("local").setRegisterTestFunctions(false).setEnableHttpServerAccessLog(true));
        NativeExecutionSystemConfig expected = new NativeExecutionSystemConfig().setConcurrentLifespansPerTask(15).setEnableSerializedPageChecksum(false).setEnableVeloxExpressionLogging(true).setEnableVeloxTaskLogging(false).setHttpServerReusePort(false).setHttpServerPort(8080).setHttpExecThreads(256).setHttpsServerPort(8081).setEnableHttpsCommunication(true).setHttpsCiphers("AES128-SHA").setHttpsCertPath("/tmp/non_existent.cert").setHttpsKeyPath("/tmp/non_existent.key").setNumIoThreads(50).setPrestoVersion("presto-version").setShutdownOnsetSec(30).setSystemMemoryGb(40).setQueryMemoryGb(new DataSize(20.0, DataSize.Unit.GIGABYTE)).setMaxDriversPerTask(30).setShuffleName("custom").setRegisterTestFunctions(true).setEnableHttpServerAccessLog(false);
        Map properties = expected.getAllProperties();
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
    }

    @Test
    public void testNativeExecutionNodeConfig() {
        ConfigAssertions.assertRecordedDefaults((Object)((NativeExecutionNodeConfig)ConfigAssertions.recordDefaults(NativeExecutionNodeConfig.class)).setNodeEnvironment("spark-velox").setNodeLocation("/dummy/location").setNodeIp("0.0.0.0").setNodeId(0).setNodeMemoryGb(10));
        NativeExecutionNodeConfig expected = new NativeExecutionNodeConfig().setNodeEnvironment("next-gen-spark").setNodeId(1).setNodeLocation("/extra/dummy/location").setNodeIp("1.1.1.1").setNodeMemoryGb(40);
        Map properties = expected.getAllProperties();
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
    }

    @Test
    public void testNativeExecutionConnectorConfig() {
        ConfigAssertions.assertRecordedDefaults((Object)((NativeExecutionConnectorConfig)ConfigAssertions.recordDefaults(NativeExecutionConnectorConfig.class)).setCacheEnabled(false).setMaxCacheSize(new DataSize(0.0, DataSize.Unit.MEGABYTE)).setConnectorName("hive"));
        NativeExecutionConnectorConfig expected = new NativeExecutionConnectorConfig().setConnectorName("custom").setMaxCacheSize(new DataSize(32.0, DataSize.Unit.MEGABYTE)).setCacheEnabled(true);
        HashMap<String, String> properties = new HashMap<String, String>(expected.getAllProperties());
        properties.put("cache.max-cache-size", String.valueOf(new DataSize(Double.parseDouble((String)properties.get("cache.max-cache-size")), DataSize.Unit.MEGABYTE)));
        ConfigAssertions.assertFullMapping(properties, (Object)expected);
    }

    @Test
    public void testFilePropertiesPopulator() {
        PrestoSparkWorkerProperty workerProperty = new PrestoSparkWorkerProperty(new NativeExecutionConnectorConfig(), new NativeExecutionNodeConfig(), new NativeExecutionSystemConfig(), new NativeExecutionVeloxConfig());
        this.testPropertiesPopulate(workerProperty);
    }

    private void testPropertiesPopulate(PrestoSparkWorkerProperty workerProperty) {
        Path directory = null;
        try {
            directory = Files.createTempDirectory("presto", new FileAttribute[0]);
            Path veloxPropertiesPath = Paths.get(directory.toString(), "velox.properties");
            Path configPropertiesPath = Paths.get(directory.toString(), "config.properties");
            Path nodePropertiesPath = Paths.get(directory.toString(), "node.properties");
            Path connectorPropertiesPath = Paths.get(directory.toString(), "catalog/hive.properties");
            workerProperty.populateAllProperties(veloxPropertiesPath, configPropertiesPath, nodePropertiesPath, connectorPropertiesPath);
            this.verifyProperties(workerProperty.getSystemConfig().getAllProperties(), this.readPropertiesFromDisk(configPropertiesPath));
            this.verifyProperties(workerProperty.getNodeConfig().getAllProperties(), this.readPropertiesFromDisk(nodePropertiesPath));
            this.verifyProperties(workerProperty.getConnectorConfig().getAllProperties(), this.readPropertiesFromDisk(connectorPropertiesPath));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Assert.fail();
        }
    }

    private Properties readPropertiesFromDisk(Path path) {
        Properties properties = new Properties();
        File file = new File(path.toString());
        try {
            FileReader fileReader = new FileReader(file);
            properties.load(fileReader);
            fileReader.close();
            return properties;
        }
        catch (IOException e) {
            e.printStackTrace();
            Assert.fail();
            return null;
        }
    }

    private void verifyProperties(Map<String, String> expected, Properties actual) {
        for (Map.Entry<String, String> entry : expected.entrySet()) {
            Assert.assertEquals((Object)entry.getValue(), (Object)actual.get(entry.getKey()));
        }
        for (Map.Entry<Object, Object> entry : actual.entrySet()) {
            Assert.assertEquals((String)((String)entry.getValue()), (String)expected.get((String)entry.getKey()));
        }
    }
}

