/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spark.planner;

import com.facebook.presto.Session;
import com.facebook.presto.common.predicate.TupleDomain;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.cost.StatsAndCosts;
import com.facebook.presto.dispatcher.NoOpQueryManager;
import com.facebook.presto.execution.NodeTaskMap;
import com.facebook.presto.execution.QueryManager;
import com.facebook.presto.execution.QueryManagerConfig;
import com.facebook.presto.execution.scheduler.LegacyNetworkTopology;
import com.facebook.presto.execution.scheduler.NetworkTopology;
import com.facebook.presto.execution.scheduler.NodeScheduler;
import com.facebook.presto.execution.scheduler.NodeSchedulerConfig;
import com.facebook.presto.execution.scheduler.nodeSelection.NodeSelectionStats;
import com.facebook.presto.execution.scheduler.nodeSelection.SimpleTtlNodeSelectorConfig;
import com.facebook.presto.metadata.CatalogManager;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.metadata.InMemoryNodeManager;
import com.facebook.presto.metadata.InternalNodeManager;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.operator.StageExecutionDescriptor;
import com.facebook.presto.spark.planner.IterativePlanFragmenter;
import com.facebook.presto.spi.ConnectorId;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.TableHandle;
import com.facebook.presto.spi.WarningCollector;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.spi.plan.AggregationNode;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.spi.plan.PlanNodeIdAllocator;
import com.facebook.presto.spi.plan.ProjectNode;
import com.facebook.presto.spi.plan.TableScanNode;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.spi.security.AccessControl;
import com.facebook.presto.spi.security.AllowAllAccessControl;
import com.facebook.presto.sql.analyzer.FeaturesConfig;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.planner.NodePartitioningManager;
import com.facebook.presto.sql.planner.PartitioningHandle;
import com.facebook.presto.sql.planner.PartitioningProviderManager;
import com.facebook.presto.sql.planner.PartitioningScheme;
import com.facebook.presto.sql.planner.Plan;
import com.facebook.presto.sql.planner.PlanFragment;
import com.facebook.presto.sql.planner.PlanFragmenter;
import com.facebook.presto.sql.planner.SubPlan;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.planner.iterative.rule.test.PlanBuilder;
import com.facebook.presto.sql.planner.optimizations.AggregationNodeUtils;
import com.facebook.presto.sql.planner.plan.ExchangeNode;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.sql.planner.plan.PlanFragmentId;
import com.facebook.presto.sql.planner.sanity.PlanChecker;
import com.facebook.presto.sql.relational.Expressions;
import com.facebook.presto.testing.TestingSession;
import com.facebook.presto.tpch.TpchColumnHandle;
import com.facebook.presto.tpch.TpchTableHandle;
import com.facebook.presto.tpch.TpchTableLayoutHandle;
import com.facebook.presto.tpch.TpchTransactionHandle;
import com.facebook.presto.transaction.InMemoryTransactionManager;
import com.facebook.presto.transaction.TransactionBuilder;
import com.facebook.presto.transaction.TransactionManager;
import com.facebook.presto.ttl.nodettlfetchermanagers.NodeTtlFetcherManager;
import com.facebook.presto.ttl.nodettlfetchermanagers.ThrowingNodeTtlFetcherManager;
import com.facebook.presto.util.FinalizerService;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestIterativePlanFragmenter {
    private PlanFragmenter planFragmenter;
    private Session session;
    private MetadataManager metadata;
    private TransactionManager transactionManager;
    private FinalizerService finalizerService;
    private NodeScheduler nodeScheduler;
    private NodePartitioningManager nodePartitioningManager;

    @BeforeClass
    public void setUp() {
        this.session = TestingSession.testSessionBuilder().setCatalog("tpch").setSystemProperty("force_single_node_output", "false").build();
        CatalogManager catalogManager = new CatalogManager();
        catalogManager.registerCatalog(TestingSession.createBogusTestingCatalog((String)"tpch"));
        this.transactionManager = InMemoryTransactionManager.createTestTransactionManager((CatalogManager)catalogManager);
        this.metadata = MetadataManager.createTestMetadataManager((TransactionManager)this.transactionManager, (FeaturesConfig)new FeaturesConfig());
        this.finalizerService = new FinalizerService();
        this.finalizerService.start();
        this.nodeScheduler = new NodeScheduler((NetworkTopology)new LegacyNetworkTopology(), (InternalNodeManager)new InMemoryNodeManager(), new NodeSelectionStats(), new NodeSchedulerConfig().setIncludeCoordinator(true), new NodeTaskMap(this.finalizerService), (NodeTtlFetcherManager)new ThrowingNodeTtlFetcherManager(), (QueryManager)new NoOpQueryManager(), new SimpleTtlNodeSelectorConfig());
        PartitioningProviderManager partitioningProviderManager = new PartitioningProviderManager();
        this.nodePartitioningManager = new NodePartitioningManager(this.nodeScheduler, partitioningProviderManager, new NodeSelectionStats());
        this.planFragmenter = new PlanFragmenter((Metadata)this.metadata, this.nodePartitioningManager, new QueryManagerConfig(), new SqlParser(), new FeaturesConfig());
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() {
        this.planFragmenter = null;
        this.session = null;
        this.transactionManager = null;
        this.metadata = null;
        this.finalizerService.destroy();
        this.finalizerService = null;
        this.nodeScheduler.stop();
        this.nodeScheduler = null;
        this.nodePartitioningManager = null;
    }

    @Test
    public void testIterativePlanFragmenter() {
        TableScanNode ts1 = this.tableScan("ts1", "orderkey");
        TableScanNode ts2 = this.tableScan("ts2", "orderkey_0");
        PlanNode p1 = this.project("p1", (PlanNode)ts1, Expressions.variable((String)"orderkey_1", (Type)BigintType.BIGINT), (RowExpression)Expressions.variable((String)"orderkey", (Type)BigintType.BIGINT));
        ExchangeNode remoteExchange1 = ExchangeNode.systemPartitionedExchange((PlanNodeId)new PlanNodeId("re1"), (ExchangeNode.Scope)ExchangeNode.Scope.REMOTE_STREAMING, (PlanNode)p1, (List)ImmutableList.of((Object)new VariableReferenceExpression(Optional.empty(), "orderkey_1", (Type)BigintType.BIGINT)), Optional.empty());
        ExchangeNode remoteExchange2 = ExchangeNode.systemPartitionedExchange((PlanNodeId)new PlanNodeId("re2"), (ExchangeNode.Scope)ExchangeNode.Scope.REMOTE_STREAMING, (PlanNode)ts2, (List)ImmutableList.of((Object)new VariableReferenceExpression(Optional.empty(), "orderkey_0", (Type)BigintType.BIGINT)), Optional.empty());
        ExchangeNode localExchange = ExchangeNode.systemPartitionedExchange((PlanNodeId)new PlanNodeId("le"), (ExchangeNode.Scope)ExchangeNode.Scope.LOCAL, (PlanNode)remoteExchange2, (List)ImmutableList.of((Object)new VariableReferenceExpression(Optional.empty(), "orderkey_0", (Type)BigintType.BIGINT)), Optional.empty());
        JoinNode join = this.join("join", (PlanNode)remoteExchange1, (PlanNode)localExchange, JoinNode.DistributionType.PARTITIONED, "orderkey_1", "orderkey_0");
        ImmutableMap types = ImmutableMap.of((Object)"orderkey", (Object)BigintType.BIGINT, (Object)"orderkey_1", (Object)BigintType.BIGINT, (Object)"orderkey_0", (Object)BigintType.BIGINT);
        TypeProvider typeProvider = TypeProvider.copyOf((Map)types);
        Plan plan = new Plan((PlanNode)join, typeProvider, StatsAndCosts.empty());
        SubPlan fullFragmentedPlan = this.getFullFragmentedPlan(plan);
        this.inTransaction(session -> this.runTestIterativePlanFragmenter((PlanNode)join, plan, fullFragmentedPlan, (Session)session));
    }

    private Void runTestIterativePlanFragmenter(PlanNode node, Plan plan, SubPlan fullFragmentedPlan, Session session) {
        TestingFragmentTracker testingFragmentTracker = new TestingFragmentTracker();
        IterativePlanFragmenter iterativePlanFragmenter = new IterativePlanFragmenter(plan, testingFragmentTracker::isFragmentFinished, (Metadata)this.metadata, new PlanChecker(new FeaturesConfig()), new SqlParser(), new PlanNodeIdAllocator(), this.nodePartitioningManager, new QueryManagerConfig(), session, WarningCollector.NOOP, false);
        IterativePlanFragmenter.PlanAndFragments nextPlanAndFragments = this.getNextPlanAndFragments(iterativePlanFragmenter, node);
        Assert.assertTrue((boolean)nextPlanAndFragments.getRemainingPlan().isPresent());
        Assert.assertEquals((int)nextPlanAndFragments.getReadyFragments().size(), (int)2);
        IterativePlanFragmenter.PlanAndFragments previousPlanAndFragments = nextPlanAndFragments;
        nextPlanAndFragments = this.getNextPlanAndFragments(iterativePlanFragmenter, (PlanNode)previousPlanAndFragments.getRemainingPlan().get());
        Assert.assertTrue((boolean)nextPlanAndFragments.getReadyFragments().isEmpty());
        Assert.assertTrue((boolean)nextPlanAndFragments.getRemainingPlan().isPresent());
        Assert.assertEquals(previousPlanAndFragments.getRemainingPlan().get(), nextPlanAndFragments.getRemainingPlan().get());
        previousPlanAndFragments = nextPlanAndFragments;
        testingFragmentTracker.addFinishedFragment(new PlanFragmentId(1));
        nextPlanAndFragments = this.getNextPlanAndFragments(iterativePlanFragmenter, (PlanNode)previousPlanAndFragments.getRemainingPlan().get());
        Assert.assertEquals((Object)previousPlanAndFragments, (Object)nextPlanAndFragments);
        testingFragmentTracker.addFinishedFragment(new PlanFragmentId(2));
        previousPlanAndFragments = nextPlanAndFragments;
        nextPlanAndFragments = this.getNextPlanAndFragments(iterativePlanFragmenter, (PlanNode)previousPlanAndFragments.getRemainingPlan().get());
        Assert.assertFalse((boolean)nextPlanAndFragments.getRemainingPlan().isPresent());
        Assert.assertEquals((int)nextPlanAndFragments.getReadyFragments().size(), (int)1);
        this.assertSubPlansEquivalent((SubPlan)nextPlanAndFragments.getReadyFragments().get(0), fullFragmentedPlan);
        return null;
    }

    private void assertSubPlansEquivalent(SubPlan subPlan1, SubPlan subPlan2) {
        Assert.assertEquals((Object)CanonicalTestFragment.toCanonicalTestFragment(subPlan1.getFragment()), (Object)CanonicalTestFragment.toCanonicalTestFragment(subPlan2.getFragment()));
        Set subPlan1Children = (Set)subPlan1.getChildren().stream().map(child -> CanonicalTestFragment.toCanonicalTestFragment(child.getFragment())).collect(ImmutableSet.toImmutableSet());
        Set subPlan2Children = (Set)subPlan2.getChildren().stream().map(child -> CanonicalTestFragment.toCanonicalTestFragment(child.getFragment())).collect(ImmutableSet.toImmutableSet());
        Assert.assertEquals((Set)subPlan1Children, (Set)subPlan2Children);
    }

    private TableScanNode tableScan(String id, String ... symbols) {
        List variables = (List)Arrays.stream(symbols).map(symbol -> new VariableReferenceExpression(Optional.empty(), symbol, (Type)BigintType.BIGINT)).collect(ImmutableList.toImmutableList());
        return this.tableScan(id, variables);
    }

    private TableScanNode tableScan(String id, List<VariableReferenceExpression> variables) {
        ImmutableMap.Builder assignments = ImmutableMap.builder();
        for (VariableReferenceExpression variable : variables) {
            assignments.put((Object)variable, (Object)new TpchColumnHandle("orderkey", (Type)BigintType.BIGINT));
        }
        TpchTableHandle tableHandle = new TpchTableHandle("orders", 1.0);
        return new TableScanNode(Optional.empty(), new PlanNodeId(id), new TableHandle(new ConnectorId("tpch"), (ConnectorTableHandle)tableHandle, (ConnectorTransactionHandle)TpchTransactionHandle.INSTANCE, Optional.of(new TpchTableLayoutHandle(tableHandle, TupleDomain.all()))), variables, (Map)assignments.build(), TupleDomain.all(), TupleDomain.all());
    }

    private PlanNode project(String id, PlanNode source, VariableReferenceExpression variable, RowExpression expression) {
        return new ProjectNode(new PlanNodeId(id), source, PlanBuilder.assignment((VariableReferenceExpression)variable, (RowExpression)expression));
    }

    private AggregationNode aggregation(String id, PlanNode source) {
        AggregationNode.Aggregation aggregation = AggregationNodeUtils.count((FunctionAndTypeManager)this.metadata.getFunctionAndTypeManager());
        return new AggregationNode(Optional.empty(), new PlanNodeId(id), source, (Map)ImmutableMap.of((Object)new VariableReferenceExpression(Optional.empty(), "count", (Type)BigintType.BIGINT), (Object)aggregation), AggregationNode.singleGroupingSet((List)source.getOutputVariables()), (List)ImmutableList.of(), AggregationNode.Step.FINAL, Optional.empty(), Optional.empty());
    }

    private JoinNode join(String planNodeId, PlanNode left, PlanNode right, JoinNode.DistributionType distributionType, String ... symbols) {
        Preconditions.checkArgument((symbols.length % 2 == 0 ? 1 : 0) != 0);
        ImmutableList.Builder criteria = ImmutableList.builder();
        for (int i = 0; i < symbols.length; i += 2) {
            criteria.add((Object)new JoinNode.EquiJoinClause(new VariableReferenceExpression(Optional.empty(), symbols[i], (Type)BigintType.BIGINT), new VariableReferenceExpression(Optional.empty(), symbols[i + 1], (Type)BigintType.BIGINT)));
        }
        return new JoinNode(Optional.empty(), new PlanNodeId(planNodeId), JoinNode.Type.INNER, left, right, (List)criteria.build(), (List)ImmutableList.builder().addAll((Iterable)left.getOutputVariables()).addAll((Iterable)right.getOutputVariables()).build(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(distributionType), (Map)ImmutableMap.of());
    }

    private SubPlan getFullFragmentedPlan(Plan plan) {
        return this.inTransaction(session -> this.planFragmenter.createSubPlans(session, plan, false, new PlanNodeIdAllocator(), WarningCollector.NOOP));
    }

    private IterativePlanFragmenter.PlanAndFragments getNextPlanAndFragments(IterativePlanFragmenter iterativePlanFragmenter, PlanNode node) {
        return iterativePlanFragmenter.createReadySubPlans(node);
    }

    private <T> T inTransaction(Function<Session, T> transactionSessionConsumer) {
        return (T)TransactionBuilder.transaction((TransactionManager)this.transactionManager, (AccessControl)new AllowAllAccessControl()).singleStatement().execute(this.session, session -> {
            session.getCatalog().ifPresent(catalog -> this.metadata.getCatalogHandle(session, catalog));
            return transactionSessionConsumer.apply((Session)session);
        });
    }

    static class CanonicalTestFragment {
        private final Class<PlanNode> clazz;
        private final Set<VariableReferenceExpression> variables;
        private final PartitioningHandle partitioning;
        private final List<PlanNodeId> tableScanSchedulingOrder;
        private final List<Type> types;
        private final int numberOfRemoteSourceNodes;
        private final PartitioningScheme partitioningScheme;
        private final StageExecutionDescriptor stageExecutionDescriptor;
        private final boolean outputTableWriterFragment;
        private final StatsAndCosts statsAndCosts;

        public CanonicalTestFragment(Class<PlanNode> clazz, Set<VariableReferenceExpression> variables, PartitioningHandle partitioning, List<PlanNodeId> tableScanSchedulingOrder, List<Type> types, int numberOfRemoteSourceNodes, PartitioningScheme partitioningScheme, StageExecutionDescriptor stageExecutionDescriptor, boolean outputTableWriterFragment, StatsAndCosts statsAndCosts) {
            this.clazz = Objects.requireNonNull(clazz, "clazz is null");
            this.variables = ImmutableSet.copyOf((Collection)Objects.requireNonNull(variables, "variables is null"));
            this.partitioning = Objects.requireNonNull(partitioning, "partitioning is null");
            this.tableScanSchedulingOrder = ImmutableList.copyOf((Collection)Objects.requireNonNull(tableScanSchedulingOrder, "tableScanSchedulingOrder is null"));
            this.types = ImmutableList.copyOf((Collection)Objects.requireNonNull(types, "types is null"));
            this.numberOfRemoteSourceNodes = numberOfRemoteSourceNodes;
            this.partitioningScheme = Objects.requireNonNull(partitioningScheme, "partitioningScheme is null");
            this.stageExecutionDescriptor = Objects.requireNonNull(stageExecutionDescriptor, "stageExecutionDescriptor is null");
            this.outputTableWriterFragment = outputTableWriterFragment;
            this.statsAndCosts = Objects.requireNonNull(statsAndCosts, "statsAndCosts is null");
        }

        public static CanonicalTestFragment toCanonicalTestFragment(PlanFragment planFragment) {
            return new CanonicalTestFragment(planFragment.getRoot().getClass(), planFragment.getVariables(), planFragment.getPartitioning(), planFragment.getTableScanSchedulingOrder(), planFragment.getTypes(), planFragment.getRemoteSourceNodes().size(), planFragment.getPartitioningScheme(), planFragment.getStageExecutionDescriptor(), planFragment.isOutputTableWriterFragment(), planFragment.getStatsAndCosts());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CanonicalTestFragment that = (CanonicalTestFragment)o;
            return this.numberOfRemoteSourceNodes == that.numberOfRemoteSourceNodes && this.outputTableWriterFragment == that.outputTableWriterFragment && this.clazz.equals(that.clazz) && this.variables.equals(that.variables) && this.partitioning.equals((Object)that.partitioning) && this.tableScanSchedulingOrder.equals(that.tableScanSchedulingOrder) && this.types.equals(that.types) && this.partitioningScheme.equals((Object)that.partitioningScheme) && this.stageExecutionDescriptor.equals((Object)that.stageExecutionDescriptor) && this.statsAndCosts.equals((Object)that.statsAndCosts);
        }

        public int hashCode() {
            return Objects.hash(this.clazz, this.variables, this.partitioning, this.tableScanSchedulingOrder, this.types, this.numberOfRemoteSourceNodes, this.partitioningScheme, this.stageExecutionDescriptor, this.outputTableWriterFragment, this.statsAndCosts);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("clazz", this.clazz).add("variables", this.variables).add("partitioning", (Object)this.partitioning).add("tableScanSchedulingOrder", this.tableScanSchedulingOrder).add("types", this.types).add("numberOfRemoteSourceNodes", this.numberOfRemoteSourceNodes).add("partitioningScheme", (Object)this.partitioningScheme).add("stageExecutionDescriptor", (Object)this.stageExecutionDescriptor).add("outputTableWriterFragment", this.outputTableWriterFragment).add("statsAndCosts", (Object)this.statsAndCosts).toString();
        }
    }

    private static class TestingFragmentTracker {
        private final Set<PlanFragmentId> finishedFragments = new HashSet<PlanFragmentId>();

        private TestingFragmentTracker() {
        }

        public void addFinishedFragment(PlanFragmentId id) {
            this.finishedFragments.add(id);
        }

        public boolean isFragmentFinished(PlanFragmentId id) {
            return this.finishedFragments.contains(id);
        }
    }
}

