/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spark.planner;

import com.facebook.presto.Session;
import com.facebook.presto.metadata.AbstractMockMetadata;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.SessionPropertyManager;
import com.facebook.presto.spark.PhysicalResourceSettings;
import com.facebook.presto.spark.PrestoSparkPhysicalResourceCalculator;
import com.facebook.presto.spark.PrestoSparkSourceStatsCollector;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.Constraint;
import com.facebook.presto.spi.TableHandle;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeIdAllocator;
import com.facebook.presto.spi.plan.TableScanNode;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.spi.session.PropertyMetadata;
import com.facebook.presto.spi.statistics.Estimate;
import com.facebook.presto.spi.statistics.TableStatistics;
import com.facebook.presto.sql.planner.iterative.rule.test.PlanBuilder;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.testing.TestingMetadata;
import com.facebook.presto.testing.TestingSession;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.units.DataSize;
import java.util.List;
import java.util.Map;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestPrestoSparkPhysicalResourceAllocationStrategy {
    private static final PropertyMetadata<?>[] defaultPropertyMetadata = new PropertyMetadata[]{PropertyMetadata.integerProperty((String)"spark_min_executor_count", (String)"SPARK_MIN_EXECUTOR_COUNT", (Integer)10, (boolean)false), PropertyMetadata.integerProperty((String)"spark_max_executor_count", (String)"SPARK_MAX_EXECUTOR_COUNT", (Integer)1000, (boolean)false), PropertyMetadata.integerProperty((String)"spark_min_hash_partition_count", (String)"SPARK_MIN_HASH_PARTITION_COUNT", (Integer)10, (boolean)false), PropertyMetadata.integerProperty((String)"spark_max_hash_partition_count", (String)"SPARK_MAX_HASH_PARTITION_COUNT", (Integer)1000, (boolean)false), PropertyMetadata.dataSizeProperty((String)"spark_average_input_data_size_per_executor", (String)"SPARK_AVERAGE_INPUT_DATA_SIZE_PER_EXECUTOR", (DataSize)new DataSize(200.0, DataSize.Unit.BYTE), (boolean)false), PropertyMetadata.dataSizeProperty((String)"spark_average_input_data_size_per_partition", (String)"SPARK_AVERAGE_INPUT_DATA_SIZE_PER_PARTITION", (DataSize)new DataSize(100.0, DataSize.Unit.BYTE), (boolean)false), PropertyMetadata.integerProperty((String)"hash_partition_count", (String)"HASH_PARTITION_COUNT", (Integer)150, (boolean)false)};
    private static final Session testSessionWithAllocation = TestingSession.testSessionBuilder((SessionPropertyManager)new SessionPropertyManager((List)new ImmutableList.Builder().add((Object[])defaultPropertyMetadata).add((Object)PropertyMetadata.booleanProperty((String)"spark_resource_allocation_strategy_enabled", (String)"SPARK_RESOURCE_ALLOCATION_STRATEGY_ENABLED", (Boolean)true, (boolean)false)).build())).build();
    private static final Session testSessionWithoutAllocation = TestingSession.testSessionBuilder((SessionPropertyManager)new SessionPropertyManager((List)new ImmutableList.Builder().add((Object[])defaultPropertyMetadata).add((Object[])new PropertyMetadata[]{PropertyMetadata.booleanProperty((String)"spark_resource_allocation_strategy_enabled", (String)"SPARK_RESOURCE_ALLOCATION_STRATEGY_ENABLED", (Boolean)false, (boolean)false), PropertyMetadata.booleanProperty((String)"spark_hash_partition_count_allocation_strategy_enabled", (String)"SPARK_HASH_PARTITION_COUNT_ALLOCATION_STRATEGY_ENABLED", (Boolean)false, (boolean)false), PropertyMetadata.booleanProperty((String)"spark_executor_allocation_strategy_enabled", (String)"SPARK_EXECUTOR_ALLOCATION_STRATEGY_ENABLED", (Boolean)false, (boolean)false)}).build())).build();
    private static final Metadata mockedMetadata = new MockedMetadata();

    private PlanNode getPlanToTest(Session session, Metadata metadata) {
        PlanBuilder planBuilder = new PlanBuilder(session, new PlanNodeIdAllocator(), metadata);
        VariableReferenceExpression sourceJoin = planBuilder.variable("sourceJoin");
        TableScanNode a = planBuilder.tableScan((List)ImmutableList.of((Object)sourceJoin), (Map)ImmutableMap.of((Object)sourceJoin, (Object)new TestingMetadata.TestingColumnHandle("sourceJoin")));
        VariableReferenceExpression filteringSource = planBuilder.variable("filteringSource");
        TableScanNode b = planBuilder.tableScan((List)ImmutableList.of((Object)filteringSource), (Map)ImmutableMap.of((Object)filteringSource, (Object)new TestingMetadata.TestingColumnHandle("filteringSource")));
        return planBuilder.join(JoinNode.Type.LEFT, (PlanNode)a, (PlanNode)b, new JoinNode.EquiJoinClause[0]);
    }

    @Test
    public void testHashPartitionCountAllocationStrategy() {
        PrestoSparkSourceStatsCollector prestoSparkSourceStatsCollector = new PrestoSparkSourceStatsCollector(mockedMetadata, testSessionWithAllocation);
        PlanNode nodeToTest = this.getPlanToTest(testSessionWithAllocation, mockedMetadata);
        PhysicalResourceSettings settingsHolder = new PrestoSparkPhysicalResourceCalculator().calculate(nodeToTest, prestoSparkSourceStatsCollector, testSessionWithAllocation);
        Assert.assertEquals((int)settingsHolder.getHashPartitionCount(), (int)20);
        Assert.assertEquals((int)settingsHolder.getMaxExecutorCount().getAsInt(), (int)10);
    }

    @Test
    public void testHashPartitionCountWithoutAllocationStrategy() {
        PrestoSparkSourceStatsCollector prestoSparkSourceStatsCollector = new PrestoSparkSourceStatsCollector(mockedMetadata, testSessionWithoutAllocation);
        PlanNode nodeToTest = this.getPlanToTest(testSessionWithoutAllocation, mockedMetadata);
        PhysicalResourceSettings settingsHolder = new PrestoSparkPhysicalResourceCalculator().calculate(nodeToTest, prestoSparkSourceStatsCollector, testSessionWithoutAllocation);
        Assert.assertEquals((int)settingsHolder.getHashPartitionCount(), (int)150);
        Assert.assertFalse((boolean)settingsHolder.getMaxExecutorCount().isPresent());
    }

    private static class MockedMetadata
    extends AbstractMockMetadata {
        private MockedMetadata() {
        }

        public TableStatistics getTableStatistics(Session session, TableHandle tableHandle, List<ColumnHandle> columnHandles, Constraint<ColumnHandle> constraint) {
            return TableStatistics.builder().setRowCount(Estimate.of((double)100.0)).setTotalSize(Estimate.of((double)1000.0)).build();
        }
    }
}

