/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spark.planner.optimizers;

import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.cost.PlanNodeStatsEstimate;
import com.facebook.presto.cost.VariableStatsEstimate;
import com.facebook.presto.expressions.LogicalRowExpressions;
import com.facebook.presto.spark.PrestoSparkSessionProperties;
import com.facebook.presto.spark.PrestoSparkSessionPropertyManagerProvider;
import com.facebook.presto.spark.planner.optimizers.PickJoinSides;
import com.facebook.presto.spi.connector.ConnectorFactory;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.assertions.PlanMatchPattern;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.iterative.rule.test.PlanBuilder;
import com.facebook.presto.sql.planner.iterative.rule.test.RuleAssert;
import com.facebook.presto.sql.planner.iterative.rule.test.RuleTester;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.testing.TestngUtils;
import com.facebook.presto.tpch.TpchConnectorFactory;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestPickJoinSides {
    private static final int NODES_COUNT = 4;
    private RuleTester tester;

    @BeforeClass
    public void setUp() {
        this.tester = new RuleTester((List)ImmutableList.of(), (Map)ImmutableMap.of(), new PrestoSparkSessionPropertyManagerProvider(new SystemSessionProperties(), new PrestoSparkSessionProperties()).get(), Optional.of(4), (ConnectorFactory)new TpchConnectorFactory(1));
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() {
        this.tester.close();
        this.tester = null;
    }

    @DataProvider(name="joinTypes")
    public static Object[][] joinTypes() {
        return (Object[][])Arrays.stream(JoinNode.Type.values()).collect(TestngUtils.toDataProvider());
    }

    @Test(dataProvider="joinTypes")
    public void testFlipsWhenProbeSmaller(JoinNode.Type joinType) {
        int aSize = 100;
        int bSize = 10000;
        this.assertPickJoinSides().overrideStats("valuesA", PlanNodeStatsEstimate.builder().setTotalSize((double)aSize).build()).overrideStats("valuesB", PlanNodeStatsEstimate.builder().setTotalSize((double)bSize).build()).on(p -> p.join(joinType, (PlanNode)p.values(new PlanNodeId("valuesA"), (List)ImmutableList.of((Object)p.variable("A1")), (List)ImmutableList.of((Object)PlanBuilder.constantExpressions((Type)BigintType.BIGINT, (Object[])new Object[]{10L}), (Object)PlanBuilder.constantExpressions((Type)BigintType.BIGINT, (Object[])new Object[]{11L}))), (PlanNode)p.values(new PlanNodeId("valuesB"), (List)ImmutableList.of((Object)p.variable("B1")), (List)ImmutableList.of((Object)PlanBuilder.constantExpressions((Type)BigintType.BIGINT, (Object[])new Object[]{50L}), (Object)PlanBuilder.constantExpressions((Type)BigintType.BIGINT, (Object[])new Object[]{11L}))), (List)ImmutableList.of((Object)new JoinNode.EquiJoinClause(p.variable("A1", (Type)BigintType.BIGINT), p.variable("B1", (Type)BigintType.BIGINT))), (List)ImmutableList.of((Object)p.variable("A1", (Type)BigintType.BIGINT), (Object)p.variable("B1", (Type)BigintType.BIGINT)), Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(JoinNode.DistributionType.PARTITIONED), (Map)ImmutableMap.of())).matches(PlanMatchPattern.join((JoinNode.Type)JoinNode.flipType((JoinNode.Type)joinType), (List)ImmutableList.of((Object)PlanMatchPattern.equiJoinClause((String)"B1", (String)"A1")), Optional.empty(), Optional.of(JoinNode.DistributionType.PARTITIONED), (PlanMatchPattern)PlanMatchPattern.values((Map)ImmutableMap.of((Object)"B1", (Object)0)), (PlanMatchPattern)PlanMatchPattern.values((Map)ImmutableMap.of((Object)"A1", (Object)0))));
    }

    @Test(dataProvider="joinTypes")
    public void testDoesNotFireWhenTablesSameSize(JoinNode.Type joinType) {
        int aSize = 100;
        int bSize = 100;
        this.assertPickJoinSides().overrideStats("valuesA", PlanNodeStatsEstimate.builder().setTotalSize((double)aSize).build()).overrideStats("valuesB", PlanNodeStatsEstimate.builder().setTotalSize((double)bSize).build()).on(p -> p.join(joinType, (PlanNode)p.values((List)ImmutableList.of((Object)p.variable("A1")), (List)ImmutableList.of((Object)PlanBuilder.constantExpressions((Type)BigintType.BIGINT, (Object[])new Object[]{10L}), (Object)PlanBuilder.constantExpressions((Type)BigintType.BIGINT, (Object[])new Object[]{11L}))), (PlanNode)p.values((List)ImmutableList.of((Object)p.variable("B1")), (List)ImmutableList.of((Object)PlanBuilder.constantExpressions((Type)BigintType.BIGINT, (Object[])new Object[]{50L}), (Object)PlanBuilder.constantExpressions((Type)BigintType.BIGINT, (Object[])new Object[]{11L}))), (List)ImmutableList.of((Object)new JoinNode.EquiJoinClause(p.variable("A1", (Type)BigintType.BIGINT), p.variable("B1", (Type)BigintType.BIGINT))), (List)ImmutableList.of((Object)p.variable("A1", (Type)BigintType.BIGINT), (Object)p.variable("B1", (Type)BigintType.BIGINT)), Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(JoinNode.DistributionType.PARTITIONED), (Map)ImmutableMap.of())).doesNotFire();
    }

    @Test(dataProvider="joinTypes")
    public void testFlipWhenOneTableMuchSmallerAndJoinCardinalityUnknown(JoinNode.Type joinType) {
        int aRows = 100;
        int bRows = 10000;
        this.assertPickJoinSides().overrideStats("valuesA", PlanNodeStatsEstimate.builder().setOutputRowCount((double)aRows).addVariableStatistics((Map)ImmutableMap.of((Object)new VariableReferenceExpression(Optional.empty(), "A1", (Type)BigintType.BIGINT), (Object)VariableStatsEstimate.unknown())).build()).overrideStats("valuesB", PlanNodeStatsEstimate.builder().setOutputRowCount((double)bRows).addVariableStatistics((Map)ImmutableMap.of((Object)new VariableReferenceExpression(Optional.empty(), "B1", (Type)BigintType.BIGINT), (Object)VariableStatsEstimate.unknown())).build()).on(p -> p.join(joinType, (PlanNode)p.values(new PlanNodeId("valuesA"), aRows, new VariableReferenceExpression[]{p.variable("A1", (Type)BigintType.BIGINT)}), (PlanNode)p.values(new PlanNodeId("valuesB"), bRows, new VariableReferenceExpression[]{p.variable("B1", (Type)BigintType.BIGINT)}), (List)ImmutableList.of((Object)new JoinNode.EquiJoinClause(p.variable("A1", (Type)BigintType.BIGINT), p.variable("B1", (Type)BigintType.BIGINT))), (List)ImmutableList.of((Object)p.variable("A1", (Type)BigintType.BIGINT), (Object)p.variable("B1", (Type)BigintType.BIGINT)), Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(JoinNode.DistributionType.PARTITIONED), (Map)ImmutableMap.of())).matches(PlanMatchPattern.join((JoinNode.Type)JoinNode.flipType((JoinNode.Type)joinType), (List)ImmutableList.of((Object)PlanMatchPattern.equiJoinClause((String)"B1", (String)"A1")), Optional.empty(), Optional.of(JoinNode.DistributionType.PARTITIONED), (PlanMatchPattern)PlanMatchPattern.values((Map)ImmutableMap.of((Object)"B1", (Object)0)), (PlanMatchPattern)PlanMatchPattern.values((Map)ImmutableMap.of((Object)"A1", (Object)0))));
    }

    @Test
    public void testFlipsWhenSourceIsSmall() {
        VarcharType variableType = VarcharType.createUnboundedVarcharType();
        int aRows = 10000;
        int bRows = 10;
        PlanNodeStatsEstimate bSourceStatsEstimate = PlanNodeStatsEstimate.builder().setOutputRowCount((double)bRows).addVariableStatistics((Map)ImmutableMap.of((Object)new VariableReferenceExpression(Optional.empty(), "B1", (Type)variableType), (Object)new VariableStatsEstimate(0.0, 100.0, 0.0, 64.0, 10.0))).build();
        this.assertPickJoinSides().overrideStats("valuesA", PlanNodeStatsEstimate.unknown()).overrideStats("filterB", PlanNodeStatsEstimate.unknown()).overrideStats("valuesB", bSourceStatsEstimate).on(p -> {
            VariableReferenceExpression a1 = p.variable("A1", (Type)variableType);
            VariableReferenceExpression b1 = p.variable("B1", (Type)variableType);
            return p.join(JoinNode.Type.LEFT, (PlanNode)p.filter(new PlanNodeId("filterB"), (RowExpression)LogicalRowExpressions.TRUE_CONSTANT, (PlanNode)p.values(new PlanNodeId("valuesB"), bRows, new VariableReferenceExpression[]{b1})), (PlanNode)p.values(new PlanNodeId("valuesA"), aRows, new VariableReferenceExpression[]{a1}), (List)ImmutableList.of((Object)new JoinNode.EquiJoinClause(b1, a1)), (List)ImmutableList.of((Object)b1, (Object)a1), Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(JoinNode.DistributionType.PARTITIONED), (Map)ImmutableMap.of());
        }).matches(PlanMatchPattern.join((JoinNode.Type)JoinNode.Type.RIGHT, (List)ImmutableList.of((Object)PlanMatchPattern.equiJoinClause((String)"A1", (String)"B1")), Optional.empty(), Optional.of(JoinNode.DistributionType.PARTITIONED), (PlanMatchPattern)PlanMatchPattern.values((Map)ImmutableMap.of((Object)"A1", (Object)0)), (PlanMatchPattern)PlanMatchPattern.filter((String)"true", (PlanMatchPattern)PlanMatchPattern.values((Map)ImmutableMap.of((Object)"B1", (Object)0)))));
    }

    @Test
    public void testFlipWhenSizeDifferenceLarge() {
        VarcharType variableType = VarcharType.createUnboundedVarcharType();
        int aRows = 10000;
        int bRows = 1000;
        PlanNodeStatsEstimate aStatsEstimate = PlanNodeStatsEstimate.builder().setOutputRowCount((double)aRows).setTotalSize((double)aRows).addVariableStatistics((Map)ImmutableMap.of((Object)new VariableReferenceExpression(Optional.empty(), "A1", (Type)variableType), (Object)new VariableStatsEstimate(0.0, 100.0, 0.0, 6.4E9, 10.0))).build();
        PlanNodeStatsEstimate bStatsEstimate = PlanNodeStatsEstimate.builder().setOutputRowCount((double)bRows).setTotalSize((double)bRows).addVariableStatistics((Map)ImmutableMap.of((Object)new VariableReferenceExpression(Optional.empty(), "B1", (Type)variableType), (Object)new VariableStatsEstimate(0.0, 100.0, 0.0, 6.4E9, 10.0))).build();
        this.assertPickJoinSides().overrideStats("valuesA", aStatsEstimate).overrideStats("valuesB", bStatsEstimate).overrideStats("filterB", PlanNodeStatsEstimate.unknown()).on(p -> {
            VariableReferenceExpression a1 = p.variable("A1", (Type)variableType);
            VariableReferenceExpression b1 = p.variable("B1", (Type)variableType);
            return p.join(JoinNode.Type.INNER, (PlanNode)p.values(new PlanNodeId("valuesA"), aRows, new VariableReferenceExpression[]{a1}), (PlanNode)p.filter(new PlanNodeId("filterB"), (RowExpression)LogicalRowExpressions.TRUE_CONSTANT, (PlanNode)p.values(new PlanNodeId("valuesB"), bRows, new VariableReferenceExpression[]{b1})), (List)ImmutableList.of((Object)new JoinNode.EquiJoinClause(a1, b1)), (List)ImmutableList.of((Object)a1, (Object)b1), Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(JoinNode.DistributionType.PARTITIONED), (Map)ImmutableMap.of());
        }).doesNotFire();
        this.assertPickJoinSides().overrideStats("valuesA", aStatsEstimate).overrideStats("valuesB", bStatsEstimate).overrideStats("filterB", PlanNodeStatsEstimate.unknown()).on(p -> {
            VariableReferenceExpression a1 = p.variable("A1", (Type)variableType);
            VariableReferenceExpression b1 = p.variable("B1", (Type)variableType);
            return p.join(JoinNode.Type.INNER, (PlanNode)p.filter(new PlanNodeId("filterB"), (RowExpression)LogicalRowExpressions.TRUE_CONSTANT, (PlanNode)p.values(new PlanNodeId("valuesB"), bRows, new VariableReferenceExpression[]{b1})), (PlanNode)p.values(new PlanNodeId("valuesA"), aRows, new VariableReferenceExpression[]{a1}), (List)ImmutableList.of((Object)new JoinNode.EquiJoinClause(b1, a1)), (List)ImmutableList.of((Object)b1, (Object)a1), Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(JoinNode.DistributionType.PARTITIONED), (Map)ImmutableMap.of());
        }).matches(PlanMatchPattern.join((JoinNode.Type)JoinNode.Type.INNER, (List)ImmutableList.of((Object)PlanMatchPattern.equiJoinClause((String)"A1", (String)"B1")), Optional.empty(), Optional.of(JoinNode.DistributionType.PARTITIONED), (PlanMatchPattern)PlanMatchPattern.values((Map)ImmutableMap.of((Object)"A1", (Object)0)), (PlanMatchPattern)PlanMatchPattern.filter((String)"true", (PlanMatchPattern)PlanMatchPattern.values((Map)ImmutableMap.of((Object)"B1", (Object)0)))));
        bStatsEstimate = PlanNodeStatsEstimate.builder().setOutputRowCount((double)aRows).addVariableStatistics((Map)ImmutableMap.of((Object)new VariableReferenceExpression(Optional.empty(), "B1", (Type)variableType), (Object)new VariableStatsEstimate(0.0, 100.0, 0.0, 6.4E9, 10.0))).build();
        this.assertPickJoinSides().overrideStats("valuesA", aStatsEstimate).overrideStats("valuesB", bStatsEstimate).overrideStats("filterB", PlanNodeStatsEstimate.unknown()).on(p -> {
            VariableReferenceExpression a1 = p.variable("A1", (Type)variableType);
            VariableReferenceExpression b1 = p.variable("B1", (Type)variableType);
            return p.join(JoinNode.Type.INNER, (PlanNode)p.filter(new PlanNodeId("filterB"), (RowExpression)LogicalRowExpressions.TRUE_CONSTANT, (PlanNode)p.values(new PlanNodeId("valuesB"), aRows, new VariableReferenceExpression[]{b1})), (PlanNode)p.values(new PlanNodeId("valuesA"), aRows, new VariableReferenceExpression[]{a1}), (List)ImmutableList.of((Object)new JoinNode.EquiJoinClause(b1, a1)), (List)ImmutableList.of((Object)b1, (Object)a1), Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(JoinNode.DistributionType.PARTITIONED), (Map)ImmutableMap.of());
        }).doesNotFire();
    }

    public void testDoesNotFireWhenDisabled() {
        int aSize = 100;
        int bSize = 10000;
        this.tester.assertThat((Rule)new PickJoinSides()).setSystemProperty("adaptive_join_side_switching_enabled", "false").overrideStats("valuesA", PlanNodeStatsEstimate.builder().setTotalSize((double)aSize).build()).overrideStats("valuesB", PlanNodeStatsEstimate.builder().setTotalSize((double)bSize).build()).on(p -> p.join(JoinNode.Type.INNER, (PlanNode)p.values((List)ImmutableList.of((Object)p.variable("A1")), (List)ImmutableList.of((Object)PlanBuilder.constantExpressions((Type)BigintType.BIGINT, (Object[])new Object[]{10L}), (Object)PlanBuilder.constantExpressions((Type)BigintType.BIGINT, (Object[])new Object[]{11L}))), (PlanNode)p.values((List)ImmutableList.of((Object)p.variable("B1")), (List)ImmutableList.of((Object)PlanBuilder.constantExpressions((Type)BigintType.BIGINT, (Object[])new Object[]{50L}), (Object)PlanBuilder.constantExpressions((Type)BigintType.BIGINT, (Object[])new Object[]{11L}))), (List)ImmutableList.of((Object)new JoinNode.EquiJoinClause(p.variable("A1", (Type)BigintType.BIGINT), p.variable("B1", (Type)BigintType.BIGINT))), (List)ImmutableList.of((Object)p.variable("A1", (Type)BigintType.BIGINT), (Object)p.variable("B1", (Type)BigintType.BIGINT)), Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(JoinNode.DistributionType.PARTITIONED), (Map)ImmutableMap.of())).doesNotFire();
    }

    public void testDoesNotFireForReplicatedJoin() {
        int aSize = 100;
        int bSize = 10000;
        this.assertPickJoinSides().setSystemProperty("adaptive_join_side_switching_enabled", "false").overrideStats("valuesA", PlanNodeStatsEstimate.builder().setTotalSize((double)aSize).build()).overrideStats("valuesB", PlanNodeStatsEstimate.builder().setTotalSize((double)bSize).build()).on(p -> p.join(JoinNode.Type.INNER, (PlanNode)p.values((List)ImmutableList.of((Object)p.variable("A1")), (List)ImmutableList.of((Object)PlanBuilder.constantExpressions((Type)BigintType.BIGINT, (Object[])new Object[]{10L}), (Object)PlanBuilder.constantExpressions((Type)BigintType.BIGINT, (Object[])new Object[]{11L}))), (PlanNode)p.values((List)ImmutableList.of((Object)p.variable("B1")), (List)ImmutableList.of((Object)PlanBuilder.constantExpressions((Type)BigintType.BIGINT, (Object[])new Object[]{50L}), (Object)PlanBuilder.constantExpressions((Type)BigintType.BIGINT, (Object[])new Object[]{11L}))), (List)ImmutableList.of((Object)new JoinNode.EquiJoinClause(p.variable("A1", (Type)BigintType.BIGINT), p.variable("B1", (Type)BigintType.BIGINT))), (List)ImmutableList.of((Object)p.variable("A1", (Type)BigintType.BIGINT), (Object)p.variable("B1", (Type)BigintType.BIGINT)), Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(JoinNode.DistributionType.REPLICATED), (Map)ImmutableMap.of())).doesNotFire();
    }

    public void testDoesNotFireForRightCrossJoin() {
        int aSize = 100;
        int bSize = 10000;
        this.assertPickJoinSides().overrideStats("valuesA", PlanNodeStatsEstimate.builder().setTotalSize((double)aSize).build()).overrideStats("valuesB", PlanNodeStatsEstimate.builder().setTotalSize((double)bSize).addVariableStatistics((Map)ImmutableMap.of((Object)new VariableReferenceExpression(Optional.empty(), "B1", (Type)BigintType.BIGINT), (Object)new VariableStatsEstimate(0.0, 100.0, 0.0, 640000.0, 100.0))).build()).on(p -> p.join(JoinNode.Type.RIGHT, (PlanNode)p.values((List)ImmutableList.of((Object)p.variable("A1")), (List)ImmutableList.of((Object)PlanBuilder.constantExpressions((Type)BigintType.BIGINT, (Object[])new Object[]{10L}), (Object)PlanBuilder.constantExpressions((Type)BigintType.BIGINT, (Object[])new Object[]{11L}))), (PlanNode)p.values((List)ImmutableList.of((Object)p.variable("B1")), (List)ImmutableList.of((Object)PlanBuilder.constantExpressions((Type)BigintType.BIGINT, (Object[])new Object[]{50L}), (Object)PlanBuilder.constantExpressions((Type)BigintType.BIGINT, (Object[])new Object[]{11L}))), (List)ImmutableList.of(), (List)ImmutableList.of((Object)p.variable("A1", (Type)BigintType.BIGINT), (Object)p.variable("B1", (Type)BigintType.BIGINT)), Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(JoinNode.DistributionType.PARTITIONED), (Map)ImmutableMap.of())).doesNotFire();
    }

    private RuleAssert assertPickJoinSides() {
        return this.tester.assertThat((Rule)new PickJoinSides()).setSystemProperty("join_max_broadcast_table_size", "100MB").setSystemProperty("adaptive_join_side_switching_enabled", "true");
    }
}

