/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spark.task;

import com.facebook.airlift.concurrent.Threads;
import com.facebook.presto.Session;
import com.facebook.presto.execution.ScheduledSplit;
import com.facebook.presto.execution.TaskId;
import com.facebook.presto.execution.TaskManagerConfig;
import com.facebook.presto.execution.TaskSource;
import com.facebook.presto.execution.TaskStateMachine;
import com.facebook.presto.execution.TaskTestUtils;
import com.facebook.presto.execution.buffer.OutputBuffer;
import com.facebook.presto.execution.executor.TaskExecutor;
import com.facebook.presto.execution.scheduler.TableWriteInfo;
import com.facebook.presto.metadata.Split;
import com.facebook.presto.operator.PipelineContext;
import com.facebook.presto.operator.TaskContext;
import com.facebook.presto.spark.execution.PrestoSparkTaskExecution;
import com.facebook.presto.spi.ConnectorId;
import com.facebook.presto.spi.ConnectorSplit;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.sql.planner.LocalExecutionPlanner;
import com.facebook.presto.sql.planner.PlanFragment;
import com.facebook.presto.sql.planner.RemoteSourceFactory;
import com.facebook.presto.sql.planner.TestingOutputBuffer;
import com.facebook.presto.sql.planner.TestingRemoteSourceFactory;
import com.facebook.presto.testing.TestingSession;
import com.facebook.presto.testing.TestingSplit;
import com.facebook.presto.testing.TestingTaskContext;
import com.facebook.presto.testing.TestingTransactionHandle;
import com.google.common.base.Ticker;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.airlift.units.DataSize;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestPrestoSparkTaskExecution {
    Session nativeTestSession;
    Session nonNativeTestSession;
    LocalExecutionPlanner.LocalExecutionPlan localExecutionPlan;
    TaskExecutor taskExecutor;
    PlanFragment planFragment = TaskTestUtils.createPlanFragment();
    ExecutorService taskNotificationExecutor;
    ScheduledExecutorService scheduledExecutor;
    TaskStateMachine taskStateMachine;
    Set<ScheduledSplit> splits = ImmutableSet.of((Object)new ScheduledSplit(1L, TaskTestUtils.TABLE_SCAN_NODE_ID, new Split(new ConnectorId("test"), (ConnectorTransactionHandle)TestingTransactionHandle.create(), (ConnectorSplit)TestingSplit.createLocalSplit())), (Object)new ScheduledSplit(2L, TaskTestUtils.TABLE_SCAN_NODE_ID, new Split(new ConnectorId("test"), (ConnectorTransactionHandle)TestingTransactionHandle.create(), (ConnectorSplit)TestingSplit.createLocalSplit())), (Object)new ScheduledSplit(3L, TaskTestUtils.TABLE_SCAN_NODE_ID, new Split(new ConnectorId("test"), (ConnectorTransactionHandle)TestingTransactionHandle.create(), (ConnectorSplit)TestingSplit.createLocalSplit())));

    @BeforeMethod
    public void setUp() {
        this.taskNotificationExecutor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"test-executor-%s"));
        this.scheduledExecutor = Executors.newScheduledThreadPool(2, Threads.daemonThreadsNamed((String)"test-scheduledExecutor-%s"));
        this.taskExecutor = new TaskExecutor(8, 16, 3, 4, TaskManagerConfig.TaskPriorityTracking.TASK_FAIR, Ticker.systemTicker());
        this.nativeTestSession = TestingSession.testSessionBuilder().setSystemProperty("native_execution_enabled", "true").setCatalog("tpch").setSchema("tiny").build();
        this.nonNativeTestSession = TestingSession.testSessionBuilder().setCatalog("tpch").setSchema("tiny").build();
        this.taskStateMachine = new TaskStateMachine(new TaskId("test_query_id", 4, 4, 1, 0), (Executor)this.taskNotificationExecutor);
        this.localExecutionPlan = TaskTestUtils.createTestingPlanner().plan(TestingTaskContext.createTaskContext((Executor)this.taskNotificationExecutor, (ScheduledExecutorService)this.scheduledExecutor, (Session)this.nativeTestSession), this.planFragment, (OutputBuffer)new TestingOutputBuffer(), (RemoteSourceFactory)new TestingRemoteSourceFactory(), new TableWriteInfo(Optional.empty(), Optional.empty(), Optional.empty()), new ArrayList());
    }

    @AfterMethod
    public void tearDown() {
        this.taskStateMachine.finished();
        this.taskExecutor.stop();
        this.scheduledExecutor.shutdown();
        this.taskNotificationExecutor.shutdown();
    }

    @Test
    public void testNativeDriverInstanceCount() {
        this.testDriverCount(this.nativeTestSession, true, 1);
    }

    @Test
    public void testJavaDriverInstanceCount() {
        this.testDriverCount(this.nonNativeTestSession, false, 3);
    }

    private void testDriverCount(Session session, boolean isNative, int expectedDriverCount) {
        TaskContext taskContext = TestingTaskContext.createTaskContext((Executor)this.taskNotificationExecutor, (ScheduledExecutorService)this.scheduledExecutor, (Session)session, (DataSize)new DataSize(2.0, DataSize.Unit.GIGABYTE));
        this.taskExecutor.start();
        PrestoSparkTaskExecution taskExecution = new PrestoSparkTaskExecution(this.taskStateMachine, taskContext, this.localExecutionPlan, this.taskExecutor, TaskTestUtils.createTestSplitMonitor(), (Executor)this.taskNotificationExecutor, this.scheduledExecutor, isNative);
        taskExecution.start((List)ImmutableList.of((Object)new TaskSource(TaskTestUtils.TABLE_SCAN_NODE_ID, this.splits, true)));
        Assert.assertEquals((int)((PipelineContext)taskContext.getPipelineContexts().get(0)).getPipelineStats().getDrivers().size(), (int)expectedDriverCount);
    }
}

