/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spark;

import com.facebook.airlift.configuration.Config;
import com.facebook.airlift.configuration.ConfigDescription;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import io.airlift.units.DataSize;
import java.util.Map;
import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

public class PrestoSparkConfig {
    private static final Splitter.MapSplitter MAP_SPLITTER = Splitter.on((char)',').trimResults().omitEmptyStrings().withKeyValueSeparator('=');
    private boolean sparkPartitionCountAutoTuneEnabled = true;
    private int minSparkInputPartitionCountForAutoTune = 100;
    private int maxSparkInputPartitionCountForAutoTune = 1000;
    private int initialSparkPartitionCount = 16;
    private DataSize maxSplitsDataSizePerSparkPartition = new DataSize(2.0, DataSize.Unit.GIGABYTE);
    private DataSize shuffleOutputTargetAverageRowSize = new DataSize(1.0, DataSize.Unit.KILOBYTE);
    private boolean storageBasedBroadcastJoinEnabled;
    private DataSize storageBasedBroadcastJoinWriteBufferSize = new DataSize(24.0, DataSize.Unit.MEGABYTE);
    private String storageBasedBroadcastJoinStorage = "local";
    private DataSize sparkBroadcastJoinMaxMemoryOverride;
    private boolean smileSerializationEnabled = true;
    private int splitAssignmentBatchSize = 1000000;
    private double memoryRevokingThreshold;
    private double memoryRevokingTarget;
    private boolean retryOnOutOfMemoryBroadcastJoinEnabled;
    private boolean retryOnOutOfMemoryWithIncreasedMemorySettingsEnabled;
    private boolean retryOnOutOfMemoryWithHigherHashPartitionCount;
    private double hashPartitionCountScalingFactorOnOutOfMemory = 2.0;
    private Map<String, String> outOfMemoryRetryPrestoSessionProperties = ImmutableMap.of();
    private Map<String, String> outOfMemoryRetrySparkConfigs = ImmutableMap.of();
    private DataSize averageInputDataSizePerExecutor = new DataSize(10.0, DataSize.Unit.GIGABYTE);
    private int maxExecutorCount = 600;
    private int minExecutorCount = 200;
    private DataSize averageInputDataSizePerPartition = new DataSize(2.0, DataSize.Unit.GIGABYTE);
    private int maxHashPartitionCount = 4096;
    private int minHashPartitionCount = 1024;
    private boolean resourceAllocationStrategyEnabled;
    private boolean executorAllocationStrategyEnabled;
    private boolean hashPartitionCountAllocationStrategyEnabled;
    private boolean adaptiveQueryExecutionEnabled;
    private boolean adaptiveJoinSideSwitchingEnabled;

    public boolean isSparkPartitionCountAutoTuneEnabled() {
        return this.sparkPartitionCountAutoTuneEnabled;
    }

    @Config(value="spark.partition-count-auto-tune-enabled")
    @ConfigDescription(value="Automatic tuning of spark partition count based on max splits data size per partition")
    public PrestoSparkConfig setSparkPartitionCountAutoTuneEnabled(boolean sparkPartitionCountAutoTuneEnabled) {
        this.sparkPartitionCountAutoTuneEnabled = sparkPartitionCountAutoTuneEnabled;
        return this;
    }

    @Config(value="spark.min-spark-input-partition-count-for-auto-tune")
    @ConfigDescription(value="Minimal Spark input partition count when Spark partition auto tune is enabled")
    public PrestoSparkConfig setMinSparkInputPartitionCountForAutoTune(int minSparkInputPartitionCountForAutoTune) {
        this.minSparkInputPartitionCountForAutoTune = minSparkInputPartitionCountForAutoTune;
        return this;
    }

    public int getMinSparkInputPartitionCountForAutoTune() {
        return this.minSparkInputPartitionCountForAutoTune;
    }

    @Config(value="spark.max-spark-input-partition-count-for-auto-tune")
    @ConfigDescription(value="Max Spark input partition count when Spark partition auto tune is enabled")
    public PrestoSparkConfig setMaxSparkInputPartitionCountForAutoTune(int maxSparkInputPartitionCountForAutoTune) {
        this.maxSparkInputPartitionCountForAutoTune = maxSparkInputPartitionCountForAutoTune;
        return this;
    }

    public int getMaxSparkInputPartitionCountForAutoTune() {
        return this.maxSparkInputPartitionCountForAutoTune;
    }

    public int getInitialSparkPartitionCount() {
        return this.initialSparkPartitionCount;
    }

    @Config(value="spark.initial-partition-count")
    @ConfigDescription(value="Initial partition count for Spark RDD when reading table")
    public PrestoSparkConfig setInitialSparkPartitionCount(int initialPartitionCount) {
        this.initialSparkPartitionCount = initialPartitionCount;
        return this;
    }

    public DataSize getMaxSplitsDataSizePerSparkPartition() {
        return this.maxSplitsDataSizePerSparkPartition;
    }

    @Config(value="spark.max-splits-data-size-per-partition")
    @ConfigDescription(value="Maximal size in bytes for splits assigned to one partition")
    public PrestoSparkConfig setMaxSplitsDataSizePerSparkPartition(DataSize maxSplitsDataSizePerSparkPartition) {
        this.maxSplitsDataSizePerSparkPartition = maxSplitsDataSizePerSparkPartition;
        return this;
    }

    @NotNull
    public DataSize getShuffleOutputTargetAverageRowSize() {
        return this.shuffleOutputTargetAverageRowSize;
    }

    @Config(value="spark.shuffle-output-target-average-row-size")
    @ConfigDescription(value="Target average size for row entries produced by Presto on Spark for shuffle")
    public PrestoSparkConfig setShuffleOutputTargetAverageRowSize(DataSize shuffleOutputTargetAverageRowSize) {
        this.shuffleOutputTargetAverageRowSize = shuffleOutputTargetAverageRowSize;
        return this;
    }

    public boolean isStorageBasedBroadcastJoinEnabled() {
        return this.storageBasedBroadcastJoinEnabled;
    }

    @Config(value="spark.storage-based-broadcast-join-enabled")
    @ConfigDescription(value="Distribute broadcast hashtable to workers using storage")
    public PrestoSparkConfig setStorageBasedBroadcastJoinEnabled(boolean storageBasedBroadcastJoinEnabled) {
        this.storageBasedBroadcastJoinEnabled = storageBasedBroadcastJoinEnabled;
        return this;
    }

    public DataSize getStorageBasedBroadcastJoinWriteBufferSize() {
        return this.storageBasedBroadcastJoinWriteBufferSize;
    }

    @Config(value="spark.storage-based-broadcast-join-write-buffer-size")
    @ConfigDescription(value="Maximum size in bytes to buffer before flushing pages to disk")
    public PrestoSparkConfig setStorageBasedBroadcastJoinWriteBufferSize(DataSize storageBasedBroadcastJoinWriteBufferSize) {
        this.storageBasedBroadcastJoinWriteBufferSize = storageBasedBroadcastJoinWriteBufferSize;
        return this;
    }

    public String getStorageBasedBroadcastJoinStorage() {
        return this.storageBasedBroadcastJoinStorage;
    }

    @Config(value="spark.storage-based-broadcast-join-storage")
    @ConfigDescription(value="TempStorage to use for dumping broadcast table")
    public PrestoSparkConfig setStorageBasedBroadcastJoinStorage(String storageBasedBroadcastJoinStorage) {
        this.storageBasedBroadcastJoinStorage = storageBasedBroadcastJoinStorage;
        return this;
    }

    public DataSize getSparkBroadcastJoinMaxMemoryOverride() {
        return this.sparkBroadcastJoinMaxMemoryOverride;
    }

    @Config(value="spark.broadcast-join-max-memory-override")
    public PrestoSparkConfig setSparkBroadcastJoinMaxMemoryOverride(DataSize sparkBroadcastJoinMaxMemoryOverride) {
        this.sparkBroadcastJoinMaxMemoryOverride = sparkBroadcastJoinMaxMemoryOverride;
        return this;
    }

    public boolean isSmileSerializationEnabled() {
        return this.smileSerializationEnabled;
    }

    @Config(value="spark.smile-serialization-enabled")
    public PrestoSparkConfig setSmileSerializationEnabled(boolean smileSerializationEnabled) {
        this.smileSerializationEnabled = smileSerializationEnabled;
        return this;
    }

    public int getSplitAssignmentBatchSize() {
        return this.splitAssignmentBatchSize;
    }

    @Config(value="spark.split-assignment-batch-size")
    public PrestoSparkConfig setSplitAssignmentBatchSize(int splitAssignmentBatchSize) {
        this.splitAssignmentBatchSize = splitAssignmentBatchSize;
        return this;
    }

    @DecimalMin(value="0.0")
    @DecimalMax(value="1.0")
    public @DecimalMin(value="0.0") @DecimalMax(value="1.0") double getMemoryRevokingThreshold() {
        return this.memoryRevokingThreshold;
    }

    @Config(value="spark.memory-revoking-threshold")
    @ConfigDescription(value="Revoke memory when memory pool is filled over threshold")
    public PrestoSparkConfig setMemoryRevokingThreshold(double memoryRevokingThreshold) {
        this.memoryRevokingThreshold = memoryRevokingThreshold;
        return this;
    }

    @DecimalMin(value="0.0")
    @DecimalMax(value="1.0")
    public @DecimalMin(value="0.0") @DecimalMax(value="1.0") double getMemoryRevokingTarget() {
        return this.memoryRevokingTarget;
    }

    @Config(value="spark.memory-revoking-target")
    @ConfigDescription(value="When revoking memory, try to revoke so much that memory pool is filled below target at the end")
    public PrestoSparkConfig setMemoryRevokingTarget(double memoryRevokingTarget) {
        this.memoryRevokingTarget = memoryRevokingTarget;
        return this;
    }

    public boolean isRetryOnOutOfMemoryBroadcastJoinEnabled() {
        return this.retryOnOutOfMemoryBroadcastJoinEnabled;
    }

    @Config(value="spark.retry-on-out-of-memory-broadcast-join-enabled")
    @ConfigDescription(value="Disable broadcast join on broadcast OOM and re-submit the query again within the same spark session")
    public PrestoSparkConfig setRetryOnOutOfMemoryBroadcastJoinEnabled(boolean retryOnOutOfMemoryBroadcastJoinEnabled) {
        this.retryOnOutOfMemoryBroadcastJoinEnabled = retryOnOutOfMemoryBroadcastJoinEnabled;
        return this;
    }

    public boolean isRetryOnOutOfMemoryWithIncreasedMemorySettingsEnabled() {
        return this.retryOnOutOfMemoryWithIncreasedMemorySettingsEnabled;
    }

    @Config(value="spark.retry-on-out-of-memory-with-increased-memory-settings-enabled")
    @ConfigDescription(value="Retry OOMs with increased memory settings and re-submit the query again within the same spark session")
    public PrestoSparkConfig setRetryOnOutOfMemoryWithIncreasedMemorySettingsEnabled(boolean retryOnOutOfMemoryWithIncreasedMemorySettingsEnabled) {
        this.retryOnOutOfMemoryWithIncreasedMemorySettingsEnabled = retryOnOutOfMemoryWithIncreasedMemorySettingsEnabled;
        return this;
    }

    public Map<String, String> getOutOfMemoryRetryPrestoSessionProperties() {
        return this.outOfMemoryRetryPrestoSessionProperties;
    }

    @Config(value="spark.retry-presto-session-properties")
    @ConfigDescription(value="Presto session properties to use on OOM query retry")
    public PrestoSparkConfig setOutOfMemoryRetryPrestoSessionProperties(String outOfMemoryRetryPrestoSessionProperties) {
        this.outOfMemoryRetryPrestoSessionProperties = MAP_SPLITTER.split((CharSequence)Strings.nullToEmpty((String)outOfMemoryRetryPrestoSessionProperties));
        return this;
    }

    public Map<String, String> getOutOfMemoryRetrySparkConfigs() {
        return this.outOfMemoryRetrySparkConfigs;
    }

    @Config(value="spark.retry-spark-configs")
    @ConfigDescription(value="Spark Configs to use on OOM query retry")
    public PrestoSparkConfig setOutOfMemoryRetrySparkConfigs(String outOfMemoryRetrySparkConfigs) {
        this.outOfMemoryRetrySparkConfigs = MAP_SPLITTER.split((CharSequence)Strings.nullToEmpty((String)outOfMemoryRetrySparkConfigs));
        return this;
    }

    public DataSize getAverageInputDataSizePerExecutor() {
        return this.averageInputDataSizePerExecutor;
    }

    @Config(value="spark.average-input-datasize-per-executor")
    @ConfigDescription(value="Provides average input data size used per executor")
    public PrestoSparkConfig setAverageInputDataSizePerExecutor(DataSize averageInputDataSizePerExecutor) {
        this.averageInputDataSizePerExecutor = averageInputDataSizePerExecutor;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getMaxExecutorCount() {
        return this.maxExecutorCount;
    }

    @Config(value="spark.max-executor-count")
    @ConfigDescription(value="Provides the maximum count of the executors the query will allocate")
    public PrestoSparkConfig setMaxExecutorCount(int maxExecutorCount) {
        this.maxExecutorCount = maxExecutorCount;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getMinExecutorCount() {
        return this.minExecutorCount;
    }

    @Config(value="spark.min-executor-count")
    @ConfigDescription(value="Provides the minimum count of the executors the query will allocate")
    public PrestoSparkConfig setMinExecutorCount(int minExecutorCount) {
        this.minExecutorCount = minExecutorCount;
        return this;
    }

    public DataSize getAverageInputDataSizePerPartition() {
        return this.averageInputDataSizePerPartition;
    }

    @Config(value="spark.average-input-datasize-per-partition")
    @ConfigDescription(value="Provides average input data size per partition")
    public PrestoSparkConfig setAverageInputDataSizePerPartition(DataSize averageInputDataSizePerPartition) {
        this.averageInputDataSizePerPartition = averageInputDataSizePerPartition;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getMaxHashPartitionCount() {
        return this.maxHashPartitionCount;
    }

    @Config(value="spark.max-hash-partition-count")
    @ConfigDescription(value="Provides the maximum number of the hash partition count the query can allocate")
    public PrestoSparkConfig setMaxHashPartitionCount(int maxHashPartitionCount) {
        this.maxHashPartitionCount = maxHashPartitionCount;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getMinHashPartitionCount() {
        return this.minHashPartitionCount;
    }

    @Config(value="spark.min-hash-partition-count")
    @ConfigDescription(value="Provides the minimum number of the hash partition count the query can allocate")
    public PrestoSparkConfig setMinHashPartitionCount(int minHashPartitionCount) {
        this.minHashPartitionCount = minHashPartitionCount;
        return this;
    }

    public boolean isSparkResourceAllocationStrategyEnabled() {
        return this.resourceAllocationStrategyEnabled;
    }

    @Config(value="spark.resource-allocation-strategy-enabled")
    @ConfigDescription(value="Determines whether the resource allocation strategy for executor and partition count is enabled")
    public PrestoSparkConfig setSparkResourceAllocationStrategyEnabled(boolean resourceAllocationStrategyEnabled) {
        this.resourceAllocationStrategyEnabled = resourceAllocationStrategyEnabled;
        return this;
    }

    public boolean isRetryOnOutOfMemoryWithHigherHashPartitionCountEnabled() {
        return this.retryOnOutOfMemoryWithHigherHashPartitionCount;
    }

    @Config(value="spark.retry-on-out-of-memory-higher-hash-partition-count-enabled")
    @ConfigDescription(value="Increases hash partition count by scaling factor specified by spark.hash-partition-count-scaling-factor-on-out-of-memory if query fails due to low hash partition count")
    public PrestoSparkConfig setRetryOnOutOfMemoryWithHigherHashPartitionCountEnabled(boolean retryOnOutOfMemoryWithHigherHashPartitionCount) {
        this.retryOnOutOfMemoryWithHigherHashPartitionCount = retryOnOutOfMemoryWithHigherHashPartitionCount;
        return this;
    }

    @DecimalMin(value="1.0")
    @DecimalMax(value="10.0")
    public @DecimalMin(value="1.0") @DecimalMax(value="10.0") double getHashPartitionCountScalingFactorOnOutOfMemory() {
        return this.hashPartitionCountScalingFactorOnOutOfMemory;
    }

    @Config(value="spark.hash-partition-count-scaling-factor-on-out-of-memory")
    @ConfigDescription(value="Scaling factor for hash partition count when a query fails with out of memory error due to low hash partition count")
    public PrestoSparkConfig setHashPartitionCountScalingFactorOnOutOfMemory(double hashPartitionCountScalingFactorOnOutOfMemory) {
        this.hashPartitionCountScalingFactorOnOutOfMemory = hashPartitionCountScalingFactorOnOutOfMemory;
        return this;
    }

    public boolean isExecutorAllocationStrategyEnabled() {
        return this.executorAllocationStrategyEnabled;
    }

    @Config(value="spark.executor-allocation-strategy-enabled")
    @ConfigDescription(value="Determines whether the executor allocation strategy is enabled. This will be suppressed if used alongside spark.dynamicAllocation.maxExecutors")
    public PrestoSparkConfig setExecutorAllocationStrategyEnabled(boolean executorAllocationStrategyEnabled) {
        this.executorAllocationStrategyEnabled = executorAllocationStrategyEnabled;
        return this;
    }

    public boolean isHashPartitionCountAllocationStrategyEnabled() {
        return this.hashPartitionCountAllocationStrategyEnabled;
    }

    @Config(value="spark.hash-partition-count-allocation-strategy-enabled")
    @ConfigDescription(value="Determines whether the hash partition count strategy is enabled. This will be suppressed if used alongside hash_partition_count")
    public PrestoSparkConfig setHashPartitionCountAllocationStrategyEnabled(boolean hashPartitionCountAllocationStrategyEnabled) {
        this.hashPartitionCountAllocationStrategyEnabled = hashPartitionCountAllocationStrategyEnabled;
        return this;
    }

    public boolean isAdaptiveQueryExecutionEnabled() {
        return this.adaptiveQueryExecutionEnabled;
    }

    @Config(value="spark.adaptive-query-execution-enabled")
    @ConfigDescription(value="Enables adaptive query execution")
    public PrestoSparkConfig setAdaptiveQueryExecutionEnabled(boolean adaptiveQueryExecutionEnabled) {
        this.adaptiveQueryExecutionEnabled = adaptiveQueryExecutionEnabled;
        return this;
    }

    public boolean isAdaptiveJoinSideSwitchingEnabled() {
        return this.adaptiveJoinSideSwitchingEnabled;
    }

    @Config(value="optimizer.adaptive-join-side-switching-enabled")
    @ConfigDescription(value="Enables the adaptive optimization to choose build and probe sides of a join")
    public PrestoSparkConfig setAdaptiveJoinSideSwitchingEnabled(boolean adaptiveJoinSideSwitchingEnabled) {
        this.adaptiveJoinSideSwitchingEnabled = adaptiveJoinSideSwitchingEnabled;
        return this;
    }
}

