/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spark;

import com.facebook.presto.spark.PrestoSparkMetadataStorage;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;

public class PrestoSparkLocalMetadataStorage
implements PrestoSparkMetadataStorage {
    @Override
    public void write(String outputPath, byte[] data) {
        try {
            Path outputFile = Paths.get(outputPath, new String[0]);
            Preconditions.checkArgument((boolean)Files.notExists(outputFile, new LinkOption[0]), (String)"File already exist: %s", (Object)outputFile);
            Files.write(Paths.get(outputPath, new String[0]), data, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public byte[] read(String inputPath) {
        File file = new File(inputPath);
        Preconditions.checkArgument((file.exists() && file.isFile() ? 1 : 0) != 0, (String)"file does not exist: %s", (Object)file);
        Preconditions.checkArgument((boolean)file.canRead(), (String)"file is not readable: %s", (Object)file);
        try {
            return Files.readAllBytes(Paths.get(inputPath, new String[0]));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

