/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spark;

import com.facebook.presto.Session;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.spi.Constraint;
import com.facebook.presto.spi.TableHandle;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanVisitor;
import com.facebook.presto.spi.plan.TableScanNode;
import com.facebook.presto.spi.statistics.TableStatistics;
import com.facebook.presto.sql.planner.plan.InternalPlanVisitor;
import com.facebook.presto.sql.planner.plan.NativeExecutionNode;
import com.google.common.collect.ImmutableList;
import java.util.Iterator;
import java.util.List;

public class PrestoSparkSourceStatsCollector {
    private final Metadata metadata;
    private final Session session;

    public PrestoSparkSourceStatsCollector(Metadata metadata, Session session) {
        this.metadata = metadata;
        this.session = session;
    }

    public double collectSourceStats(PlanNode root) {
        SourceTableStatsVisitor sourceTableStatsVisitor = new SourceTableStatsVisitor();
        root.accept((PlanVisitor)sourceTableStatsVisitor, null);
        List<TableStatistics> sourceStatistics = sourceTableStatsVisitor.getTableStatistics();
        if (sourceTableStatsVisitor.isSourceMissingData()) {
            return -1.0;
        }
        Iterator<TableStatistics> tableStatisticsIterator = sourceStatistics.iterator();
        double totalSourceDataSizeInBytes = 0.0;
        while (tableStatisticsIterator.hasNext()) {
            TableStatistics tableStatistics = tableStatisticsIterator.next();
            totalSourceDataSizeInBytes += tableStatistics.getTotalSize().getValue();
        }
        return totalSourceDataSizeInBytes;
    }

    private class SourceTableStatsVisitor
    extends InternalPlanVisitor<Void, Void> {
        private final ImmutableList.Builder<TableStatistics> tableStatisticsBuilder = ImmutableList.builder();
        private boolean isSourceMissingData;

        private SourceTableStatsVisitor() {
        }

        public List<TableStatistics> getTableStatistics() {
            return this.tableStatisticsBuilder.build();
        }

        public boolean isSourceMissingData() {
            return this.isSourceMissingData;
        }

        public Void visitTableScan(TableScanNode node, Void context) {
            TableHandle tableHandle = node.getTable();
            List desiredColumns = (List)node.getAssignments().values().stream().collect(ImmutableList.toImmutableList());
            Constraint constraint = new Constraint(node.getCurrentConstraint());
            TableStatistics statistics = PrestoSparkSourceStatsCollector.this.metadata.getTableStatistics(PrestoSparkSourceStatsCollector.this.session, tableHandle, desiredColumns, constraint);
            if (null == statistics || statistics == TableStatistics.empty()) {
                this.isSourceMissingData = true;
            } else {
                this.tableStatisticsBuilder.add((Object)statistics);
            }
            return null;
        }

        public Void visitNativeExecution(NativeExecutionNode node, Void context) {
            node.getSubPlan().accept((PlanVisitor)this, (Object)context);
            return null;
        }

        public Void visitPlan(PlanNode node, Void context) {
            for (PlanNode source : node.getSources()) {
                source.accept((PlanVisitor)this, (Object)context);
            }
            return null;
        }
    }
}

