/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spark;

import com.facebook.presto.spark.PrestoSparkBroadcastDependency;
import com.facebook.presto.spark.PrestoSparkServiceWaitTimeMetrics;
import com.facebook.presto.spark.classloader_interface.MutablePartitionId;
import com.facebook.presto.spark.classloader_interface.PrestoSparkTaskOutput;
import com.facebook.presto.spark.util.PrestoSparkUtils;
import com.facebook.presto.sql.planner.PartitioningHandle;
import com.facebook.presto.sql.planner.SystemPartitioningHandle;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.apache.spark.ShuffleDependency;
import org.apache.spark.SparkException;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.rdd.RDD;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.JavaConverters;

public class RddAndMore<T extends PrestoSparkTaskOutput> {
    private final JavaPairRDD<MutablePartitionId, T> rdd;
    private final List<PrestoSparkBroadcastDependency<?>> broadcastDependencies;
    private final Optional<PartitioningHandle> partitioningHandle;
    private boolean collected;

    public RddAndMore(JavaPairRDD<MutablePartitionId, T> rdd, List<PrestoSparkBroadcastDependency<?>> broadcastDependencies) {
        this(rdd, broadcastDependencies, Optional.empty());
    }

    public RddAndMore(JavaPairRDD<MutablePartitionId, T> rdd, List<PrestoSparkBroadcastDependency<?>> broadcastDependencies, Optional<PartitioningHandle> partitioningHandle) {
        this.rdd = Objects.requireNonNull(rdd, "rdd is null");
        this.broadcastDependencies = ImmutableList.copyOf((Collection)Objects.requireNonNull(broadcastDependencies, "broadcastDependencies is null"));
        this.partitioningHandle = Objects.requireNonNull(partitioningHandle, "partitioningHandle is null");
    }

    public List<Tuple2<MutablePartitionId, T>> collectAndDestroyDependenciesWithTimeout(long timeout, TimeUnit timeUnit, Set<PrestoSparkServiceWaitTimeMetrics> waitTimeMetrics) throws SparkException, TimeoutException {
        Preconditions.checkState((!this.collected ? 1 : 0) != 0, (Object)"already collected");
        this.collected = true;
        List result = (List)PrestoSparkUtils.getActionResultWithTimeout(this.rdd.collectAsync(), timeout, timeUnit, waitTimeMetrics);
        this.broadcastDependencies.forEach(PrestoSparkBroadcastDependency::destroy);
        return result;
    }

    public JavaPairRDD<MutablePartitionId, T> getRdd() {
        return this.rdd;
    }

    public List<PrestoSparkBroadcastDependency<?>> getBroadcastDependencies() {
        return this.broadcastDependencies;
    }

    public List<ShuffleDependency> getShuffleDependencies() {
        RDD underlyingRdd = this.getRdd().rdd();
        Collection dependencies = JavaConverters.asJavaCollectionConverter((Iterable)underlyingRdd.getDependencies()).asJavaCollection();
        return dependencies.stream().filter(a -> a instanceof ShuffleDependency).map(b -> (ShuffleDependency)b).collect(Collectors.toList());
    }

    public Optional<PartitioningHandle> getPartitioningHandle() {
        return this.partitioningHandle;
    }

    public boolean isBroadcastDistribution() {
        return this.getPartitioningHandle().isPresent() && this.getPartitioningHandle().get().equals((Object)SystemPartitioningHandle.FIXED_BROADCAST_DISTRIBUTION);
    }
}

