/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spark.execution;

import com.facebook.airlift.http.client.HttpClient;
import com.facebook.airlift.json.JsonCodec;
import com.facebook.airlift.log.Logger;
import com.facebook.presto.Session;
import com.facebook.presto.client.ServerInfo;
import com.facebook.presto.execution.TaskManagerConfig;
import com.facebook.presto.spark.execution.NativeExecutionProcess;
import com.facebook.presto.spark.execution.property.WorkerProperty;
import io.airlift.units.Duration;
import java.io.IOException;
import java.net.URI;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledExecutorService;

public class DetachedNativeExecutionProcess
extends NativeExecutionProcess {
    private static final Logger log = Logger.get(DetachedNativeExecutionProcess.class);

    public DetachedNativeExecutionProcess(Session session, URI uri, HttpClient httpClient, ScheduledExecutorService errorRetryScheduledExecutor, JsonCodec<ServerInfo> serverInfoCodec, Duration maxErrorDuration, TaskManagerConfig taskManagerConfig, WorkerProperty<?, ?, ?, ?> workerProperty) throws IOException {
        super(session, uri, httpClient, errorRetryScheduledExecutor, serverInfoCodec, maxErrorDuration, taskManagerConfig, workerProperty);
    }

    @Override
    public void start() throws ExecutionException, InterruptedException {
        log.info("Please use port " + this.getPort() + " for detached native process launching.");
        this.getServerInfoWithRetry().get();
    }

    @Override
    public int getPort() {
        String configuredPort = Objects.requireNonNull(System.getProperty("NATIVE_PORT"), "NATIVE_PORT not set for interactive debugging");
        return Integer.valueOf(configuredPort);
    }
}

