/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spark.execution;

import com.facebook.airlift.log.Logger;
import com.facebook.presto.execution.TaskInfo;
import com.facebook.presto.server.RequestErrorTracker;
import com.facebook.presto.server.smile.BaseResponse;
import com.facebook.presto.spark.execution.http.PrestoSparkHttpTaskClient;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.units.Duration;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.concurrent.GuardedBy;

public class HttpNativeExecutionTaskInfoFetcher {
    private static final Logger log = Logger.get(HttpNativeExecutionTaskInfoFetcher.class);
    private static final String TASK_ERROR_MESSAGE = "TaskInfoFetcher encountered too many errors talking to native process.";
    private final PrestoSparkHttpTaskClient workerClient;
    private final ScheduledExecutorService updateScheduledExecutor;
    private final AtomicReference<TaskInfo> taskInfo = new AtomicReference();
    private final Executor executor;
    private final Duration infoFetchInterval;
    private final RequestErrorTracker errorTracker;
    private final ScheduledExecutorService errorRetryScheduledExecutor;
    private final AtomicReference<RuntimeException> lastException = new AtomicReference();
    private final Duration maxErrorDuration;
    @GuardedBy(value="this")
    private ScheduledFuture<?> scheduledFuture;

    public HttpNativeExecutionTaskInfoFetcher(ScheduledExecutorService updateScheduledExecutor, ScheduledExecutorService errorRetryScheduledExecutor, PrestoSparkHttpTaskClient workerClient, Executor executor, Duration infoFetchInterval, Duration maxErrorDuration) {
        this.workerClient = Objects.requireNonNull(workerClient, "workerClient is null");
        this.updateScheduledExecutor = Objects.requireNonNull(updateScheduledExecutor, "updateScheduledExecutor is null");
        this.executor = Objects.requireNonNull(executor, "executor is null");
        this.infoFetchInterval = Objects.requireNonNull(infoFetchInterval, "infoFetchInterval is null");
        this.errorRetryScheduledExecutor = Objects.requireNonNull(errorRetryScheduledExecutor, "errorRetryScheduledExecutor is null");
        this.maxErrorDuration = Objects.requireNonNull(maxErrorDuration, "maxErrorDuration is null");
        this.errorTracker = new RequestErrorTracker((Object)"NativeExecution", workerClient.getLocation(), (ErrorCodeSupplier)StandardErrorCode.NATIVE_EXECUTION_TASK_ERROR, TASK_ERROR_MESSAGE, maxErrorDuration, errorRetryScheduledExecutor, "getting taskInfo from native process");
    }

    public void start() {
        this.scheduledFuture = this.updateScheduledExecutor.scheduleWithFixedDelay(() -> {
            ListenableFuture<BaseResponse<TaskInfo>> taskInfoFuture = this.workerClient.getTaskInfo();
            Futures.addCallback(taskInfoFuture, (FutureCallback)new FutureCallback<BaseResponse<TaskInfo>>(){

                public void onSuccess(BaseResponse<TaskInfo> result) {
                    log.debug("TaskInfoCallback success %s", new Object[]{((TaskInfo)result.getValue()).getTaskId()});
                    HttpNativeExecutionTaskInfoFetcher.this.taskInfo.set(result.getValue());
                }

                public void onFailure(Throwable t) {
                    try {
                        HttpNativeExecutionTaskInfoFetcher.this.errorTracker.requestFailed(t);
                    }
                    catch (PrestoException e) {
                        HttpNativeExecutionTaskInfoFetcher.this.stop();
                        HttpNativeExecutionTaskInfoFetcher.this.lastException.set(e);
                        return;
                    }
                    ListenableFuture errorRateLimit = HttpNativeExecutionTaskInfoFetcher.this.errorTracker.acquireRequestPermit();
                    try {
                        errorRateLimit.get(HttpNativeExecutionTaskInfoFetcher.this.maxErrorDuration.toMillis(), TimeUnit.MILLISECONDS);
                    }
                    catch (InterruptedException | ExecutionException | TimeoutException e) {
                        log.debug(e.getMessage());
                    }
                }
            }, (Executor)this.executor);
        }, 0L, (long)this.infoFetchInterval.getValue(), this.infoFetchInterval.getUnit());
    }

    public void stop() {
        if (this.scheduledFuture != null) {
            this.scheduledFuture.cancel(false);
        }
    }

    public Optional<TaskInfo> getTaskInfo() throws RuntimeException {
        if (this.scheduledFuture != null && this.scheduledFuture.isCancelled()) {
            throw this.lastException.get();
        }
        TaskInfo info = this.taskInfo.get();
        return info == null ? Optional.empty() : Optional.of(info);
    }
}

