/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spark.execution;

import com.facebook.airlift.concurrent.BoundedExecutor;
import com.facebook.airlift.http.client.HttpClient;
import com.facebook.airlift.json.JsonCodec;
import com.facebook.presto.Session;
import com.facebook.presto.execution.QueryManagerConfig;
import com.facebook.presto.execution.TaskId;
import com.facebook.presto.execution.TaskInfo;
import com.facebook.presto.execution.TaskManagerConfig;
import com.facebook.presto.execution.TaskSource;
import com.facebook.presto.execution.scheduler.TableWriteInfo;
import com.facebook.presto.spark.execution.BatchTaskUpdateRequest;
import com.facebook.presto.spark.execution.ForNativeExecutionTask;
import com.facebook.presto.spark.execution.NativeExecutionTask;
import com.facebook.presto.sql.planner.PlanFragment;
import java.net.URI;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import javax.annotation.PreDestroy;
import javax.inject.Inject;

public class NativeExecutionTaskFactory {
    private static final int MAX_THREADS = 1000;
    private final HttpClient httpClient;
    private final ExecutorService coreExecutor;
    private final Executor executor;
    private final ScheduledExecutorService updateScheduledExecutor;
    private final ScheduledExecutorService errorRetryScheduledExecutor;
    private final JsonCodec<TaskInfo> taskInfoCodec;
    private final JsonCodec<PlanFragment> planFragmentCodec;
    private final JsonCodec<BatchTaskUpdateRequest> taskUpdateRequestCodec;
    private final TaskManagerConfig taskManagerConfig;
    private final QueryManagerConfig queryManagerConfig;

    @Inject
    public NativeExecutionTaskFactory(@ForNativeExecutionTask HttpClient httpClient, ExecutorService coreExecutor, ScheduledExecutorService updateScheduledExecutor, ScheduledExecutorService errorRetryScheduledExecutor, JsonCodec<TaskInfo> taskInfoCodec, JsonCodec<PlanFragment> planFragmentCodec, JsonCodec<BatchTaskUpdateRequest> taskUpdateRequestCodec, TaskManagerConfig taskManagerConfig, QueryManagerConfig queryManagerConfig) {
        this.httpClient = Objects.requireNonNull(httpClient, "httpClient is null");
        this.coreExecutor = Objects.requireNonNull(coreExecutor, "coreExecutor is null");
        this.executor = new BoundedExecutor((Executor)coreExecutor, 1000);
        this.updateScheduledExecutor = Objects.requireNonNull(updateScheduledExecutor, "updateScheduledExecutor is null");
        this.errorRetryScheduledExecutor = Objects.requireNonNull(errorRetryScheduledExecutor, "errorRetryScheduledExecutor is null");
        this.taskInfoCodec = Objects.requireNonNull(taskInfoCodec, "taskInfoCodec is null");
        this.planFragmentCodec = Objects.requireNonNull(planFragmentCodec, "planFragmentCodec is null");
        this.taskUpdateRequestCodec = Objects.requireNonNull(taskUpdateRequestCodec, "taskUpdateRequestCodec is null");
        this.taskManagerConfig = Objects.requireNonNull(taskManagerConfig, "taskManagerConfig is null");
        this.queryManagerConfig = Objects.requireNonNull(queryManagerConfig, "queryManagerConfig is null");
    }

    public NativeExecutionTask createNativeExecutionTask(Session session, URI location, TaskId taskId, PlanFragment fragment, List<TaskSource> sources, TableWriteInfo tableWriteInfo, Optional<String> shuffleWriteInfo) {
        return new NativeExecutionTask(session, location, taskId, fragment, sources, this.httpClient, tableWriteInfo, shuffleWriteInfo, this.executor, this.updateScheduledExecutor, this.errorRetryScheduledExecutor, this.taskInfoCodec, this.planFragmentCodec, this.taskUpdateRequestCodec, this.taskManagerConfig, this.queryManagerConfig);
    }

    @PreDestroy
    public void stop() {
        this.coreExecutor.shutdownNow();
        this.updateScheduledExecutor.shutdownNow();
    }
}

