/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spark.execution;

import com.facebook.presto.common.Page;
import com.facebook.presto.execution.StageId;
import com.facebook.presto.spi.plan.PlanNodeId;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class PrestoSparkBroadcastTableCacheManager {
    private final Map<BroadcastTableCacheKey, List<List<Page>>> cache = new HashMap<BroadcastTableCacheKey, List<List<Page>>>();
    private final Map<BroadcastTableCacheKey, Long> broadcastTableToSizeMap = new HashMap<BroadcastTableCacheKey, Long>();

    public synchronized void removeCachedTablesForStagesOtherThan(StageId stageId) {
        Iterator<Map.Entry<BroadcastTableCacheKey, List<List<Page>>>> iterator = this.cache.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<BroadcastTableCacheKey, List<List<Page>>> entry = iterator.next();
            if (entry.getKey().getStageId().equals((Object)stageId)) continue;
            iterator.remove();
            this.broadcastTableToSizeMap.remove(entry.getKey());
        }
    }

    public synchronized List<List<Page>> getCachedBroadcastTable(StageId stageId, PlanNodeId planNodeId) {
        return this.cache.get(new BroadcastTableCacheKey(stageId, planNodeId));
    }

    public synchronized void cache(StageId stageId, PlanNodeId planNodeId, List<List<Page>> broadcastTable) {
        BroadcastTableCacheKey broadcastTableCacheKey = new BroadcastTableCacheKey(stageId, planNodeId);
        this.cache.put(broadcastTableCacheKey, broadcastTable);
        long broadcastTableSize = broadcastTable.stream().mapToLong(pageList -> pageList.stream().mapToLong(Page::getRetainedSizeInBytes).sum()).sum();
        this.broadcastTableToSizeMap.put(broadcastTableCacheKey, broadcastTableSize);
    }

    public synchronized long getBroadcastTableSizeInBytes(StageId stageId, PlanNodeId planNodeId) {
        return this.broadcastTableToSizeMap.getOrDefault(new BroadcastTableCacheKey(stageId, planNodeId), 0L);
    }

    private static class BroadcastTableCacheKey {
        private final StageId stageId;
        private final PlanNodeId planNodeId;

        public BroadcastTableCacheKey(StageId stageId, PlanNodeId planNodeId) {
            this.stageId = Objects.requireNonNull(stageId, "stageId is null");
            this.planNodeId = Objects.requireNonNull(planNodeId, "planNodeId is null");
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BroadcastTableCacheKey that = (BroadcastTableCacheKey)o;
            return Objects.equals(this.stageId, that.stageId) && Objects.equals(this.planNodeId, that.planNodeId);
        }

        public int hashCode() {
            return Objects.hash(this.stageId, this.planNodeId);
        }

        public StageId getStageId() {
            return this.stageId;
        }
    }
}

