/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spark.execution;

import com.facebook.presto.spark.execution.PrestoSparkBufferedResult;
import com.facebook.presto.spi.page.SerializedPage;
import java.util.Objects;
import org.openjdk.jol.info.ClassLayout;

public class PrestoSparkBufferedSerializedPage
implements PrestoSparkBufferedResult {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(PrestoSparkBufferedSerializedPage.class).instanceSize();
    private final SerializedPage serializedPage;
    private final long deserializedRetainedSizeInBytes;

    public PrestoSparkBufferedSerializedPage(SerializedPage serializedPage, long deserializedRetainedSizeInBytes) {
        this.serializedPage = Objects.requireNonNull(serializedPage, "serializedPage is null");
        this.deserializedRetainedSizeInBytes = deserializedRetainedSizeInBytes;
    }

    public SerializedPage getSerializedPage() {
        return this.serializedPage;
    }

    public long getDeserializedRetainedSizeInBytes() {
        return this.deserializedRetainedSizeInBytes;
    }

    @Override
    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + this.serializedPage.getRetainedSizeInBytes();
    }

    @Override
    public int getPositionCount() {
        return this.serializedPage.getPositionCount();
    }
}

