/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spark.execution;

import com.facebook.presto.execution.buffer.OutputBufferMemoryManager;
import com.facebook.presto.spark.execution.PrestoSparkBufferedResult;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayDeque;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.concurrent.GuardedBy;

public class PrestoSparkOutputBuffer<T extends PrestoSparkBufferedResult> {
    private final OutputBufferMemoryManager memoryManager;
    private final Object monitor = new Object();
    @GuardedBy(value="monitor")
    private final Queue<T> buffer = new ArrayDeque<T>();
    @GuardedBy(value="monitor")
    private boolean finished;
    private final AtomicLong totalRowsProcessed = new AtomicLong();
    private final AtomicLong totalPagesProcessed = new AtomicLong();

    public PrestoSparkOutputBuffer(OutputBufferMemoryManager memoryManager) {
        this.memoryManager = Objects.requireNonNull(memoryManager, "memoryManager is null");
    }

    public ListenableFuture<?> isFull() {
        return this.memoryManager.getBufferBlockedFuture();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueue(T rows) {
        Objects.requireNonNull(rows, "rows is null");
        Object object = this.monitor;
        synchronized (object) {
            this.buffer.add(rows);
            this.memoryManager.updateMemoryUsage(rows.getRetainedSizeInBytes());
            this.monitor.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNoMoreRows() {
        this.memoryManager.setNoBlockOnFull();
        Object object = this.monitor;
        synchronized (object) {
            this.finished = true;
            this.monitor.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get() throws InterruptedException {
        PrestoSparkBufferedResult rowBatch = null;
        Object object = this.monitor;
        synchronized (object) {
            while (this.buffer.isEmpty() && !this.finished) {
                this.monitor.wait();
            }
            if (!this.buffer.isEmpty()) {
                rowBatch = (PrestoSparkBufferedResult)this.buffer.poll();
            }
            if (rowBatch != null) {
                this.memoryManager.updateMemoryUsage(-rowBatch.getRetainedSizeInBytes());
            }
        }
        if (rowBatch != null) {
            this.totalPagesProcessed.incrementAndGet();
            this.totalRowsProcessed.addAndGet(rowBatch.getPositionCount());
        }
        return (T)rowBatch;
    }

    public long getTotalRowsProcessed() {
        return this.totalRowsProcessed.get();
    }

    public long getTotalPagesProcessed() {
        return this.totalPagesProcessed.get();
    }
}

