/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spark.execution;

import com.facebook.presto.Session;
import com.facebook.presto.common.block.BlockEncodingManager;
import com.facebook.presto.common.block.SortOrder;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.execution.StageId;
import com.facebook.presto.operator.SourceOperatorFactory;
import com.facebook.presto.spark.PrestoSparkSessionProperties;
import com.facebook.presto.spark.classloader_interface.PrestoSparkSerializedPage;
import com.facebook.presto.spark.classloader_interface.PrestoSparkShuffleStats;
import com.facebook.presto.spark.classloader_interface.PrestoSparkStorageHandle;
import com.facebook.presto.spark.execution.PrestoSparkBroadcastTableCacheManager;
import com.facebook.presto.spark.execution.PrestoSparkDiskPageInput;
import com.facebook.presto.spark.execution.PrestoSparkRemoteSourceOperator;
import com.facebook.presto.spark.execution.PrestoSparkSerializedPageInput;
import com.facebook.presto.spark.execution.PrestoSparkShuffleInput;
import com.facebook.presto.spark.execution.PrestoSparkShufflePageInput;
import com.facebook.presto.spark.util.PrestoSparkUtils;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.spi.storage.TempDataOperationContext;
import com.facebook.presto.spi.storage.TempStorage;
import com.facebook.presto.sql.planner.RemoteSourceFactory;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.spark.util.CollectionAccumulator;

public class PrestoSparkRemoteSourceFactory
implements RemoteSourceFactory {
    private final BlockEncodingManager blockEncodingManager;
    private final Map<PlanNodeId, List<PrestoSparkShuffleInput>> shuffleInputsMap;
    private final Map<PlanNodeId, List<Iterator<PrestoSparkSerializedPage>>> pageInputsMap;
    private final Map<PlanNodeId, List<?>> broadcastInputsMap;
    private final int taskId;
    private final CollectionAccumulator<PrestoSparkShuffleStats> shuffleStatsCollector;
    private final TempStorage tempStorage;
    private final TempDataOperationContext tempDataOperationContext;
    private final PrestoSparkBroadcastTableCacheManager prestoSparkBroadcastTableCacheManager;
    private final StageId stageId;

    public PrestoSparkRemoteSourceFactory(BlockEncodingManager blockEncodingManager, Map<PlanNodeId, List<PrestoSparkShuffleInput>> shuffleInputsMap, Map<PlanNodeId, List<Iterator<PrestoSparkSerializedPage>>> pageInputsMap, Map<PlanNodeId, List<?>> broadcastInputsMap, int taskId, CollectionAccumulator<PrestoSparkShuffleStats> shuffleStatsCollector, TempStorage tempStorage, TempDataOperationContext tempDataOperationContext, PrestoSparkBroadcastTableCacheManager prestoSparkBroadcastTableCacheManager, StageId stageId) {
        this.blockEncodingManager = Objects.requireNonNull(blockEncodingManager, "blockEncodingManager is null");
        this.shuffleInputsMap = ImmutableMap.copyOf(Objects.requireNonNull(shuffleInputsMap, "shuffleInputsMap is null"));
        this.pageInputsMap = ImmutableMap.copyOf(Objects.requireNonNull(pageInputsMap, "pageInputs is null"));
        this.broadcastInputsMap = ImmutableMap.copyOf(Objects.requireNonNull(broadcastInputsMap, "broadcastInputsMap is null"));
        this.taskId = taskId;
        this.shuffleStatsCollector = Objects.requireNonNull(shuffleStatsCollector, "shuffleStatsCollector is null");
        this.tempDataOperationContext = Objects.requireNonNull(tempDataOperationContext, "tempDataOperationContext is null");
        this.tempStorage = Objects.requireNonNull(tempStorage, "tempStorage is null");
        this.prestoSparkBroadcastTableCacheManager = Objects.requireNonNull(prestoSparkBroadcastTableCacheManager, "prestoSparkBroadcastTableCacheManager is null");
        this.stageId = Objects.requireNonNull(stageId, "stageId is null");
    }

    public SourceOperatorFactory createRemoteSource(Session session, int operatorId, PlanNodeId planNodeId, List<Type> types) {
        List<PrestoSparkShuffleInput> shuffleInputs = this.shuffleInputsMap.get(planNodeId);
        List<Iterator<PrestoSparkSerializedPage>> pageInputs = this.pageInputsMap.get(planNodeId);
        List<?> broadcastInputs = this.broadcastInputsMap.get(planNodeId);
        Preconditions.checkArgument((shuffleInputs != null || pageInputs != null || broadcastInputs != null ? 1 : 0) != 0, (String)"input not found for plan node with id %s", (Object)planNodeId);
        Preconditions.checkArgument((shuffleInputs == null || pageInputs == null ? 1 : 0) != 0, (Object)"single remote source cannot accept both, shuffle and page inputs");
        if (broadcastInputs != null) {
            if (PrestoSparkSessionProperties.isStorageBasedBroadcastJoinEnabled(session)) {
                List diskPageInputs = (List)broadcastInputs.stream().map(input -> (ImmutableList)((List)input).stream().map(PrestoSparkStorageHandle.class::cast).collect(ImmutableList.toImmutableList())).collect(ImmutableList.toImmutableList());
                return new PrestoSparkRemoteSourceOperator.SparkRemoteSourceOperatorFactory(operatorId, planNodeId, new PrestoSparkDiskPageInput(PrestoSparkUtils.createPagesSerde(this.blockEncodingManager), this.tempStorage, this.tempDataOperationContext, this.prestoSparkBroadcastTableCacheManager, this.stageId, planNodeId, diskPageInputs));
            }
            List serializedPageInputs = (List)broadcastInputs.stream().map(input -> ((List)input).stream().map(PrestoSparkSerializedPage.class::cast).iterator()).collect(ImmutableList.toImmutableList());
            return new PrestoSparkRemoteSourceOperator.SparkRemoteSourceOperatorFactory(operatorId, planNodeId, new PrestoSparkSerializedPageInput(PrestoSparkUtils.createPagesSerde(this.blockEncodingManager), serializedPageInputs));
        }
        if (pageInputs != null) {
            return new PrestoSparkRemoteSourceOperator.SparkRemoteSourceOperatorFactory(operatorId, planNodeId, new PrestoSparkSerializedPageInput(PrestoSparkUtils.createPagesSerde(this.blockEncodingManager), pageInputs));
        }
        return new PrestoSparkRemoteSourceOperator.SparkRemoteSourceOperatorFactory(operatorId, planNodeId, new PrestoSparkShufflePageInput(types, shuffleInputs, this.taskId, this.shuffleStatsCollector));
    }

    public SourceOperatorFactory createMergeRemoteSource(Session session, int operatorId, PlanNodeId planNodeId, List<Type> types, List<Integer> outputChannels, List<Integer> sortChannels, List<SortOrder> sortOrder) {
        throw new UnsupportedOperationException();
    }
}

