/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spark.execution;

import com.facebook.presto.common.Page;
import com.facebook.presto.execution.ScheduledSplit;
import com.facebook.presto.memory.context.LocalMemoryContext;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.SourceOperator;
import com.facebook.presto.operator.SourceOperatorFactory;
import com.facebook.presto.spark.execution.PrestoSparkDiskPageInput;
import com.facebook.presto.spark.execution.PrestoSparkPageInput;
import com.facebook.presto.spi.UpdatablePageSource;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;

public class PrestoSparkRemoteSourceOperator
implements SourceOperator {
    private final PlanNodeId sourceId;
    private final OperatorContext operatorContext;
    private final LocalMemoryContext systemMemoryContext;
    private final PrestoSparkPageInput pageInput;
    private final boolean isFirstOperator;
    private boolean finished;

    public PrestoSparkRemoteSourceOperator(PlanNodeId sourceId, OperatorContext operatorContext, PrestoSparkPageInput pageInput, boolean isFirstOperator) {
        this.sourceId = Objects.requireNonNull(sourceId, "sourceId is null");
        this.operatorContext = Objects.requireNonNull(operatorContext, "operatorContext is null");
        this.systemMemoryContext = operatorContext.localSystemMemoryContext();
        this.pageInput = Objects.requireNonNull(pageInput, "pageInput is null");
        this.isFirstOperator = isFirstOperator;
    }

    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    public boolean needsInput() {
        return false;
    }

    public void addInput(Page page) {
        throw new UnsupportedOperationException();
    }

    public Page getOutput() {
        if (this.finished) {
            return null;
        }
        Page page = this.pageInput.getNextPage(() -> {
            this.updateMemoryContext();
            return true;
        });
        this.updateMemoryContext();
        if (page == null) {
            this.finished = true;
            return null;
        }
        return page;
    }

    public void finish() {
        this.finished = true;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public PlanNodeId getSourceId() {
        return this.sourceId;
    }

    public Supplier<Optional<UpdatablePageSource>> addSplit(ScheduledSplit scheduledSplit) {
        throw new UnsupportedOperationException();
    }

    public void noMoreSplits() {
        throw new UnsupportedOperationException();
    }

    public void close() {
        this.systemMemoryContext.setBytes(0L);
    }

    private void updateMemoryContext() {
        if (this.pageInput instanceof PrestoSparkDiskPageInput) {
            long memorySize = 0L;
            PrestoSparkDiskPageInput diskPageInput = (PrestoSparkDiskPageInput)this.pageInput;
            memorySize += diskPageInput.getStagingBroadcastTableSizeInBytes();
            if (this.isFirstOperator) {
                memorySize += diskPageInput.getRetainedSizeInBytes();
            }
            this.systemMemoryContext.setBytes(memorySize);
        }
    }

    public static class SparkRemoteSourceOperatorFactory
    implements SourceOperatorFactory {
        private final int operatorId;
        private final PlanNodeId planNodeId;
        private final PrestoSparkPageInput pageInput;
        private boolean isFirstOperator = true;
        private boolean closed;

        public SparkRemoteSourceOperatorFactory(int operatorId, PlanNodeId planNodeId, PrestoSparkPageInput pageInput) {
            this.operatorId = operatorId;
            this.planNodeId = Objects.requireNonNull(planNodeId, "planNodeId is null");
            this.pageInput = Objects.requireNonNull(pageInput, "pageInput is null");
        }

        public PlanNodeId getSourceId() {
            return this.planNodeId;
        }

        public SourceOperator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"operator factory is closed");
            OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, this.planNodeId, PrestoSparkRemoteSourceOperator.class.getSimpleName());
            PrestoSparkRemoteSourceOperator operator = new PrestoSparkRemoteSourceOperator(this.planNodeId, operatorContext, this.pageInput, this.isFirstOperator);
            this.isFirstOperator = false;
            return operator;
        }

        public void noMoreOperators() {
            this.closed = true;
        }
    }
}

