/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spark.execution.http;

import com.facebook.airlift.http.client.BodyGenerator;
import com.facebook.airlift.http.client.HttpClient;
import com.facebook.airlift.http.client.HttpStatus;
import com.facebook.airlift.http.client.HttpUriBuilder;
import com.facebook.airlift.http.client.Request;
import com.facebook.airlift.http.client.Response;
import com.facebook.airlift.http.client.ResponseHandler;
import com.facebook.airlift.http.client.ResponseHandlerUtils;
import com.facebook.airlift.http.client.StaticBodyGenerator;
import com.facebook.airlift.http.client.StatusResponseHandler;
import com.facebook.airlift.json.JsonCodec;
import com.facebook.airlift.log.Logger;
import com.facebook.presto.Session;
import com.facebook.presto.execution.TaskId;
import com.facebook.presto.execution.TaskInfo;
import com.facebook.presto.execution.TaskSource;
import com.facebook.presto.execution.buffer.OutputBuffers;
import com.facebook.presto.execution.scheduler.TableWriteInfo;
import com.facebook.presto.operator.HttpRpcShuffleClient;
import com.facebook.presto.operator.PageBufferClient;
import com.facebook.presto.operator.RpcShuffleClient;
import com.facebook.presto.server.RequestHelpers;
import com.facebook.presto.server.TaskUpdateRequest;
import com.facebook.presto.server.smile.AdaptingJsonResponseHandler;
import com.facebook.presto.server.smile.BaseResponse;
import com.facebook.presto.spark.execution.BatchTaskUpdateRequest;
import com.facebook.presto.sql.planner.PlanFragment;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.net.URI;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class PrestoSparkHttpTaskClient
implements RpcShuffleClient {
    private static final Logger log = Logger.get(PrestoSparkHttpTaskClient.class);
    private static final String TASK_URI = "/v1/task/";
    private final HttpClient httpClient;
    private final URI location;
    private final URI taskUri;
    private final TaskId taskId;
    private final JsonCodec<TaskInfo> taskInfoCodec;
    private final JsonCodec<PlanFragment> planFragmentCodec;
    private final JsonCodec<BatchTaskUpdateRequest> taskUpdateRequestCodec;
    private final Duration infoRefreshMaxWait;

    public PrestoSparkHttpTaskClient(HttpClient httpClient, TaskId taskId, URI location, JsonCodec<TaskInfo> taskInfoCodec, JsonCodec<PlanFragment> planFragmentCodec, JsonCodec<BatchTaskUpdateRequest> taskUpdateRequestCodec, Duration infoRefreshMaxWait) {
        this.httpClient = Objects.requireNonNull(httpClient, "httpClient is null");
        this.taskId = Objects.requireNonNull(taskId, "taskId is null");
        this.location = Objects.requireNonNull(location, "location is null");
        this.taskInfoCodec = Objects.requireNonNull(taskInfoCodec, "taskInfoCodec is null");
        this.planFragmentCodec = Objects.requireNonNull(planFragmentCodec, "planFragmentCodec is null");
        this.taskUpdateRequestCodec = Objects.requireNonNull(taskUpdateRequestCodec, "taskUpdateRequestCodec is null");
        this.taskUri = this.getTaskUri(location, taskId);
        this.infoRefreshMaxWait = Objects.requireNonNull(infoRefreshMaxWait, "infoRefreshMaxWait is null");
    }

    public ListenableFuture<PageBufferClient.PagesResponse> getResults(long token, DataSize maxResponseSize) {
        URI uri = HttpUriBuilder.uriBuilderFrom((URI)this.taskUri).appendPath("/results/0").appendPath(String.valueOf(token)).build();
        return this.httpClient.executeAsync(Request.Builder.prepareGet().setHeader("X-Presto-Max-Size", maxResponseSize.toString()).setUri(uri).build(), (ResponseHandler)new HttpRpcShuffleClient.PageResponseHandler());
    }

    public void acknowledgeResultsAsync(long nextToken) {
        URI uri = HttpUriBuilder.uriBuilderFrom((URI)this.taskUri).appendPath("/results/0").appendPath(String.valueOf(nextToken)).appendPath("acknowledge").build();
        this.httpExecuteAsync(Request.Builder.prepareGet().setUri(uri).build(), null);
    }

    public ListenableFuture<?> abortResults() {
        return this.httpClient.executeAsync(Request.Builder.prepareDelete().setUri(HttpUriBuilder.uriBuilderFrom((URI)this.taskUri).appendPath("/results/0").build()).build(), (ResponseHandler)StatusResponseHandler.createStatusResponseHandler());
    }

    public Throwable rewriteException(Throwable throwable) {
        return null;
    }

    public ListenableFuture<BaseResponse<TaskInfo>> getTaskInfo() {
        Request request = RequestHelpers.setContentTypeHeaders((boolean)false, (Request.Builder)Request.Builder.prepareGet()).setHeader("X-Presto-Max-Wait", this.infoRefreshMaxWait.toString()).setUri(this.taskUri).build();
        return this.httpExecuteAsync(request, this.taskInfoCodec);
    }

    private <T> ListenableFuture<BaseResponse<T>> httpExecuteAsync(Request request, final JsonCodec<T> codec) {
        return this.httpClient.executeAsync(request, new ResponseHandler<BaseResponse<T>, RuntimeException>(){

            public BaseResponse<T> handleException(Request request, Exception exception) {
                throw ResponseHandlerUtils.propagate((Request)request, (Throwable)exception);
            }

            public BaseResponse<T> handle(Request request, Response response) {
                if (HttpStatus.familyForStatusCode((int)response.getStatusCode()) != HttpStatus.Family.SUCCESSFUL) {
                    throw new RuntimeException(String.format("Unexpected http response code: %s", response.getStatusCode()));
                }
                if (codec == null) {
                    return null;
                }
                try {
                    return AdaptingJsonResponseHandler.createAdaptingJsonResponseHandler((JsonCodec)codec).handle(request, response);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    public ListenableFuture<BaseResponse<TaskInfo>> updateTask(List<TaskSource> sources, PlanFragment planFragment, TableWriteInfo tableWriteInfo, Optional<String> shuffleWriteInfo, Session session, OutputBuffers outputBuffers) {
        Optional<byte[]> fragment = Optional.of(planFragment.toBytes(this.planFragmentCodec));
        Optional<TableWriteInfo> writeInfo = Optional.of(tableWriteInfo);
        TaskUpdateRequest updateRequest = new TaskUpdateRequest(session.toSessionRepresentation(), session.getIdentity().getExtraCredentials(), fragment, sources, outputBuffers, writeInfo);
        BatchTaskUpdateRequest batchTaskUpdateRequest = new BatchTaskUpdateRequest(updateRequest, shuffleWriteInfo);
        URI batchTaskUri = HttpUriBuilder.uriBuilderFrom((URI)this.taskUri).appendPath("batch").build();
        log.info(String.format("BatchTaskUpdate: \n %s", this.taskUpdateRequestCodec.toJson((Object)batchTaskUpdateRequest)));
        return this.httpClient.executeAsync(RequestHelpers.setContentTypeHeaders((boolean)false, (Request.Builder)Request.Builder.preparePost()).setUri(batchTaskUri).setBodyGenerator((BodyGenerator)StaticBodyGenerator.createStaticBodyGenerator((byte[])this.taskUpdateRequestCodec.toBytes((Object)batchTaskUpdateRequest))).build(), (ResponseHandler)AdaptingJsonResponseHandler.createAdaptingJsonResponseHandler(this.taskInfoCodec));
    }

    public URI getLocation() {
        return this.location;
    }

    private URI getTaskUri(URI baseUri, TaskId taskId) {
        return HttpUriBuilder.uriBuilderFrom((URI)baseUri).appendPath(TASK_URI).appendPath(taskId.toString()).build();
    }
}

