/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spark.execution.property;

import com.facebook.airlift.configuration.Config;
import com.google.common.collect.ImmutableMap;
import io.airlift.units.DataSize;
import java.util.Map;

public class NativeExecutionConnectorConfig {
    private static final String CACHE_ENABLED = "cache.enabled";
    private static final String CACHE_MAX_CACHE_SIZE = "cache.max-cache-size";
    private static final String CONNECTOR_NAME = "connector.name";
    private boolean cacheEnabled;
    private DataSize maxCacheSize = new DataSize(0.0, DataSize.Unit.MEGABYTE);
    private String connectorName = "hive";

    public Map<String, String> getAllProperties() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        return builder.put((Object)CACHE_ENABLED, (Object)String.valueOf(this.isCacheEnabled())).put((Object)CACHE_MAX_CACHE_SIZE, (Object)String.valueOf(this.getDataSizeInLong(this.getMaxCacheSize().convertTo(DataSize.Unit.MEGABYTE)))).put((Object)CONNECTOR_NAME, (Object)this.getConnectorName()).build();
    }

    public boolean isCacheEnabled() {
        return this.cacheEnabled;
    }

    @Config(value="cache.enabled")
    public NativeExecutionConnectorConfig setCacheEnabled(boolean cacheEnabled) {
        this.cacheEnabled = cacheEnabled;
        return this;
    }

    public DataSize getMaxCacheSize() {
        return this.maxCacheSize;
    }

    @Config(value="cache.max-cache-size")
    public NativeExecutionConnectorConfig setMaxCacheSize(DataSize maxCacheSize) {
        this.maxCacheSize = maxCacheSize;
        return this;
    }

    public String getConnectorName() {
        return this.connectorName;
    }

    @Config(value="connector.name")
    public NativeExecutionConnectorConfig setConnectorName(String connectorName) {
        this.connectorName = connectorName;
        return this;
    }

    private Long getDataSizeInLong(DataSize size) {
        return Double.valueOf(size.getValue()).longValue();
    }
}

