/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spark.planner.optimizers;

import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.cost.StatsProvider;
import com.facebook.presto.matching.Captures;
import com.facebook.presto.matching.Pattern;
import com.facebook.presto.spark.PrestoSparkSessionProperties;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.iterative.rule.DetermineJoinDistributionType;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.sql.planner.plan.Patterns;

public class PickJoinSides
implements Rule<JoinNode> {
    private static final Pattern<JoinNode> PATTERN = Patterns.join().matching(joinNode -> joinNode.getDistributionType().isPresent() && joinNode.getDistributionType().get() == JoinNode.DistributionType.PARTITIONED && (!joinNode.getCriteria().isEmpty() || joinNode.getType() != JoinNode.Type.LEFT && joinNode.getType() != JoinNode.Type.RIGHT));

    public Pattern<JoinNode> getPattern() {
        return PATTERN;
    }

    public boolean isEnabled(Session session) {
        return PrestoSparkSessionProperties.isAdaptiveJoinSideSwitchingEnabled(session);
    }

    public Rule.Result apply(JoinNode joinNode, Captures captures, Rule.Context context) {
        StatsProvider statsProvider = context.getStatsProvider();
        double leftSize = statsProvider.getStats(joinNode.getLeft()).getOutputSizeInBytes();
        double rightSize = statsProvider.getStats(joinNode.getRight()).getOutputSizeInBytes();
        if (rightSize > leftSize) {
            return Rule.Result.ofPlanNode((PlanNode)joinNode.flipChildren());
        }
        if (SystemSessionProperties.isSizeBasedJoinDistributionTypeEnabled((Session)context.getSession()) && (Double.isNaN(leftSize) || Double.isNaN(rightSize)) && this.isLeftSideSmall(joinNode, context)) {
            return Rule.Result.ofPlanNode((PlanNode)joinNode.flipChildren());
        }
        return Rule.Result.empty();
    }

    private boolean isLeftSideSmall(JoinNode joinNode, Rule.Context context) {
        boolean isRightSideSmall = DetermineJoinDistributionType.isBelowBroadcastLimit((PlanNode)joinNode.getRight(), (Rule.Context)context);
        boolean isLeftSideSmall = DetermineJoinDistributionType.isBelowBroadcastLimit((PlanNode)joinNode.getLeft(), (Rule.Context)context);
        if (isLeftSideSmall && !isRightSideSmall) {
            return true;
        }
        return DetermineJoinDistributionType.isSmallerThanThreshold((PlanNode)joinNode.getLeft(), (PlanNode)joinNode.getRight(), (Rule.Context)context);
    }
}

